/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2338;
import net.minecraft.class_2341;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2738;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_3726;
import net.minecraft.class_3737;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShelfFungiBlock
extends class_2341
implements class_3737,
class_2256 {
    public static final int GROWTH_BRIGHTNESS_OFFSET = 2;
    public static final int MAX_STAGE = 4;
    public static final int MAX_AGE = 2;
    public static final class_2758 AGE = class_2741.field_12556;
    public static final class_2758 STAGE = WWBlockStateProperties.FUNGUS_STAGE;
    public static final class_2746 WATERLOGGED = class_2741.field_12508;
    public static final MapCodec<ShelfFungiBlock> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5321.method_39154((class_5321)class_7924.field_50079).fieldOf("shearing_loot_table").forGetter(shelfFungiBlock -> shelfFungiBlock.shearingLootTable), (App)ShelfFungiBlock.method_54096()).apply((Applicative)instance, ShelfFungiBlock::new));
    protected static final class_265 NORTH_WALL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 SOUTH_WALL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final class_265 WEST_WALL_SHAPE = class_2248.method_9541((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final class_265 EAST_WALL_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final class_265 FLOOR_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)3.0, (double)16.0);
    protected static final class_265 CEILING_SHAPE = class_2248.method_9541((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final class_5321<class_52> shearingLootTable;

    public ShelfFungiBlock(class_5321<class_52> shearingLootTable, @NotNull class_4970.class_2251 settings) {
        super(settings);
        this.shearingLootTable = shearingLootTable;
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)field_11177, (Comparable)class_2350.field_11043)).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(1)));
    }

    protected boolean method_9542(class_2680 state) {
        return super.method_9542(state) || SnowloggingUtils.isSnowlogged(state);
    }

    @NotNull
    public static class_2738 getFace(@NotNull class_2350 direction) {
        if (direction.method_10166() == class_2350.class_2351.field_11052) {
            return direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475;
        }
        return class_2738.field_12471;
    }

    private static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)STAGE) == 4;
    }

    @NotNull
    protected MapCodec<? extends ShelfFungiBlock> method_53969() {
        return CODEC;
    }

    @NotNull
    public class_1269 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (stack.method_31574(class_1802.field_8868) && ShelfFungiBlock.onShear(level, pos, state, stack, (class_1297)player)) {
            stack.method_71012(1, (class_1309)player, hand);
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public static boolean onShear(class_1937 level, class_2338 pos, @NotNull class_2680 state, class_1799 stack, @Nullable class_1297 entity) {
        int stage = (Integer)state.method_11654((class_2769)STAGE);
        if (stage > 1) {
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(stage - 1)));
            level.method_8396(null, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
            if (level instanceof class_3218) {
                class_3218 serverLevel = (class_3218)level;
                ShelfFungiBlock.dropShelfFungi(serverLevel, stack, state, null, entity, pos);
            }
            level.method_33596(entity, (class_6880)class_5712.field_28730, pos);
            return true;
        }
        return false;
    }

    public static void dropShelfFungi(class_3218 level, class_1799 stack, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @Nullable class_1297 entity, class_2338 pos) {
        class_2248 class_22482 = state.method_26204();
        if (!(class_22482 instanceof ShelfFungiBlock)) {
            return;
        }
        ShelfFungiBlock shelfFungiBlock = (ShelfFungiBlock)class_22482;
        ShelfFungiBlock.method_72546((class_3218)level, shelfFungiBlock.getShearingLootTable(), (class_2680)state, (class_2586)blockEntity, (class_1799)stack, (class_1297)entity, (serverLevelx, itemStackx) -> ShelfFungiBlock.method_9577((class_1937)serverLevelx, (class_2338)pos, (class_1799)itemStackx));
    }

    public class_5321<class_52> getShearingLootTable() {
        return this.shearingLootTable;
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{field_11007, field_11177, AGE, STAGE, WATERLOGGED});
        SnowloggingUtils.appendSnowlogProperties(builder);
    }

    public boolean method_9616(@NotNull class_2680 state, @NotNull class_1750 context) {
        return !context.method_8046() && context.method_8041().method_31574(this.method_8389()) && (Integer)state.method_11654((class_2769)STAGE) < 4 || super.method_9616(state, context);
    }

    @Nullable
    public class_2680 method_9605(@NotNull class_1750 context) {
        boolean waterlogged;
        class_2680 insideState = context.method_8045().method_8320(context.method_8037());
        if (insideState.method_27852((class_2248)this)) {
            return (class_2680)insideState.method_11657((class_2769)STAGE, (Comparable)Integer.valueOf(Math.min(4, (Integer)insideState.method_11654((class_2769)STAGE) + 1)));
        }
        boolean bl = waterlogged = insideState.method_28498((class_2769)class_2741.field_12508) ? (Boolean)insideState.method_11654((class_2769)class_2741.field_12508) : false;
        if (!waterlogged) {
            waterlogged = context.method_8045().method_8316(context.method_8037()).method_15772() == class_3612.field_15910;
        }
        for (class_2350 direction : context.method_7718()) {
            class_2680 blockState = direction.method_10166() == class_2350.class_2351.field_11052 ? (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)(direction == class_2350.field_11036 ? class_2738.field_12473 : class_2738.field_12475))).method_11657((class_2769)field_11177, (Comparable)context.method_8042())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged)) : (class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)field_11007, (Comparable)class_2738.field_12471)).method_11657((class_2769)field_11177, (Comparable)direction.method_10153())).method_11657((class_2769)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
            if (!blockState.method_26184((class_4538)context.method_8045(), context.method_8037())) continue;
            return SnowloggingUtils.getSnowPlacementState(blockState, context);
        }
        return null;
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (((Boolean)blockState.method_11654((class_2769)WATERLOGGED)).booleanValue()) {
            scheduledTickAccess.method_64312(blockPos, (class_3611)class_3612.field_15910, class_3612.field_15910.method_15789(levelReader));
        }
        return super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
    }

    @NotNull
    public class_3610 method_9545(@NotNull class_2680 state) {
        return (Boolean)state.method_11654((class_2769)WATERLOGGED) != false ? class_3612.field_15910.method_15729(false) : super.method_9545(state);
    }

    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return switch ((class_2738)state.method_11654((class_2769)field_11007)) {
            default -> throw new MatchException(null, null);
            case class_2738.field_12475 -> FLOOR_SHAPE;
            case class_2738.field_12471 -> {
                switch ((class_2350)state.method_11654((class_2769)field_11177)) {
                    case field_11034: {
                        yield EAST_WALL_SHAPE;
                    }
                    case field_11039: {
                        yield WEST_WALL_SHAPE;
                    }
                    case field_11035: {
                        yield SOUTH_WALL_SHAPE;
                    }
                }
                yield NORTH_WALL_SHAPE;
            }
            case class_2738.field_12473 -> CEILING_SHAPE;
        };
    }

    public boolean isMaxAge(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 2;
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (random.method_43048(level.method_22339(pos) + 2) == 1) {
            if (!this.isMaxAge(state)) {
                level.method_8652(pos, (class_2680)state.method_28493((class_2769)AGE), 2);
            } else if (!ShelfFungiBlock.isFullyGrown(state)) {
                level.method_8652(pos, (class_2680)((class_2680)state.method_28493((class_2769)STAGE)).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 2);
            }
        }
    }

    public boolean method_9651(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return !ShelfFungiBlock.isFullyGrown(state);
    }

    public boolean method_9650(@NotNull class_1937 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return true;
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        level.method_8652(pos, (class_2680)((class_2680)state.method_28493((class_2769)STAGE)).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0)), 2);
    }

    public void method_9585(class_1936 level, class_2338 pos, class_2680 state) {
        if (SnowloggingUtils.isSnowlogged(state)) {
            super.method_9585(level, pos, SnowloggingUtils.getSnowEquivalent(state));
        } else {
            super.method_9585(level, pos, state);
        }
    }

    public void method_9556(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @NotNull class_1799 stack) {
        if (SnowloggingUtils.isSnowlogged(state)) {
            class_2680 snowEquivalent = SnowloggingUtils.getSnowEquivalent(state);
            if (player.method_7305(snowEquivalent)) {
                super.method_9556(level, player, pos, snowEquivalent, blockEntity, stack);
            }
        } else {
            super.method_9556(level, player, pos, state, blockEntity, stack);
        }
    }
}

