/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.datafix.minecraft;

import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixerBuilder;
import com.mojang.datafixers.schemas.Schema;
import net.fabricmc.loader.api.ModContainer;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.CopperHornInstrumentToTheCopperierAgeFix;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.DisplayLanternComponentizationFix;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.DisplayLanternItemComponentizationFix;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.MobBottleVariantComponentizationFix;
import net.frozenblock.wilderwild.datafix.minecraft.datafixers.MobBucketVariantComponentizationFix;
import net.minecraft.class_1220;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixerBuilder;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.QuiltDataFixes;
import org.quiltmc.qsl.frozenblock.misc.datafixerupper.api.SimpleFixes;

public final class WWMinecraftDataFixer {
    public static final int DATA_VERSION = 7;

    private WWMinecraftDataFixer() {
        throw new UnsupportedOperationException("WWMinecraftDataFixer contains only static declarations.");
    }

    public static void applyDataFixes(@NotNull ModContainer mod) {
        WWConstants.log("Applying Minecraft-Version-Based DataFixes for Wilder Wild with Data Version 7", true);
        QuiltDataFixerBuilder builder = new QuiltDataFixerBuilder(7);
        builder.addSchema(0, QuiltDataFixes.BASE_SCHEMA);
        Schema schemaV2 = builder.addSchema(2, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_grass to potted_short_grass", (class_2960)WWConstants.id("potted_grass"), (class_2960)WWConstants.id("potted_short_grass"), (Schema)schemaV2);
        Schema schemaV3 = builder.addSchema(3, class_1220::new);
        builder.addFixer((DataFix)new DisplayLanternComponentizationFix(schemaV3));
        builder.addFixer((DataFix)new DisplayLanternItemComponentizationFix(schemaV3));
        Schema schemaV4 = builder.addSchema(4, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Change wilderwild namespace to minecraft for wildflowers", (class_2960)WWConstants.id("wildflowers"), (class_2960)WWConstants.vanillaId("wildflowers"), (Schema)schemaV4);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Change wilderwild namespace to minecraft for wildflowers", (class_2960)WWConstants.id("wildflowers"), (class_2960)WWConstants.vanillaId("wildflowers"), (Schema)schemaV4);
        builder.addFixer((DataFix)new MobBottleVariantComponentizationFix(schemaV4, "Firefly Bottle Color componentization fix", WWConstants.id("firefly_bottle"), "FireflyBottleVariantTag", WWConstants.string("firefly/color")));
        builder.addFixer((DataFix)new MobBottleVariantComponentizationFix(schemaV4, "Butterfly Bottle Variant componentization fix", WWConstants.id("butterfly_bottle"), "ButterflyBottleVariantTag", WWConstants.string("butterfly/variant")));
        Schema schemaV5 = builder.addSchema(5, class_1220::new);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename bush to shrub", (class_2960)WWConstants.id("bush"), (class_2960)WWConstants.id("shrub"), (Schema)schemaV5);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Rename bush to shrub", (class_2960)WWConstants.id("bush"), (class_2960)WWConstants.id("shrub"), (Schema)schemaV5);
        SimpleFixes.addBlockRenameFix((DataFixerBuilder)builder, (String)"Rename potted_bush to potted_shrub", (class_2960)WWConstants.id("potted_bush"), (class_2960)WWConstants.id("potted_shrub"), (Schema)schemaV5);
        Schema schemaV6 = builder.addSchema(5, class_1220::new);
        builder.addFixer((DataFix)new MobBucketVariantComponentizationFix(schemaV6, "Crab Bucket Variant componentization fix", WWConstants.id("crab_bucket"), WWConstants.string("crab/variant")));
        builder.addFixer((DataFix)new MobBucketVariantComponentizationFix(schemaV6, "Jellyfish Bucket Variant componentization fix", WWConstants.id("jellyfish_bucket"), WWConstants.string("jellyfish/variant")));
        builder.addFixer((DataFix)new CopperHornInstrumentToTheCopperierAgeFix(schemaV6));
        Schema schemaV7 = builder.addSchema(7, class_1220::new);
        SimpleFixes.addItemRenameFix((DataFixerBuilder)builder, (String)"Migrate Copper Horns to The Copperier Age", (class_2960)WWConstants.id("copper_horn"), (class_2960)class_2960.method_60655((String)"thecopperierage", (String)"copper_horn"), (Schema)schemaV7);
        QuiltDataFixes.buildAndRegisterMinecraftFixer((ModContainer)mod, (QuiltDataFixerBuilder)builder);
        WWConstants.log("Minecraft-Version-Specific DataFixes for Wilder Wild have been applied", true);
    }
}

