/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.biome;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.biome.api.FrozenBiome;
import net.frozenblock.lib.worldgen.biome.api.parameters.Continentalness;
import net.frozenblock.lib.worldgen.biome.api.parameters.Humidity;
import net.frozenblock.lib.worldgen.biome.api.parameters.Temperature;
import net.frozenblock.lib.worldgen.biome.api.parameters.Weirdness;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.mod_compat.WWModIntegrations;
import net.frozenblock.wilderwild.worldgen.features.placed.WWCavePlaced;
import net.minecraft.class_1143;
import net.minecraft.class_1959;
import net.minecraft.class_2893;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3864;
import net.minecraft.class_4761;
import net.minecraft.class_4967;
import net.minecraft.class_4968;
import net.minecraft.class_5195;
import net.minecraft.class_5321;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FrozenCaves
extends FrozenBiome {
    public static final class_6544.class_6546 TEMPERATURE = Temperature.ICY;
    public static final class_6544.class_6546 HUMIDITY = Humidity.FULL_RANGE;
    public static final class_6544.class_6546 CONTINENTALNESS = class_6544.class_6546.method_38123((class_6544.class_6546)Continentalness.INLAND, (class_6544.class_6546)Continentalness.FAR_INLAND);
    public static final class_6544.class_6546 EROSION_PEAK = class_6544.class_6546.method_38121((float)-1.0f, (float)-0.6f);
    public static final class_6544.class_6546 WEIRDNESS_A = class_6544.class_6546.method_38123((class_6544.class_6546)Weirdness.HIGH_SLICE_NORMAL_ASCENDING, (class_6544.class_6546)Weirdness.HIGH_SLICE_NORMAL_DESCENDING);
    public static final class_6544.class_6546 WEIRDNESS_B = class_6544.class_6546.method_38123((class_6544.class_6546)Weirdness.HIGH_SLICE_VARIANT_ASCENDING, (class_6544.class_6546)Weirdness.HIGH_SLICE_VARIANT_DESCENDING);
    public static final ImmutableList<Float> DEPTHS = ImmutableList.of((Object)Float.valueOf(0.065f), (Object)Float.valueOf(0.1f), (Object)Float.valueOf(0.15f), (Object)Float.valueOf(0.2f), (Object)Float.valueOf(0.25f), (Object)Float.valueOf(0.3f), (Object)Float.valueOf(0.35f), (Object)Float.valueOf(0.4f));
    public static final float TEMP = -2.0f;
    public static final float DOWNFALL = 0.4f;
    public static final int WATER_COLOR = 10601471;
    public static final int WATER_FOG_COLOR = 8168948;
    public static final int FOG_COLOR = 12638463;
    public static final int SKY_COLOR = class_5478.method_30932((float)-2.0f);
    public static final FrozenCaves INSTANCE = new FrozenCaves();

    public String modID() {
        return "wilderwild";
    }

    public String biomeID() {
        return "frozen_caves";
    }

    public float temperature() {
        return -2.0f;
    }

    public float downfall() {
        return 0.4f;
    }

    public boolean hasPrecipitation() {
        return true;
    }

    public int skyColor() {
        return SKY_COLOR;
    }

    public int fogColor() {
        return 12638463;
    }

    public int waterColor() {
        return 10601471;
    }

    public int waterFogColor() {
        return 8168948;
    }

    @Nullable
    public Integer foliageColorOverride() {
        return null;
    }

    @Nullable
    public Integer dryFoliageColorOverride() {
        return null;
    }

    @Nullable
    public Integer grassColorOverride() {
        return null;
    }

    @Nullable
    public class_4761 ambientParticleSettings() {
        return null;
    }

    @Nullable
    public class_6880<class_3414> ambientLoopSound() {
        return null;
    }

    @NotNull
    public class_4968 ambientMoodSettings() {
        return class_4968.field_23146;
    }

    @Nullable
    public class_4967 ambientAdditionsSound() {
        return null;
    }

    @NotNull
    public class_5195 backgroundMusic() {
        return class_1143.method_27283((class_6880)class_3417.field_35349);
    }

    public void addFeatures(@NotNull class_5485.class_5495 features) {
        class_3864.method_16990((class_5485.class_5495)features);
        class_3864.method_32236((class_5485.class_5495)features);
        class_3864.method_17004((class_5485.class_5495)features);
        class_3864.method_17005((class_5485.class_5495)features);
        class_3864.method_16999((class_5485.class_5495)features);
        class_3864.method_17006((class_5485.class_5495)features, (boolean)false);
        class_3864.method_17010((class_5485.class_5495)features);
        class_3864.method_16982((class_5485.class_5495)features);
        class_3864.method_16983((class_5485.class_5495)features);
        features.method_30992(class_2893.class_2895.field_13176, WWCavePlaced.ORE_DIORITE_EXTRA.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.ICE_PATHS.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.FRAGILE_ICE_DISK.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.FRAGILE_ICE_PILE.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.HANGING_PACKED_ICE.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.ICE_PATCH_CEILING.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.FRAGILE_ICE_COLUMN_PATCH.getKey());
        features.method_30992(class_2893.class_2895.field_13177, WWCavePlaced.FRAGILE_ICE_PATCH.getKey());
        features.method_30992(class_2893.class_2895.field_13179, WWCavePlaced.DIORITE_PATCH.getKey());
        features.method_30992(class_2893.class_2895.field_13179, WWCavePlaced.DIORITE_PATCH_CEILING.getKey());
        features.method_30992(class_2893.class_2895.field_13179, WWCavePlaced.ICICLE_CLUSTER.getKey());
        features.method_30992(class_2893.class_2895.field_13179, WWCavePlaced.CAVE_ICICLES.getKey());
    }

    public void addSpawns(class_5483.class_5496 spawns) {
        class_3864.method_30582((class_5483.class_5496)spawns, (boolean)false);
    }

    public void injectToOverworld(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        if (WWModIntegrations.BIOLITH_INTEGRATION.modLoaded()) {
            return;
        }
        if (WWWorldgenConfig.get().biomeGeneration.generateFrozenCaves) {
            UnmodifiableIterator unmodifiableIterator = DEPTHS.iterator();
            while (unmodifiableIterator.hasNext()) {
                float depth = ((Float)unmodifiableIterator.next()).floatValue();
                this.addFrozenCavesAtDepth(parameters, depth);
            }
        }
    }

    public void addFrozenCavesAtDepth(@NotNull Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters, float depth) {
        Pair<class_6544.class_4762, class_6544.class_4762> biomeParameters = this.makeParametersAt(depth);
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)((class_6544.class_4762)biomeParameters.getFirst()), (Object)this.getKey()));
        parameters.accept((Pair<class_6544.class_4762, class_5321<class_1959>>)Pair.of((Object)((class_6544.class_4762)biomeParameters.getSecond()), (Object)this.getKey()));
    }

    @Contract(value="_ -> new")
    @NotNull
    public Pair<class_6544.class_4762, class_6544.class_4762> makeParametersAt(float depth) {
        return Pair.of((Object)class_6544.method_38118((class_6544.class_6546)TEMPERATURE, (class_6544.class_6546)HUMIDITY, (class_6544.class_6546)CONTINENTALNESS, (class_6544.class_6546)EROSION_PEAK, (class_6544.class_6546)class_6544.class_6546.method_38120((float)depth), (class_6544.class_6546)class_6544.class_6546.method_38123((class_6544.class_6546)Weirdness.HIGH_SLICE_NORMAL_ASCENDING, (class_6544.class_6546)Weirdness.HIGH_SLICE_NORMAL_DESCENDING), (float)(-depth)), (Object)class_6544.method_38118((class_6544.class_6546)TEMPERATURE, (class_6544.class_6546)HUMIDITY, (class_6544.class_6546)CONTINENTALNESS, (class_6544.class_6546)EROSION_PEAK, (class_6544.class_6546)class_6544.class_6546.method_38120((float)depth), (class_6544.class_6546)class_6544.class_6546.method_38123((class_6544.class_6546)Weirdness.HIGH_SLICE_VARIANT_ASCENDING, (class_6544.class_6546)Weirdness.HIGH_SLICE_VARIANT_DESCENDING), (float)(-depth)));
    }
}

