/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.model.NoOpModel;
import net.frozenblock.wilderwild.client.renderer.entity.state.FireflyRenderState;
import net.frozenblock.wilderwild.entity.Firefly;
import net.frozenblock.wilderwild.entity.variant.firefly.FireflyColor;
import net.minecraft.class_10017;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5617;
import net.minecraft.class_7833;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class FireflyRenderer
extends class_927<Firefly, FireflyRenderState, NoOpModel<FireflyRenderState>> {
    private static final class_2960 TEXTURE = WWConstants.id("textures/entity/firefly/firefly_base.png");
    private static final class_1921 LAYER = class_1921.method_23580((class_2960)TEXTURE);
    private static final float Y_OFFSET = 0.155f;
    private static final Quaternionf QUAT_180 = class_7833.field_40716.rotationDegrees(180.0f);

    public FireflyRenderer(class_5617.class_5618 context) {
        super(context, new NoOpModel(context.method_32167(WWModelLayers.FIREFLY)), 0.15f);
    }

    public static void submitFireflyWithoutRenderState(@NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, Quaternionf cameraOrientation, @NotNull FireflyColor color, float calcColor, float scale, float xOffset, float yOffset, float zOffset, int light, int overlay) {
        FireflyRenderer.setupPoseStack(poseStack, scale, xOffset, yOffset, zOffset, cameraOrientation);
        submitNodeCollector.method_73529(0).method_73483(poseStack, LAYER, (pose, vertexConsumer) -> FireflyRenderer.renderFireflyBase(pose, vertexConsumer, light, overlay));
        submitNodeCollector.method_73529(1).method_73483(poseStack, class_1921.method_42600((class_2960)color.resourceTexture().comp_3627()), (pose, vertexConsumer) -> FireflyRenderer.renderFireflyColor(pose, vertexConsumer, light, overlay, calcColor));
        poseStack.method_22909();
    }

    public static void submitFirefly(@NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, Quaternionf cameraOrientation, @NotNull FireflyRenderState renderState) {
        FireflyRenderer.setupPoseStack(poseStack, renderState.field_53453 * renderState.animScale, 0.0f, 0.155f, 0.0f, cameraOrientation);
        int light = renderState.field_61820;
        int overlay = FireflyRenderer.method_23622((class_10042)renderState, (float)0.0f);
        submitNodeCollector.method_73529(0).method_73483(poseStack, LAYER, (pose, vertexConsumer) -> FireflyRenderer.renderFireflyBase(pose, vertexConsumer, light, overlay));
        submitNodeCollector.method_73529(1).method_73483(poseStack, class_1921.method_42600((class_2960)renderState.color.resourceTexture().comp_3627()), (pose, vertexConsumer) -> FireflyRenderer.renderFireflyColor(pose, vertexConsumer, light, overlay, renderState.calcColor));
        poseStack.method_22909();
    }

    public static void renderFireflyBase(@NotNull class_4587.class_4665 pose, @NotNull class_4588 vertexConsumer, int packedLight, int overlay) {
        FireflyRenderer.render(pose, vertexConsumer, 1.0f, packedLight, overlay);
    }

    public static void renderFireflyColor(@NotNull class_4587.class_4665 pose, @NotNull class_4588 vertexConsumer, int packedLight, int overlay, float calcColor) {
        FireflyRenderer.render(pose, vertexConsumer, calcColor, packedLight, overlay);
    }

    public void submit(@NotNull FireflyRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        Quaternionf cameraOrientation = cameraRenderState.field_63081;
        FireflyRenderer.submitFirefly(poseStack, submitNodeCollector, cameraOrientation, renderState);
        if (renderState.field_53337 != null) {
            this.method_3926((class_10017)renderState, poseStack, submitNodeCollector, cameraRenderState);
        }
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull FireflyRenderState renderState) {
        return renderState.color.resourceTexture().comp_3627();
    }

    @NotNull
    public FireflyRenderState createRenderState() {
        return new FireflyRenderState();
    }

    public void extractRenderState(@NotNull Firefly entity, @NotNull FireflyRenderState renderState, float partialTick) {
        super.method_62355((class_1309)entity, (class_10042)renderState, partialTick);
        renderState.animScale = class_3532.method_16439((float)partialTick, (float)entity.getPrevAnimScale(), (float)entity.getAnimScale());
        renderState.color = entity.getColorForRendering();
        renderState.calcColor = ((float)entity.getFlickerAge() + partialTick) * (float)Math.PI * -4.0f / 255.0f;
    }

    private static void setupPoseStack(@NotNull class_4587 poseStack, float scale, float xOffset, float yOffset, float zOffset, Quaternionf rotation) {
        poseStack.method_22903();
        poseStack.method_22905(scale, scale, scale);
        poseStack.method_46416(xOffset, yOffset, zOffset);
        poseStack.method_22907((Quaternionfc)rotation);
        poseStack.method_22907((Quaternionfc)QUAT_180);
    }

    private static void render(class_4587.class_4665 pose, @NotNull class_4588 vertexConsumer, float color, int packedLight, int overlay) {
        vertexConsumer.method_56824(pose, -0.5f, -0.5f, 0.0f).method_22915(color, color, color, color).method_22913(0.0f, 1.0f).method_22922(overlay).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, 0.5f, -0.5f, 0.0f).method_22915(color, color, color, color).method_22913(1.0f, 1.0f).method_22922(overlay).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, 0.5f, 0.5f, 0.0f).method_22915(color, color, color, color).method_22913(1.0f, 0.0f).method_22922(overlay).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
        vertexConsumer.method_56824(pose, -0.5f, 0.5f, 0.0f).method_22915(color, color, color, color).method_22913(0.0f, 0.0f).method_22922(overlay).method_60803(packedLight).method_60831(pose, 0.0f, 1.0f, 0.0f);
    }
}

