/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.wilderwild.block.entity.TermiteMoundBlockEntity;
import net.frozenblock.wilderwild.block.termite.TermiteManager;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.minecraft.class_10225;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TermiteMoundBlock
extends class_2237 {
    public static final MapCodec<TermiteMoundBlock> CODEC = TermiteMoundBlock.method_54094(TermiteMoundBlock::new);
    public static final int MIN_PLACEMENT_TICK_DELAY = 40;
    public static final int MAX_PLACEMENT_TICK_DELAY = 200;
    public static final int MIN_TICK_DELAY = 90;
    public static final int MAX_TICK_DELAY = 150;
    public static final int MIN_AWAKE_LIGHT_LEVEL = 7;

    public TermiteMoundBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)WWBlockStateProperties.NATURAL, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WWBlockStateProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WWBlockStateProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends TermiteMoundBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new TermiteMoundBlockEntity(pos, state);
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{WWBlockStateProperties.NATURAL, WWBlockStateProperties.TERMITES_AWAKE, WWBlockStateProperties.CAN_SPAWN_TERMITE});
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 state, class_4538 level, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 random) {
        if (!TermiteManager.isStateSafeForTermites(neighborState)) {
            state = (class_2680)((class_2680)state.method_11657((class_2769)WWBlockStateProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(false))).method_11657((class_2769)WWBlockStateProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(false));
        }
        scheduledTickAccess.method_64310(blockPos, (class_2248)this, random.method_43051(40, 200));
        return state;
    }

    public void method_9615(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 oldState, boolean movedByPiston) {
        level.method_64310(pos, (class_2248)this, level.field_9229.method_43051(40, 200));
    }

    protected void method_66388(class_2680 state, class_3218 level, class_2338 pos, boolean bl) {
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof TermiteMoundBlockEntity) {
            TermiteMoundBlockEntity termiteMoundBlockEntity = (TermiteMoundBlockEntity)class_25862;
            termiteMoundBlockEntity.termiteManager.clearTermites((class_1937)level);
        }
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        class_2680 evaluatedState = this.evaluateMoundBlockStateAtPosition(state, (class_1937)level, pos);
        if (evaluatedState != state) {
            level.method_8501(pos, evaluatedState);
        }
        level.method_64310(pos, (class_2248)this, random.method_43051(90, 150));
    }

    public class_2680 evaluateMoundBlockStateAtPosition(@NotNull class_2680 moundState, class_1937 level, class_2338 pos) {
        boolean areTermitesSafe = TermiteManager.areTermitesSafe((class_4538)level, pos);
        boolean canAwaken = TermiteMoundBlock.canTermitesWaken(level, pos) && areTermitesSafe;
        return (class_2680)((class_2680)moundState.method_11657((class_2769)WWBlockStateProperties.TERMITES_AWAKE, (Comparable)Boolean.valueOf(canAwaken))).method_11657((class_2769)WWBlockStateProperties.CAN_SPAWN_TERMITE, (Comparable)Boolean.valueOf(areTermitesSafe));
    }

    public static boolean canTermitesWaken(@NotNull class_1937 level, @NotNull class_2338 pos) {
        return !TermiteMoundBlock.shouldTermitesSleep(level, TermiteMoundBlock.getLightLevel(level, pos));
    }

    public static boolean shouldTermitesSleep(@NotNull class_1937 level, int light) {
        return level.method_23886() && light < 7;
    }

    public static int getLightLevel(@NotNull class_1937 level, @NotNull class_2338 blockPos) {
        class_2338.class_2339 mutableBlockPos = blockPos.method_25503();
        int finalLight = 0;
        for (class_2350 direction : class_2350.values()) {
            mutableBlockPos.method_25505((class_2382)blockPos, direction);
            int newLight = !level.method_8419() ? level.method_22339((class_2338)mutableBlockPos) : level.method_8314(class_1944.field_9282, (class_2338)mutableBlockPos);
            finalLight = Math.max(finalLight, newLight);
        }
        return finalLight;
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return !level.field_9236 ? TermiteMoundBlock.method_31618(type, WWBlockEntityTypes.TERMITE_MOUND, (worldx, pos, statex, blockEntity) -> blockEntity.tickServer(worldx, pos, (Boolean)statex.method_11654((class_2769)WWBlockStateProperties.NATURAL), (Boolean)statex.method_11654((class_2769)WWBlockStateProperties.TERMITES_AWAKE), (Boolean)statex.method_11654((class_2769)WWBlockStateProperties.CAN_SPAWN_TERMITE))) : TermiteMoundBlock.method_31618(type, WWBlockEntityTypes.TERMITE_MOUND, (worldx, pos, statex, blockEntity) -> blockEntity.tickClient());
    }

    @NotNull
    public static class_2680 setTermiteEdibleIfPossible(@NotNull class_2680 state) {
        if (state.method_28498((class_2769)WWBlockStateProperties.TERMITE_EDIBLE)) {
            return (class_2680)state.method_11657((class_2769)WWBlockStateProperties.TERMITE_EDIBLE, (Comparable)Boolean.valueOf(true));
        }
        return state;
    }
}

