/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.impl;

import net.frozenblock.wilderwild.config.WWBlockConfig;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SnowloggingUtils {
    public static final class_2758 SNOW_LAYERS = WWBlockStateProperties.SNOW_LAYERS;
    public static final int MAX_LAYERS = 8;
    private static final boolean CONFIG_SNOWLOGGING_ON_BOOT = WWBlockConfig.get().snowlogging.snowlogging;
    private static final boolean CONFIG_SNOWLOG_BLOCKADES_ON_BOOT = WWBlockConfig.get().snowlogging.snowlogWalls;

    public static void appendSnowlogProperties(class_2689.class_2690<class_2248, class_2680> builder) {
        if (!CONFIG_SNOWLOGGING_ON_BOOT) {
            return;
        }
        builder.method_11667(new class_2769[]{SNOW_LAYERS});
    }

    public static void appendSnowlogPropertiesToBlockade(class_2689.class_2690<class_2248, class_2680> builder) {
        if (!CONFIG_SNOWLOGGING_ON_BOOT || !CONFIG_SNOWLOG_BLOCKADES_ON_BOOT) {
            return;
        }
        builder.method_11667(new class_2769[]{SNOW_LAYERS});
    }

    public static boolean supportsSnowlogging(@Nullable class_2680 state) {
        if (!WWBlockConfig.SNOWLOGGING) {
            return false;
        }
        return state != null && state.method_11656() != null && state.method_28498((class_2769)SNOW_LAYERS);
    }

    public static boolean canSnowlog(@Nullable class_2680 state) {
        return SnowloggingUtils.supportsSnowlogging(state) && state.method_26227().method_15769();
    }

    public static int getSnowLayers(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)SNOW_LAYERS);
    }

    public static boolean isSnowlogged(@Nullable class_2680 state) {
        return state != null && SnowloggingUtils.supportsSnowlogging(state) && SnowloggingUtils.getSnowLayers(state) > 0;
    }

    @NotNull
    public static class_2680 getSnowEquivalent(class_2680 state) {
        return (class_2680)class_2246.field_10477.method_9564().method_11657((class_2769)class_2741.field_12536, (Comparable)Integer.valueOf(Math.max(1, SnowloggingUtils.getSnowLayers(state))));
    }

    @Nullable
    public static class_2680 getStateWithoutSnow(@Nullable class_2680 state) {
        return SnowloggingUtils.isSnowlogged(state) ? (class_2680)state.method_11657((class_2769)SNOW_LAYERS, (Comparable)Integer.valueOf(0)) : state;
    }

    public static boolean isItemSnow(@Nullable class_1799 stack) {
        return stack != null && stack.method_31574(class_2246.field_10477.method_8389());
    }

    public static boolean canBeReplacedWithSnow(class_2680 state, class_1750 context) {
        int layers;
        return SnowloggingUtils.canSnowlog(state) && SnowloggingUtils.isItemSnow(context.method_8041()) && class_2246.field_10477.method_9558(class_2246.field_10477.method_9564(), (class_4538)context.method_8045(), context.method_8037()) && ((layers = SnowloggingUtils.getSnowLayers(state)) <= 0 || context.method_7717() && context.method_8038() == class_2350.field_11036 && layers < 8);
    }

    @Nullable
    public static class_2680 onUpdateShape(class_2680 state, class_4538 level, class_2338 pos) {
        class_2680 snowEquivalent;
        if (SnowloggingUtils.isSnowlogged(state) && !class_2246.field_10477.method_9558(snowEquivalent = SnowloggingUtils.getSnowEquivalent(state), level, pos)) {
            if (level instanceof class_1936) {
                class_1936 levelAccessor = (class_1936)level;
                levelAccessor.method_20290(2001, pos, class_2248.method_9507((class_2680)snowEquivalent));
            }
            state = (class_2680)state.method_11657((class_2769)SNOW_LAYERS, (Comparable)Integer.valueOf(0));
        }
        return state;
    }

    public static class_2680 getSnowPlacementState(class_2680 state, @NotNull class_1750 context) {
        return SnowloggingUtils.getSnowloggedState(state, context.method_8045().method_8320(context.method_8037()));
    }

    public static class_2680 getSnowloggedState(class_2680 state, class_2680 snowState) {
        int layers;
        if (state != null && snowState != null && SnowloggingUtils.canSnowlog(state) && snowState.method_27852(class_2246.field_10477) && (layers = ((Integer)snowState.method_11654((class_2769)class_2741.field_12536)).intValue()) < 8) {
            state = (class_2680)state.method_11657((class_2769)SNOW_LAYERS, (Comparable)Integer.valueOf(layers));
        }
        return state;
    }

    public static float getSnowDestroySpeed(class_2680 state, class_1922 level, class_2338 pos) {
        return SnowloggingUtils.getSnowEquivalent(state).method_26214(level, pos);
    }

    public static void onRandomTick(class_2680 state, class_3218 level, class_2338 pos) {
        if (SnowloggingUtils.isSnowlogged(state) && level.method_8314(class_1944.field_9282, pos) > 11) {
            class_2248.method_9497((class_2680)SnowloggingUtils.getSnowEquivalent(state), (class_1937)level, (class_2338)pos);
            level.method_8501(pos, (class_2680)state.method_11657((class_2769)SNOW_LAYERS, (Comparable)Integer.valueOf(0)));
        }
    }

    public static boolean isOriginalBlockCovered(class_2680 state, class_1922 level, class_2338 pos) {
        if (SnowloggingUtils.isSnowlogged(state)) {
            class_265 blockShape = state.method_26218(level, pos);
            class_265 snowLayerShape = SnowloggingUtils.getSnowEquivalent(state).method_26218(level, pos);
            return blockShape.method_1105(class_2350.class_2351.field_11052) <= snowLayerShape.method_1105(class_2350.class_2351.field_11052);
        }
        return false;
    }
}

