/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity.ai.butterfly;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.frozenblock.wilderwild.entity.Butterfly;
import net.frozenblock.wilderwild.entity.FlowerCow;
import net.frozenblock.wilderwild.entity.ai.ValidateOrSetHome;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4110;
import net.minecraft.class_4112;
import net.minecraft.class_4115;
import net.minecraft.class_4118;
import net.minecraft.class_4119;
import net.minecraft.class_4120;
import net.minecraft.class_4125;
import net.minecraft.class_4140;
import net.minecraft.class_4148;
import net.minecraft.class_4149;
import net.minecraft.class_4168;
import net.minecraft.class_4208;
import net.minecraft.class_4818;
import net.minecraft.class_5321;
import net.minecraft.class_5753;
import net.minecraft.class_7297;
import org.jetbrains.annotations.NotNull;

public class ButterflyAi {
    protected static final List<class_4149<? extends class_4148<? super Butterfly>>> SENSOR_TYPES = List.of(class_4149.field_18466);
    protected static final List<class_4140<?>> MEMORY_TYPES = List.of(class_4140.field_18449, class_4140.field_18442, class_4140.field_18445, class_4140.field_19293, class_4140.field_18446, class_4140.field_18438, WWMemoryModuleTypes.NATURAL, WWMemoryModuleTypes.HOME_VALIDATE_COOLDOWN);

    private ButterflyAi() {
    }

    @NotNull
    public static class_4095.class_5303<Butterfly> brainProvider() {
        return class_4095.method_28311(MEMORY_TYPES, SENSOR_TYPES);
    }

    public static void setNatural(@NotNull Butterfly butterfly) {
        butterfly.method_18868().method_18878(WWMemoryModuleTypes.NATURAL, (Object)true);
    }

    @NotNull
    public static class_4095<?> makeBrain(@NotNull Butterfly butterfly, @NotNull class_4095<Butterfly> brain) {
        ButterflyAi.addCoreActivities(brain);
        ButterflyAi.addIdleActivities(butterfly, brain);
        brain.method_18890((Set)ImmutableSet.of((Object)class_4168.field_18594));
        brain.method_18897(class_4168.field_18595);
        brain.method_24536();
        return brain;
    }

    private static void addCoreActivities(@NotNull class_4095<Butterfly> brain) {
        brain.method_18882(class_4168.field_18594, 0, ImmutableList.of((Object)new class_4125(0.8f), (Object)new class_4110(45, 90), (Object)new class_4112(), ValidateOrSetHome.create(), (Object)new class_5753(WWMemoryModuleTypes.HOME_VALIDATE_COOLDOWN)));
    }

    private static void addIdleActivities(@NotNull Butterfly butterfly, @NotNull class_4095<Butterfly> brain) {
        brain.method_18881(class_4168.field_18595, ImmutableList.of((Object)Pair.of((Object)1, (Object)class_7297.method_47130(ButterflyAi::getHomeTarget, entity -> true, (int)7, (int)16, (float)1.0f)), (Object)Pair.of((Object)2, (Object)class_7297.method_47130(ButterflyAi::getLookTarget, entity -> true, (int)5, (int)5, (float)1.0f)), (Object)Pair.of((Object)3, (Object)class_4119.method_47065(livingEntity -> {
            FlowerCow flowerCow;
            return livingEntity.method_5805() && !livingEntity.method_7325() && livingEntity instanceof FlowerCow && (flowerCow = (FlowerCow)((Object)livingEntity)).hasFlowersLeft() && !flowerCow.method_6109();
        }, (float)8.0f)), (Object)Pair.of((Object)4, (Object)new class_4118((List)ImmutableList.of((Object)Pair.of((Object)class_4818.method_47025((float)1.0f), (Object)2), (Object)Pair.of((Object)class_4120.method_47104((float)1.0f, (int)3), (Object)2))))));
    }

    public static void updateActivities(@NotNull Butterfly butterfly) {
        butterfly.method_18868().method_24531(List.of(class_4168.field_18595));
    }

    public static void rememberHome(@NotNull class_1309 butterfly, @NotNull class_2338 pos) {
        butterfly.method_18868().method_18878(class_4140.field_18438, (Object)class_4208.method_19443((class_5321)butterfly.method_37908().method_27983(), (class_2338)pos));
    }

    private static boolean shouldGoTowardsHome(@NotNull class_1309 butterfly, @NotNull class_4208 pos) {
        return ((Butterfly)butterfly).hasHome() && butterfly.method_37908().method_27983() == pos.comp_2207();
    }

    @NotNull
    private static Optional<class_4115> getHomeTarget(@NotNull class_1309 butterfly) {
        class_4208 globalPos;
        Optional home = butterfly.method_18868().method_18904(class_4140.field_18438);
        if (home.isPresent() && ButterflyAi.shouldGoTowardsHome(butterfly, globalPos = (class_4208)home.get())) {
            return Optional.of(new class_4099(ButterflyAi.randomPosAround(globalPos.comp_2208(), butterfly.method_37908())));
        }
        return Optional.empty();
    }

    @NotNull
    private static Optional<class_4115> getLookTarget(@NotNull class_1309 butterfly) {
        return butterfly.method_18868().method_18904(class_4140.field_18446);
    }

    @NotNull
    private static class_2338 randomPosAround(@NotNull class_2338 pos, @NotNull class_1937 level) {
        return pos.method_10069(level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7), level.field_9229.method_39332(-7, 7));
    }
}

