/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.networking;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.frozenblock.lib.math.api.AdvancedMath;
import net.frozenblock.wilderwild.block.entity.StoneChestBlockEntity;
import net.frozenblock.wilderwild.block.impl.FallingLeafUtil;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.networking.packet.WWJellyfishStingPacket;
import net.frozenblock.wilderwild.networking.packet.WWLeavesExplosionParticlePacket;
import net.frozenblock.wilderwild.networking.packet.WWLightningStrikePacket;
import net.frozenblock.wilderwild.networking.packet.WWScorchingFirePlacePacket;
import net.frozenblock.wilderwild.networking.packet.WWStoneChestLidPacket;
import net.frozenblock.wilderwild.networking.packet.WWWindPacket;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.wind.WWClientWindManager;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_702;
import net.minecraft.class_703;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class WWClientNetworking {
    public static void registerPacketReceivers() {
        WWClientNetworking.receiveWindExtensionSyncPacket();
        WWClientNetworking.receiveJellyfishStingPacket();
        WWClientNetworking.receiveLightningStrikePacket();
        WWClientNetworking.receiveStoneChestLidPacket();
        WWClientNetworking.receiveScorchingFirePlacePacket();
        WWClientNetworking.receiveLeavesExplosionPacket();
    }

    public static void receiveWindExtensionSyncPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWWindPacket.PACKET_TYPE, (packet, ctx) -> {
            class_243 cloudPos = packet.cloudPos();
            WWClientWindManager.cloudX = cloudPos.method_10216();
            WWClientWindManager.cloudY = cloudPos.method_10214();
            WWClientWindManager.cloudZ = cloudPos.method_10215();
        });
    }

    public static void receiveJellyfishStingPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWJellyfishStingPacket.PACKET_TYPE, (packet, ctx) -> {
            class_746 player = class_310.method_1551().field_1724;
            class_638 clientLevel = ctx.client().field_1687;
            clientLevel.method_43128((class_1297)player, player.method_23317(), player.method_23318(), player.method_23321(), WWSounds.ENTITY_JELLYFISH_STING, class_3419.field_15254, 1.0f, packet.isBaby() ? 1.2f : 1.0f);
        });
    }

    public static void receiveLightningStrikePacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWLightningStrikePacket.PACKET_TYPE, (packet, ctx) -> {
            class_2680 blockState = class_2248.method_9531((int)packet.blockStateId());
            if (blockState.method_26215()) {
                return;
            }
            class_310 minecraft = class_310.method_1551();
            class_638 clientLevel = ctx.client().field_1687;
            class_5819 random = clientLevel.method_8409();
            WWEntityConfig.LightningConfig lightningConfig = WWEntityConfig.get().lightning;
            if (lightningConfig.lightningBlockParticles) {
                WWClientNetworking.lightningBlockParticles(packet.tickCount(), packet.x(), packet.y(), packet.z(), blockState, random, minecraft.field_1713);
            }
            if (lightningConfig.lightningSmokeParticles) {
                WWClientNetworking.lightningSmokeParticles(packet.tickCount(), packet.x(), packet.y(), packet.z(), blockState, random, minecraft.field_1713);
            }
        });
    }

    public static void receiveStoneChestLidPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWStoneChestLidPacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 clientLevel = ctx.client().field_1687;
            class_2586 patt0$temp = clientLevel.method_8321(packet.pos());
            if (!(patt0$temp instanceof StoneChestBlockEntity)) {
                return;
            }
            StoneChestBlockEntity stoneChestBlockEntity = (StoneChestBlockEntity)patt0$temp;
            stoneChestBlockEntity.prevOpenProgress = packet.prevOpenProgress();
            stoneChestBlockEntity.openProgress = packet.openProgress();
            stoneChestBlockEntity.highestLidPoint = packet.highestLidPoint();
            stoneChestBlockEntity.cooldownTicks = packet.cooldownTicks();
            stoneChestBlockEntity.stillLidTicks = packet.stillLidTicks();
            stoneChestBlockEntity.closing = packet.closing();
        });
    }

    public static void receiveScorchingFirePlacePacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWScorchingFirePlacePacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 clientLevel = ctx.client().field_1687;
            class_5819 randomSource = clientLevel.field_9229;
            class_2338 pos = packet.pos();
            for (int particles = 0; particles < 10; ++particles) {
                clientLevel.method_8406((class_2394)class_2398.field_11237, (double)pos.method_10263() + randomSource.method_43058(), (double)pos.method_10264() + randomSource.method_43058(), (double)pos.method_10260() + randomSource.method_43058(), randomSource.method_43059() * 0.04, randomSource.method_43059() * 0.05, randomSource.method_43059() * 0.04);
            }
            clientLevel.method_45446(pos, WWSounds.BLOCK_FIRE_IGNITE, class_3419.field_15245, 0.5f, (randomSource.method_43057() - randomSource.method_43057()) * 0.2f + 1.0f, true);
        });
    }

    private static void lightningBlockParticles(int tickCount, double x, double y, double z, @NotNull class_2680 blockState, @NotNull class_5819 random, @NotNull class_702 particleEngine) {
        if (blockState.method_26164(WWBlockTags.NO_LIGHTNING_BLOCK_PARTICLES)) {
            return;
        }
        boolean first = tickCount == 0;
        double calmDownAge = Math.max(1.0, (double)tickCount - 6.0);
        class_243 origin = new class_243(x, y, z);
        int particles = first ? random.method_43051(25, 40) : random.method_43051(5, 15);
        double rotAngle = 360.0 / (double)particles;
        double angle = random.method_43058() * 360.0;
        class_2388 particleOptions = new class_2388(class_2398.field_11217, blockState);
        if (blockState.method_27852(class_2246.field_10382)) {
            particleOptions = class_2398.field_11202;
        } else if (blockState.method_27852(class_2246.field_10164)) {
            particleOptions = class_2398.field_11239;
        }
        double speedMultiplier = first ? 1.5 : 1.0;
        double speedMultiplierY = first ? 1.13 : 1.0;
        for (int a = 0; a < particles; ++a) {
            class_703 particle2;
            double dirZ;
            class_243 offsetPos = AdvancedMath.rotateAboutXZ((class_243)origin, (double)0.4, (double)(angle + random.method_43058() * rotAngle * 0.35 * (random.method_43056() ? 1.0 : -1.0)));
            double dirX = (offsetPos.field_1352 - origin.field_1352) * ((double)random.method_43057() * 0.6 + 0.4);
            class_703 blockParticle = particleEngine.method_3056((class_2394)particleOptions, x + dirX, y, z + (dirZ = (offsetPos.field_1350 - origin.field_1350) * ((double)random.method_43057() * 0.6 + 0.4)), 0.0, 0.0, 0.0);
            if (blockParticle != null) {
                blockParticle.field_3852 = dirX * 0.8 / calmDownAge * speedMultiplier;
                blockParticle.field_3869 = 0.4 / calmDownAge * ((double)random.method_43057() * 0.4 + 0.7) * speedMultiplierY;
                blockParticle.field_3850 = dirZ * 0.8 / calmDownAge * speedMultiplier;
            }
            if (random.method_43056() && (particle2 = particleEngine.method_3056((class_2394)class_2398.field_11237, x + dirX * 0.3, y, z + dirZ * 0.3, 0.0, 0.0, 0.0)) != null) {
                particle2.field_3852 = dirX * 0.2 / calmDownAge * speedMultiplier;
                particle2.field_3869 = 0.5 / calmDownAge * ((double)random.method_43057() * 0.4 + 0.7) * speedMultiplierY;
                particle2.field_3850 = dirZ * 0.2 / calmDownAge * speedMultiplier;
            }
            angle += rotAngle;
        }
    }

    private static void lightningSmokeParticles(int tickCount, double x, double y, double z, @NotNull class_2680 blockState, @NotNull class_5819 random, @NotNull class_702 particleEngine) {
        if (blockState.method_26164(WWBlockTags.NO_LIGHTNING_SMOKE_PARTICLES)) {
            return;
        }
        boolean first = tickCount == 0;
        class_243 origin = new class_243(x, y, z);
        int particles = random.method_43051(2, 15);
        double rotAngle = 360.0 / (double)particles;
        double angle = random.method_43058() * 360.0;
        double speedMultiplier = first ? 1.5 : 1.0;
        double speedMultiplierY = first ? 1.13 : 1.0;
        for (int a = 0; a < particles; ++a) {
            class_703 particle2;
            class_243 offsetPos = AdvancedMath.rotateAboutXZ((class_243)origin, (double)0.4, (double)(angle + random.method_43058() * rotAngle * 0.35 * (random.method_43056() ? 1.0 : -1.0)));
            double dirX = (offsetPos.field_1352 - origin.field_1352) * ((double)random.method_43057() * 0.6 + 0.4) / (double)tickCount;
            double dirZ = (offsetPos.field_1350 - origin.field_1350) * ((double)random.method_43057() * 0.6 + 0.4) / (double)tickCount;
            if (random.method_43056() && (particle2 = particleEngine.method_3056((class_2394)class_2398.field_11237, x + dirX * 0.3, y, z + dirZ * 0.3, 0.0, 0.0, 0.0)) != null) {
                particle2.field_3852 = dirX * 0.2 * speedMultiplier;
                particle2.field_3869 = 0.5 / (double)tickCount * ((double)random.method_43057() * 0.4 + 0.7) * speedMultiplierY;
                particle2.field_3850 = dirZ * 0.2 * speedMultiplier;
            }
            angle += rotAngle;
        }
    }

    public static void receiveLeavesExplosionPacket() {
        ClientPlayNetworking.registerGlobalReceiver(WWLeavesExplosionParticlePacket.PACKET_TYPE, (packet, ctx) -> {
            class_638 clientLevel = ctx.client().field_1687;
            FallingLeafUtil.clientSpawnExplosionParticlesFromPacket((class_1937)clientLevel, packet);
        });
    }
}

