/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.worldgen.impl.trunk.branch.TrunkBranchPlacement;
import net.frozenblock.wilderwild.worldgen.impl.util.TrunkPlacerHelper;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2944;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import net.minecraft.class_6019;
import org.jetbrains.annotations.NotNull;

public class FallenWithBranchesTrunkPlacer
extends class_5141 {
    private static final class_6017 STUMP_DISTANCE_FROM_TRUNK = class_6019.method_35017((int)1, (int)3);
    private static final float TWO_TALL_STUMP_CHANCE = 0.2f;
    private static final int STUMP_MAX_SEARCH_POSITIVE_Y = 8;
    private static final int STUMP_MAX_SEARCH_NEGATIVE_Y = 2;
    public static final MapCodec<FallenWithBranchesTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> FallenWithBranchesTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("success_in_water_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.successInWaterChance))).and((App)class_4651.field_24937.fieldOf("hollowed_trunk_provider").forGetter(trunkPlacer -> trunkPlacer.hollowedTrunkProvider)).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("hollowed_log_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.hollowedLogChance))).and((App)TrunkBranchPlacement.CODEC.fieldOf("trunk_branch_placement").forGetter(trunkPlacer -> trunkPlacer.trunkBranchPlacement)).and((App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("stump_placement_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.stumpPlacementChance))).apply((Applicative)instance, FallenWithBranchesTrunkPlacer::new));
    public final float successInWaterChance;
    public final class_4651 hollowedTrunkProvider;
    public final float hollowedLogChance;
    public final TrunkBranchPlacement trunkBranchPlacement;
    public final float stumpPlacementChance;

    public FallenWithBranchesTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, float successInWaterChance, class_4651 hollowedTrunkProvider, float hollowedLogProbability, TrunkBranchPlacement trunkBranchPlacement, float stumpPlacementChance) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.successInWaterChance = successInWaterChance;
        this.hollowedTrunkProvider = hollowedTrunkProvider;
        this.hollowedLogChance = hollowedLogProbability;
        this.trunkBranchPlacement = trunkBranchPlacement;
        this.stumpPlacementChance = stumpPlacementChance;
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return WWFeatures.FALLEN_WITH_BRANCHES_TRUNK_PLACER;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        Optional<class_2338.class_2339> optionalStumpPos;
        ArrayList foliageAttachments = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_4651 blockStateProvider = WWWorldgenConfig.GENERATED_HOLLOWED_FALLEN_TREES && random.method_43057() <= this.hollowedLogChance ? this.hollowedTrunkProvider : config.field_21288;
        int maxBranches = this.trunkBranchPlacement.getMaxBranchCount(random);
        class_2350 trunkDirection = class_2350.class_2353.field_11062.method_10183(random);
        int generatedBranches = 0;
        if (TrunkPlacerHelper.isWaterAt(level, startPos) && random.method_43057() >= this.successInWaterChance) {
            return foliageAttachments;
        }
        class_2338 endPos = startPos.method_10079(trunkDirection, height);
        class_2338 secondToEndPos = endPos.method_10093(trunkDirection.method_10153());
        int aboveSolidAmount = 0;
        boolean isEndAboveSolid = false;
        Iterable poses = class_2338.method_10097((class_2338)startPos, (class_2338)endPos);
        for (class_2338 blockPos : poses) {
            mutable.method_10101((class_2382)blockPos);
            if (class_2944.method_27371((class_3746)level, (class_2338)mutable)) {
                if (FallenWithBranchesTrunkPlacer.isPosSolidGround(level, (class_2338)mutable.method_10098(class_2350.field_11033))) {
                    ++aboveSolidAmount;
                    mutable.method_10098(class_2350.field_11036);
                    if (!mutable.equals((Object)endPos) && !mutable.equals((Object)secondToEndPos)) continue;
                    isEndAboveSolid = true;
                    continue;
                }
                mutable.method_10098(class_2350.field_11036);
                if (!mutable.equals((Object)startPos)) continue;
                return foliageAttachments;
            }
            return foliageAttachments;
        }
        if (isEndAboveSolid || (double)aboveSolidAmount / (double)height > 0.5) {
            for (class_2338 blockPos : poses) {
                class_2350 branchDirection;
                mutable.method_10101((class_2382)blockPos);
                this.placeLog(level, replacer, random, blockStateProvider, mutable, trunkDirection);
                if (!this.trunkBranchPlacement.canPlaceBranch(random) || generatedBranches >= maxBranches) continue;
                class_2350 class_23502 = branchDirection = random.method_43057() <= 0.66f ? class_2350.class_2353.field_11062.method_10183(random) : class_2350.class_2353.field_11064.method_10183(random);
                if (trunkDirection.method_10166() != branchDirection.method_10166()) {
                    this.trunkBranchPlacement.generateExtraBranchForFallenLog(level, replacer, random, blockStateProvider, (class_2338)mutable, branchDirection, trunkDirection);
                }
                ++generatedBranches;
            }
        }
        if (random.method_43057() <= this.stumpPlacementChance && (optionalStumpPos = this.findStumpPos(level, random, startPos, trunkDirection)).isPresent()) {
            class_2338.class_2339 stumpPos = optionalStumpPos.get();
            this.method_35375(level, replacer, random, (class_2338)stumpPos, config);
            if (random.method_43057() <= 0.2f) {
                this.method_35375(level, replacer, random, (class_2338)stumpPos.method_10098(class_2350.field_11036), config);
            }
        }
        return foliageAttachments;
    }

    private Optional<class_2338.class_2339> findStumpPos(class_3746 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2350 trunkDirection) {
        int step;
        class_2338.class_2339 aboveStumpPos;
        int distance = STUMP_DISTANCE_FROM_TRUNK.method_35008(random);
        class_2350 stumpSearchDirection = trunkDirection.method_10153();
        class_2338.class_2339 stumpPos = (pos = pos.method_10079(stumpSearchDirection, 1 + distance)).method_25503();
        class_2338.class_2339 belowStumpPos = stumpPos.method_25503().method_10098(class_2350.field_11033);
        if (FallenWithBranchesTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos, (class_2338)(aboveStumpPos = stumpPos.method_25503().method_10098(class_2350.field_11036)))) {
            return Optional.of(stumpPos);
        }
        for (step = 1; step <= 8; ++step) {
            stumpPos.method_10098(class_2350.field_11036);
            FallenWithBranchesTrunkPlacer.setBelowAndAbovePoses((class_2338)stumpPos, belowStumpPos, aboveStumpPos);
            if (!FallenWithBranchesTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos, (class_2338)aboveStumpPos)) continue;
            return Optional.of(stumpPos);
        }
        stumpPos.method_10101((class_2382)pos);
        for (step = 1; step <= 2; ++step) {
            stumpPos.method_10098(class_2350.field_11033);
            FallenWithBranchesTrunkPlacer.setBelowAndAbovePoses((class_2338)stumpPos, belowStumpPos, aboveStumpPos);
            if (!FallenWithBranchesTrunkPlacer.canPlaceStumpAtPos(level, (class_2338)belowStumpPos, (class_2338)stumpPos, (class_2338)aboveStumpPos)) continue;
            return Optional.of(stumpPos);
        }
        return Optional.empty();
    }

    private static boolean canPlaceStumpAtPos(class_3746 level, @NotNull class_2338 floorPos, class_2338 pos, class_2338 abovePos) {
        return FallenWithBranchesTrunkPlacer.isPosSolidGround(level, floorPos) && level.method_16358(floorPos, blockState -> blockState.method_26164(WWBlockTags.FALLEN_TREE_STUMP_PLACEABLE_ON)) && class_2944.method_27371((class_3746)level, (class_2338)pos) && class_2944.method_27371((class_3746)level, (class_2338)abovePos);
    }

    private static boolean isPosSolidGround(class_3746 level, @NotNull class_2338 pos) {
        return !class_2944.method_27371((class_3746)level, (class_2338)pos) && !class_2944.method_16420((class_3746)level, (class_2338)pos);
    }

    private void placeLog(class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, @NotNull class_4651 blockStateProvider, @NotNull class_2338.class_2339 pos, @NotNull class_2350 trunkDirection) {
        class_2680 placementState = TrunkPlacerHelper.getLogBlockState(level, blockStateProvider, (class_2338)pos, trunkDirection, random);
        replacer.accept((class_2338)pos, placementState);
    }

    private static void setBelowAndAbovePoses(class_2338 pos, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2338.class_2339 belowPos, // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull class_2338.class_2339 abovePos) {
        belowPos.method_25505((class_2382)pos, class_2350.field_11033);
        abovePos.method_25505((class_2382)pos, class_2350.field_11036);
    }
}

