/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.impl.trunk;

import com.google.common.collect.Lists;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.frozenblock.wilderwild.registry.WWFeatures;
import net.frozenblock.wilderwild.worldgen.impl.trunk.branch.TrunkBranchPlacement;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_3746;
import net.minecraft.class_4643;
import net.minecraft.class_4647;
import net.minecraft.class_5141;
import net.minecraft.class_5142;
import net.minecraft.class_5819;
import net.minecraft.class_6017;
import org.jetbrains.annotations.NotNull;

public class WillowTrunkPlacer
extends class_5141 {
    public static final MapCodec<WillowTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(instance -> WillowTrunkPlacer.method_28904((RecordCodecBuilder.Instance)instance).and(instance.group((App)class_6017.field_33450.fieldOf("trunk_split_height").forGetter(trunkPlacer -> trunkPlacer.trunkSplitHeight), (App)Codec.floatRange((float)0.0f, (float)1.0f).fieldOf("branch_split_gap_chance").forGetter(trunkPlacer -> Float.valueOf(trunkPlacer.branchSplitGapChance)), (App)TrunkBranchPlacement.CODEC.fieldOf("trunk_branch_placement").forGetter(trunkPlacer -> trunkPlacer.trunkBranchPlacement))).apply((Applicative)instance, WillowTrunkPlacer::new));
    private final class_6017 trunkSplitHeight;
    private final float branchSplitGapChance;
    private final TrunkBranchPlacement trunkBranchPlacement;

    public WillowTrunkPlacer(int baseHeight, int firstRandomHeight, int secondRandomHeight, @NotNull class_6017 trunkSplitHeight, float branchSplitGapChance, TrunkBranchPlacement trunkBranchPlacement) {
        super(baseHeight, firstRandomHeight, secondRandomHeight);
        this.trunkSplitHeight = trunkSplitHeight;
        this.branchSplitGapChance = branchSplitGapChance;
        this.trunkBranchPlacement = trunkBranchPlacement;
    }

    @NotNull
    protected class_5142<?> method_28903() {
        return WWFeatures.WILLOW_TRUNK_PLACER;
    }

    @NotNull
    public List<class_4647.class_5208> method_26991(@NotNull class_3746 level, @NotNull BiConsumer<class_2338, class_2680> replacer, @NotNull class_5819 random, int height, @NotNull class_2338 startPos, @NotNull class_4643 config) {
        WillowTrunkPlacer.method_27400((class_3746)level, replacer, (class_5819)random, (class_2338)startPos.method_10074(), (class_4643)config);
        ArrayList foliageAttachments = Lists.newArrayList();
        class_2338.class_2339 mutable = new class_2338.class_2339();
        class_2338.class_2339 branchMutable = new class_2338.class_2339();
        int splitHeight = this.trunkSplitHeight.method_35008(random);
        int xOffset = 0;
        int zOffset = 0;
        for (int i = 0; i < height; ++i) {
            mutable.method_25504((class_2382)startPos, xOffset, i, zOffset);
            if (i == splitHeight) {
                class_2350 splitDirection = class_2350.class_2353.field_11062.method_10183(random);
                class_2338 splitPos = mutable.method_10062();
                mutable.method_25504((class_2382)startPos, xOffset += splitDirection.method_10148(), i, zOffset += splitDirection.method_10165());
                for (class_2350 branchDirection : class_2350.class_2353.field_11062.method_43342(random)) {
                    if (!this.trunkBranchPlacement.canPlaceBranch(random)) continue;
                    if (random.method_43057() <= this.branchSplitGapChance && splitDirection != branchDirection) {
                        branchMutable.method_10101((class_2382)splitPos);
                    } else {
                        branchMutable.method_10101((class_2382)mutable);
                    }
                    this.trunkBranchPlacement.generateExtraBranch(level, replacer, random, config.field_21288, branchMutable.method_10062(), branchDirection, foliageAttachments);
                }
            }
            this.method_35375(level, replacer, random, (class_2338)mutable, config);
            if (i != height - 1) continue;
            foliageAttachments.add(new class_4647.class_5208((class_2338)mutable.method_25504((class_2382)startPos, xOffset, i + 1, zOffset), 0, false));
        }
        return foliageAttachments;
    }
}

