/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.wilderwild.block.AlgaeBlock;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWParticleTypes;
import net.minecraft.class_10774;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2400;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2746;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3726;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;

public class PlanktonBlock
extends AlgaeBlock {
    public static final MapCodec<PlanktonBlock> CODEC = PlanktonBlock.method_54094(PlanktonBlock::new);
    protected static final class_265 SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final class_2746 GLOWING = WWBlockStateProperties.GLOWING;
    public static final int LIGHT_LEVEL = 3;
    public static final int MIN_PARTICLE_SPAWN_WIDTH = -5;
    public static final int MAX_PARTICLE_SPAWN_WIDTH = 5;
    public static final int PARTICLE_SPAWN_SEARCH_DISTANCE = 24;
    public static final float PARTICLE_SPAWN_CHANCE = 0.5f;
    public static final float PARTICLE_SPAWN_CHANCE_GLOWING = 0.75f;

    public PlanktonBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)GLOWING, (Comparable)Boolean.FALSE));
    }

    @NotNull
    protected MapCodec<? extends PlanktonBlock> method_53969() {
        return CODEC;
    }

    @Override
    @NotNull
    public class_265 method_9530(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos, @NotNull class_3726 context) {
        return SHAPE;
    }

    @Override
    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (!this.method_9558(state, (class_4538)level, pos)) {
            level.method_22352(pos, false);
            return;
        }
        this.tryChangingState(state, level, pos);
    }

    protected void method_9514(class_2680 state, class_3218 level, class_2338 pos, class_5819 random) {
        this.tryChangingState(state, level, pos);
        super.method_9514(state, level, pos, random);
    }

    public void method_9496(class_2680 blockState, class_1937 level, @NotNull class_2338 blockPos, @NotNull class_5819 random) {
        float particleChance;
        class_2338.class_2339 mutable = new class_2338.class_2339();
        boolean glowing = PlanktonBlock.isGlowing(blockState);
        class_2400 particle = glowing ? WWParticleTypes.GLOWING_PLANKTON : WWParticleTypes.PLANKTON;
        float f = particleChance = glowing ? 0.75f : 0.5f;
        if (random.method_43057() <= particleChance) {
            class_2338 randomPos = new class_2338(blockPos.method_10263() + class_3532.method_15395((class_5819)random, (int)-5, (int)5), blockPos.method_10264(), blockPos.method_10260() + class_3532.method_15395((class_5819)random, (int)-5, (int)5));
            mutable.method_10101((class_2382)randomPos);
            int maxPossibleDepth = 0;
            for (int steps = 1; steps <= 24; ++steps) {
                mutable.method_10098(class_2350.field_11033);
                class_2680 particlePosState = level.method_8320((class_2338)mutable);
                if (!particlePosState.method_27852(class_2246.field_10382) || particlePosState.method_26227().method_15761() != 8) break;
                ++maxPossibleDepth;
            }
            mutable.method_10101((class_2382)randomPos);
            if (maxPossibleDepth > 0) {
                mutable.method_10104(class_2350.field_11033, random.method_39332(1, maxPossibleDepth));
                level.method_8406((class_2394)particle, (double)mutable.method_10263() + random.method_43058(), (double)mutable.method_10264() + random.method_43058(), (double)mutable.method_10260() + random.method_43058(), 0.0, 0.0, 0.0);
            }
        }
    }

    @Override
    public void method_9548(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1297 entity, class_10774 insideBlockEffectApplier, boolean bl) {
        if (entity.method_23318() <= (double)pos.method_10264() + SHAPE.method_1105(class_2350.class_2351.field_11052) && !PlanktonBlock.isGlowing(state) && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            this.tryChangingState(state, serverLevel, pos);
        }
    }

    public static boolean isGlowing(@NotNull class_2680 blockState) {
        return (Boolean)blockState.method_11654((class_2769)GLOWING);
    }

    private void tryChangingState(class_2680 blockState, @NotNull class_3218 serverLevel, class_2338 blockPos) {
        if (!serverLevel.method_8597().comp_645()) {
            return;
        }
        if (serverLevel.method_8530() != PlanktonBlock.isGlowing(blockState)) {
            return;
        }
        boolean setGlowing = !PlanktonBlock.isGlowing(blockState);
        serverLevel.method_8652(blockPos, (class_2680)blockState.method_11657((class_2769)GLOWING, (Comparable)Boolean.valueOf(setGlowing)), 3);
        serverLevel.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43287((class_2680)blockState));
        class_2338.method_10097((class_2338)blockPos.method_10069(-3, -2, -3), (class_2338)blockPos.method_10069(3, 2, 3)).forEach(blockPos2 -> {
            class_2680 foundState = serverLevel.method_8320(blockPos2);
            if (foundState == blockState) {
                int delay = (int)(Math.sqrt(blockPos.method_10262((class_2382)blockPos2)) * 5.0);
                serverLevel.method_64310(blockPos2, blockState.method_26204(), delay);
            }
        });
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{GLOWING});
    }
}

