/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block.entity;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.block.termite.TermiteManager;
import net.frozenblock.wilderwild.client.resources.sounds.TermiteEatingSoundInstance;
import net.frozenblock.wilderwild.client.resources.sounds.TermiteIdleSoundInstance;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;

public class TermiteMoundBlockEntity
extends class_2586 {
    public final TermiteManager termiteManager;
    public final IntArrayList clientTermiteIDs = new IntArrayList();
    public final IntArrayList prevClientTermiteIDs = new IntArrayList();

    public TermiteMoundBlockEntity(@NotNull class_2338 pos, @NotNull class_2680 state) {
        super(WWBlockEntityTypes.TERMITE_MOUND, pos, state);
        this.termiteManager = new TermiteManager();
    }

    public void tickServer(@NotNull class_1937 level, @NotNull class_2338 pos, boolean natural, boolean awake, boolean canSpawn) {
        this.termiteManager.tick(level, pos, natural, awake, canSpawn, this::markForUpdate);
    }

    public void tickClient() {
        for (TermiteManager.Termite termite : this.termiteManager.termites()) {
            int termiteID = termite.getID();
            if (!this.clientTermiteIDs.contains(termiteID) || this.prevClientTermiteIDs.contains(termiteID)) continue;
            TermiteMoundBlockEntity.addTermiteSound(this, termiteID, termite.getEating());
        }
        this.prevClientTermiteIDs.clear();
        this.prevClientTermiteIDs.addAll((IntList)this.clientTermiteIDs);
        this.clientTermiteIDs.clear();
        for (TermiteManager.Termite termite : this.termiteManager.termites()) {
            this.clientTermiteIDs.add(termite.getID());
        }
    }

    private void markForUpdate() {
        this.method_5431();
        this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 2);
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    @NotNull
    public class_2487 method_16887(class_7225.class_7874 provider) {
        return this.method_38244(provider);
    }

    protected void method_11007(@NotNull class_11372 valueOutput) {
        super.method_11007(valueOutput);
        this.termiteManager.saveAdditional(valueOutput);
    }

    public void method_11014(@NotNull class_11368 valueInput) {
        super.method_11014(valueInput);
        this.termiteManager.load(valueInput);
    }

    @Environment(value=EnvType.CLIENT)
    public static void addTermiteSound(TermiteMoundBlockEntity mound, int termiteID, boolean eating) {
        class_310 client = class_310.method_1551();
        if (client.field_1687 == null) {
            return;
        }
        if (eating) {
            client.method_1483().method_4873(new TermiteEatingSoundInstance<TermiteMoundBlockEntity>(mound, termiteID));
        } else {
            client.method_1483().method_4873(new TermiteIdleSoundInstance<TermiteMoundBlockEntity>(mound, termiteID));
        }
    }
}

