/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.model;

import java.util.Set;
import net.frozenblock.wilderwild.client.animation.definitions.PenguinAnimation;
import net.frozenblock.wilderwild.client.renderer.entity.state.PenguinRenderState;
import net.minecraft.class_11509;
import net.minecraft.class_3532;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_583;
import net.minecraft.class_630;
import net.minecraft.class_9941;
import net.minecraft.class_9953;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;

public class PenguinModel<T extends PenguinRenderState>
extends class_583<PenguinRenderState> {
    public static final class_9953 BABY_TRANSFORMER = new class_9941(true, 0.0f, 0.0f, 1.0f, 2.5f, 36.0f, Set.of());
    private final class_630 body;
    private final class_630 torso;
    private final class_630 head;
    private final class_630 rightFlipper;
    private final class_630 leftFlipper;
    private final class_630 feet;
    private final class_630 rightFoot;
    private final class_630 leftFoot;
    private final class_11509 layDownAnimation;
    private final class_11509 standUpAnimation;
    private final class_11509 callAnimation;

    public PenguinModel(@NotNull class_630 root) {
        super(root);
        this.body = root.method_32086("body");
        this.torso = this.body.method_32086("torso");
        this.head = this.torso.method_32086("head");
        this.rightFlipper = this.torso.method_32086("right_flipper");
        this.leftFlipper = this.torso.method_32086("left_flipper");
        this.feet = this.body.method_32086("feet");
        this.rightFoot = this.feet.method_32086("right_foot");
        this.leftFoot = this.feet.method_32086("left_foot");
        this.layDownAnimation = PenguinAnimation.PENGUIN_LAY_DOWN.method_71979(root);
        this.standUpAnimation = PenguinAnimation.PENGUIN_STAND_UP.method_71979(root);
        this.callAnimation = PenguinAnimation.PENGUIN_CALL.method_71979(root);
    }

    @NotNull
    public static class_5607 createBodyLayer() {
        class_5609 meshdefinition = new class_5609();
        class_5610 root = meshdefinition.method_32111();
        class_5610 body = root.method_32117("body", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)17.0f, (float)-0.5f));
        class_5610 torso = body.method_32117("torso", class_5606.method_32108().method_32101(0, 0).method_32098(-4.5f, -5.0f, -3.5f, 9.0f, 11.0f, 7.0f, new class_5605(0.0f)).method_32101(28, 18).method_32098(-4.5f, 6.0f, -3.5f, 9.0f, 1.0f, 7.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)0.0f, (float)0.0f));
        torso.method_32117("head", class_5606.method_32108().method_32101(0, 18).method_32098(-3.5f, -5.0f, -3.5f, 7.0f, 5.0f, 7.0f, new class_5605(0.0f)).method_32101(0, 42).method_32098(-4.5f, -6.0f, -3.5f, 9.0f, 3.0f, 7.0f, new class_5605(0.005f)).method_32101(32, 0).method_32098(-0.5f, -3.0f, -5.5f, 1.0f, 2.0f, 2.0f, new class_5605(0.0f)), class_5603.method_32090((float)0.0f, (float)-5.0f, (float)0.0f));
        torso.method_32117("right_flipper", class_5606.method_32108().method_32101(16, 30).method_32098(-1.0f, 0.0f, -1.5f, 1.0f, 9.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32090((float)-4.5f, (float)-5.0f, (float)0.0f));
        torso.method_32117("left_flipper", class_5606.method_32108().method_32101(24, 30).method_32098(0.0f, 0.0f, -1.5f, 1.0f, 9.0f, 3.0f, new class_5605(0.0f)), class_5603.method_32090((float)4.5f, (float)-5.0f, (float)0.0f));
        class_5610 feet = body.method_32117("feet", class_5606.method_32108(), class_5603.method_32090((float)0.0f, (float)7.0f, (float)0.5f));
        feet.method_32117("right_foot", class_5606.method_32108().method_32101(-5, 37).method_32098(-1.5f, 0.0f, -5.0f, 3.0f, 0.0f, 5.0f, new class_5605(0.005f)), class_5603.method_32090((float)-2.5f, (float)0.0f, (float)1.0f));
        feet.method_32117("left_foot", class_5606.method_32108().method_32101(-5, 37).method_32098(-1.5f, 0.0f, -5.0f, 3.0f, 0.0f, 5.0f, new class_5605(0.005f)), class_5603.method_32090((float)2.5f, (float)0.0f, (float)1.0f));
        return class_5607.method_32110((class_5609)meshdefinition, (int)64, (int)64);
    }

    @NotNull
    public static class_5607 createBabyBodyLayer() {
        return PenguinModel.createBodyLayer().method_62137(BABY_TRANSFORMER);
    }

    public void setupAnim(PenguinRenderState renderState) {
        super.method_2819((Object)renderState);
        float movementDelta = renderState.movementDelta;
        float notMovingDelta = 1.0f - movementDelta;
        float swimAmount = renderState.swimAmount;
        float notSwimmingAmount = 1.0f - swimAmount;
        float wadeProgress = renderState.wadeProgress;
        float notWadingProgress = 1.0f - wadeProgress;
        float slideProgress = renderState.slideProgress;
        float notSlidingProgress = 1.0f - slideProgress;
        float idleWadeProgress = Math.max((float)swimAmount, (float)wadeProgress);
        this.head.field_3675 += renderState.field_53447 * ((float)java.lang.Math.PI / 180) * notSwimmingAmount * notSlidingProgress;
        this.head.field_3654 += renderState.field_53448 * ((float)java.lang.Math.PI / 180) * notSwimmingAmount * notSlidingProgress;
        float limbSwing = renderState.field_53450 * 2.65f;
        float limbSwingAmount = Math.min((float)(renderState.field_53451 * 1.5f), (float)1.0f);
        this.layDownAnimation.method_71985(renderState.layDownAnimationState, renderState.field_53328);
        this.standUpAnimation.method_71985(renderState.standUpAnimationState, renderState.field_53328);
        this.callAnimation.method_71985(renderState.callAnimationState, renderState.field_53328);
        this.animateWalk(limbSwing, limbSwingAmount * notSwimmingAmount * notWadingProgress * notSlidingProgress);
        this.animateSlide(limbSwing * 2.5f, Math.min((float)(limbSwingAmount * 2.0f), (float)1.0f), movementDelta, slideProgress * notSwimmingAmount * notWadingProgress);
        this.animateWade(renderState.field_53328, idleWadeProgress * notMovingDelta * notSlidingProgress);
        this.animateWadeMove(limbSwing, Math.min((float)(limbSwingAmount * wadeProgress * notSwimmingAmount * movementDelta * notSlidingProgress * 1.75f), (float)1.0f));
        this.animateSwim(limbSwing, limbSwingAmount, renderState.field_53448, swimAmount * notSlidingProgress);
    }

    private void animateWalk(float limbSwing, float limbSwingAmount) {
        limbSwing *= 0.001f;
        float walkDelta = Math.min((float)(limbSwingAmount * 2.0f), (float)1.0f);
        this.body.field_3656 -= 0.25f * limbSwingAmount;
        float walkSpeed = (limbSwing *= 1.35f) * 90.0f;
        float walk35 = walkSpeed * 3.5f;
        float walk7 = walk35 * 2.0f;
        this.torso.field_3656 -= class_3532.method_15374((float)(walk7 - 80.0f)) * (limbSwingAmount *= (float)java.lang.Math.PI / 90) * 0.1f;
        this.torso.field_3654 -= class_3532.method_15374((float)(walk7 - 80.0f)) * limbSwingAmount * 0.3f;
        this.torso.field_3675 -= class_3532.method_15374((float)walk35) * limbSwingAmount * 11.0f;
        this.torso.field_3674 -= class_3532.method_15374((float)(walk35 - 80.0f)) * limbSwingAmount * 7.0f;
        this.head.field_3675 += class_3532.method_15374((float)walk35) * limbSwingAmount * 9.0f;
        this.head.field_3674 += class_3532.method_15374((float)(walk35 - 80.0f)) * limbSwingAmount * 4.0f;
        this.leftFlipper.field_3654 += class_3532.method_15374((float)(walk35 - 150.0f)) * limbSwingAmount * 2.0f;
        this.leftFlipper.field_3675 += class_3532.method_15374((float)(walk35 - 80.0f)) * limbSwingAmount * 3.0f;
        this.leftFlipper.field_3674 += (-20.0f + class_3532.method_15374((float)(walk35 - 80.0f)) * 5.0f) * limbSwingAmount;
        this.rightFlipper.field_3654 += class_3532.method_15374((float)(walk35 - 10.0f)) * limbSwingAmount * 2.0f;
        this.rightFlipper.field_3675 += class_3532.method_15374((float)(walk35 - 260.0f)) * limbSwingAmount * 3.0f;
        this.rightFlipper.field_3674 += (20.0f - class_3532.method_15374((float)(walk35 - 140.0f)) * 3.0f) * limbSwingAmount;
        this.leftFoot.field_3656 += class_3532.method_15363((float)class_3532.method_15374((float)(walk35 - 80.0f)), (float)-1.0f, (float)0.0f) * walkDelta * 0.75f;
        this.leftFoot.field_3655 -= class_3532.method_15374((float)(walk35 - 160.0f)) * walkDelta;
        this.leftFoot.field_3654 -= Math.clamp((float)(class_3532.method_15374((float)(walk35 - 110.0f)) * 5.0f), (float)0.0f, (float)5.0f) * ((float)java.lang.Math.PI / 180) * walkDelta;
        this.rightFoot.field_3656 += class_3532.method_15363((float)(-class_3532.method_15374((float)(walk35 - 80.0f))), (float)-1.0f, (float)0.0f) * walkDelta * 0.75f;
        this.rightFoot.field_3655 += class_3532.method_15374((float)(walk35 - 160.0f)) * walkDelta;
        this.rightFoot.field_3654 -= Math.clamp((float)(-class_3532.method_15374((float)(walk35 - 110.0f)) * 5.0f), (float)0.0f, (float)5.0f) * ((float)java.lang.Math.PI / 180) * walkDelta;
    }

    private void animateWade(float ageInTicks, float wadeAmount) {
        float wadeDegToRad = wadeAmount * ((float)java.lang.Math.PI / 180);
        float animProgress = (ageInTicks *= 0.001f) * 90.0f * 0.75f;
        this.body.field_3654 += (-90.0f + class_3532.method_15374((float)(animProgress - 40.0f))) * wadeDegToRad;
        this.body.field_3674 -= class_3532.method_15374((float)(animProgress - 120.0f)) * 0.5f * wadeDegToRad;
        this.body.field_3657 -= class_3532.method_15374((float)(animProgress - 80.0f)) * 0.2f * wadeAmount;
        this.body.field_3656 += class_3532.method_15374((float)animProgress) * 0.4f * wadeAmount;
        this.body.field_3655 += (3.0f - class_3532.method_15374((float)(animProgress - 180.0f)) * 0.2f) * wadeAmount;
        this.torso.field_3654 += 90.0f * wadeDegToRad;
        this.torso.field_3656 += 3.5f * wadeAmount;
        this.head.field_3654 += (2.5f - class_3532.method_15374((float)(animProgress - 40.0f))) * wadeDegToRad;
        this.head.field_3674 -= class_3532.method_15374((float)(animProgress - 120.0f)) * wadeDegToRad;
        this.head.field_3656 += 0.2f * wadeAmount;
        this.head.field_3655 -= 0.1f * wadeAmount;
        this.leftFlipper.field_3654 += 2.4687f * wadeDegToRad;
        this.leftFlipper.field_3675 += (-0.4911f - class_3532.method_15374((float)(animProgress - 40.0f)) * 10.0f) * wadeDegToRad;
        this.leftFlipper.field_3674 += (-17.372f - class_3532.method_15374((float)(animProgress + 40.0f)) * 5.0f) * wadeDegToRad;
        this.rightFlipper.field_3654 -= 4.2618f * wadeDegToRad;
        this.rightFlipper.field_3675 += (-0.9452f - class_3532.method_15374((float)(animProgress - 90.0f)) * 10.0f) * wadeDegToRad;
        this.rightFlipper.field_3674 += (14.6625f + class_3532.method_15374((float)(animProgress + 30.0f)) * 5.0f) * wadeDegToRad;
        this.feet.field_3654 += 92.1786f * wadeDegToRad;
        this.feet.field_3656 -= 4.25f * wadeAmount;
        this.feet.field_3655 += 5.75f * wadeAmount;
        float footAnimProgress = ageInTicks * 90.0f * 6.0f;
        this.leftFoot.field_3654 += (36.0192f - class_3532.method_15374((float)footAnimProgress) * 15.0f) * wadeDegToRad;
        this.leftFoot.field_3675 -= 11.5188f * wadeDegToRad;
        this.leftFoot.field_3674 -= 12.8719f * wadeDegToRad;
        this.leftFoot.field_3656 -= (0.5f - class_3532.method_15374((float)(footAnimProgress - 80.0f)) * 0.5f) * wadeAmount;
        this.rightFoot.field_3654 += (42.7455f + class_3532.method_15374((float)(footAnimProgress - 40.0f)) * 15.0f) * wadeDegToRad;
        this.rightFoot.field_3675 += 5.7415f * wadeDegToRad;
        this.rightFoot.field_3674 += 15.1165f * wadeDegToRad;
        this.rightFoot.field_3656 -= (0.5f + class_3532.method_15374((float)(footAnimProgress - 80.0f)) * 0.5f) * wadeAmount;
    }

    private void animateWadeMove(float limbSwing, float wadeAmount) {
        float wadeDegToRad = wadeAmount * ((float)java.lang.Math.PI / 180);
        float animProgress = (limbSwing *= 0.001f) * 90.0f;
        this.body.field_3654 += (-72.5f + class_3532.method_15374((float)(animProgress - 40.0f))) * wadeDegToRad;
        this.body.field_3674 -= class_3532.method_15374((float)(animProgress - 120.0f)) * 0.5f * wadeDegToRad;
        this.body.field_3657 -= class_3532.method_15374((float)(animProgress - 80.0f)) * 0.2f * wadeAmount;
        this.body.field_3656 += class_3532.method_15374((float)animProgress) * 0.4f * wadeAmount;
        this.body.field_3655 += (3.0f - class_3532.method_15374((float)(animProgress - 180.0f)) * 0.2f) * wadeAmount;
        this.torso.field_3654 += 90.0f * wadeDegToRad;
        this.torso.field_3656 += 3.5f * wadeAmount;
        this.head.field_3654 += (-10.0f - class_3532.method_15374((float)(animProgress - 40.0f)) * 2.0f) * wadeDegToRad;
        this.head.field_3674 -= class_3532.method_15374((float)(animProgress * 2.0f - 120.0f)) * 1.5f * wadeDegToRad;
        this.head.field_3656 += 0.2f * wadeAmount;
        this.head.field_3655 -= 0.1f * wadeAmount;
        this.leftFlipper.field_3654 += (-30.8475f + class_3532.method_15374((float)(animProgress * 2.0f + 40.0f)) * 15.0f) * wadeDegToRad;
        this.leftFlipper.field_3675 += (-5.7559f - class_3532.method_15374((float)(animProgress * 2.0f - 40.0f)) * 20.0f) * wadeDegToRad;
        this.leftFlipper.field_3674 += (-31.4462f - class_3532.method_15374((float)(animProgress + 40.0f)) * 5.0f) * wadeDegToRad;
        this.rightFlipper.field_3654 += (-30.8475f - class_3532.method_15374((float)(animProgress * 2.0f + 30.0f)) * 15.0f) * wadeDegToRad;
        this.rightFlipper.field_3675 += (5.7559f - class_3532.method_15374((float)(animProgress * 2.0f - 70.0f)) * 20.0f) * wadeDegToRad;
        this.rightFlipper.field_3674 += (31.4462f + class_3532.method_15374((float)(animProgress + 30.0f)) * 5.0f) * wadeDegToRad;
        this.feet.field_3654 += 92.1786f * wadeDegToRad;
        this.feet.field_3656 -= 4.25f * wadeAmount;
        this.feet.field_3655 += 5.75f * wadeAmount;
        float footAnimProgress = limbSwing * 90.0f * 6.0f;
        this.leftFoot.field_3654 += (35.7474f - class_3532.method_15374((float)footAnimProgress) * 15.0f) * wadeDegToRad;
        this.leftFoot.field_3675 -= 9.4931f * wadeDegToRad;
        this.leftFoot.field_3674 -= 11.3817f * wadeDegToRad;
        this.leftFoot.field_3657 -= 0.25f * wadeAmount;
        this.leftFoot.field_3656 -= (0.5f - class_3532.method_15374((float)(footAnimProgress - 80.0f)) * 0.5f) * wadeAmount;
        this.rightFoot.field_3654 += (42.7455f + class_3532.method_15374((float)(footAnimProgress - 40.0f)) * 15.0f) * wadeDegToRad;
        this.rightFoot.field_3675 += 5.7415f * wadeDegToRad;
        this.rightFoot.field_3674 += 15.1165f * wadeDegToRad;
        this.rightFoot.field_3657 += 0.25f * wadeAmount;
        this.rightFoot.field_3656 -= (0.5f + class_3532.method_15374((float)(footAnimProgress - 80.0f)) * 0.5f) * wadeAmount;
    }

    private void animateSlide(float limbSwing, float limbSwingAmount, float movementDelta, float slideAmount) {
        float animProgress = (limbSwing *= 0.001f) * 90.0f;
        float slideToRad = (float)java.lang.Math.PI / 180 * slideAmount;
        float slideRadSwing = limbSwingAmount * slideToRad;
        float movementDeltaSlideToRad = (float)java.lang.Math.PI / 180 * movementDelta;
        this.body.field_3654 += class_3532.method_15374((float)(animProgress * 2.0f - 210.0f)) * slideToRad;
        this.body.field_3674 += class_3532.method_15374((float)(animProgress - 210.0f)) * slideToRad;
        this.body.field_3655 -= class_3532.method_15374((float)(animProgress * 2.0f - 180.0f)) * slideAmount;
        this.head.field_3654 -= class_3532.method_15374((float)(animProgress * 2.0f - 120.0f)) * 1.5f * slideRadSwing;
        this.head.field_3675 -= class_3532.method_15374((float)(animProgress * 2.0f - 40.0f)) * slideRadSwing;
        this.head.field_3674 -= class_3532.method_15374((float)(animProgress - 180.0f)) * slideRadSwing;
        this.leftFlipper.field_3654 += (-13.6109f + class_3532.method_15363((float)(-class_3532.method_15374((float)(animProgress * 2.0f - 90.0f)) * 15.0f), (float)0.0f, (float)15.0f)) * movementDeltaSlideToRad;
        this.leftFlipper.field_3675 -= class_3532.method_15374((float)(animProgress * 2.0f - 40.0f)) * 20.0f * movementDeltaSlideToRad;
        this.leftFlipper.field_3674 += (-42.5f - class_3532.method_15374((float)(animProgress * 2.0f)) * 20.0f) * movementDeltaSlideToRad;
        this.rightFlipper.field_3654 += (-13.6109f + class_3532.method_15363((float)(-class_3532.method_15374((float)(animProgress * 2.0f - 90.0f)) * 15.0f), (float)0.0f, (float)15.0f)) * movementDeltaSlideToRad;
        this.rightFlipper.field_3675 += class_3532.method_15374((float)(animProgress * 2.0f - 40.0f)) * 20.0f * movementDeltaSlideToRad;
        this.rightFlipper.field_3674 += (42.5f + class_3532.method_15374((float)(animProgress * 2.0f)) * 20.0f) * movementDeltaSlideToRad;
        this.leftFoot.field_3654 -= class_3532.method_15374((float)(animProgress * 2.0f - 270.0f)) * 2.0f * slideRadSwing;
        this.rightFoot.field_3654 -= class_3532.method_15374((float)(animProgress * 2.0f - 240.0f)) * 2.0f * slideRadSwing;
    }

    private void animateSwim(float limbSwing, float limbSwingAmount, float headPitch, float swimAmount) {
        float swimLimbAmount = limbSwingAmount * swimAmount;
        float flipperZRot = class_3532.method_15363((float)(class_3532.method_15362((float)(limbSwing * 0.2f)) * swimLimbAmount * swimAmount + 0.5497787f * swimAmount), (float)0.0f, (float)((float)java.lang.Math.PI));
        this.leftFlipper.field_3674 -= flipperZRot;
        this.rightFlipper.field_3674 += flipperZRot;
        this.body.field_3654 = class_3532.method_17821((float)swimLimbAmount, (float)this.body.field_3654, (float)((headPitch + 90.0f) * ((float)java.lang.Math.PI / 180)));
        float headRot = -1.5707964f * swimLimbAmount;
        float headY = -3.0f * swimLimbAmount;
        float headZ = -2.0f * swimLimbAmount;
        this.head.field_3654 += headRot;
        this.head.field_3656 += headY;
        this.head.field_3655 += headZ;
        float swimRotScale = swimLimbAmount * 10.0f * ((float)java.lang.Math.PI / 180);
        float swimXRot = class_3532.method_15362((float)(limbSwing * 0.175f)) * swimRotScale;
        this.torso.field_3654 += swimXRot;
        this.head.field_3654 -= swimXRot;
        float swimXRotDelayed = class_3532.method_15362((float)((limbSwing - 5.0f) * 0.175f)) * swimRotScale;
        this.feet.field_3654 += swimXRotDelayed + 1.5707964f * swimLimbAmount;
    }
}

