/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.client.renderer.entity;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.client.WWModelLayers;
import net.frozenblock.wilderwild.client.model.CrabModel;
import net.frozenblock.wilderwild.client.renderer.entity.state.CrabRenderState;
import net.frozenblock.wilderwild.entity.Crab;
import net.minecraft.class_10042;
import net.minecraft.class_11659;
import net.minecraft.class_12075;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_5601;
import net.minecraft.class_5617;
import net.minecraft.class_583;
import net.minecraft.class_7833;
import net.minecraft.class_927;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionfc;

@Environment(value=EnvType.CLIENT)
public class CrabRenderer
extends class_927<Crab, CrabRenderState, CrabModel> {
    private static final class_2960 CRAB_DITTO_LOCATION = WWConstants.id("textures/entity/crab/crab_ditto.png");
    private final CrabModel normalModel = (CrabModel)this.method_4038();
    private final CrabModel mojangModel;

    public CrabRenderer(class_5617.class_5618 context) {
        this(context, WWModelLayers.CRAB);
    }

    public CrabRenderer(class_5617.class_5618 context, class_5601 layer) {
        super(context, (class_583)new CrabModel(context.method_32167(layer)), 0.3f);
        this.mojangModel = new CrabModel(context.method_32167(WWModelLayers.CRAB_MOJANG));
    }

    protected void setupRotations(@NotNull CrabRenderState renderState, @NotNull class_4587 poseStack, float f, float g) {
        poseStack.method_46416(0.0f, 0.17f * renderState.field_53454, 0.0f);
        poseStack.method_22907((Quaternionfc)class_7833.field_40716.rotationDegrees(-90.0f));
        super.method_4058((class_10042)renderState, poseStack, f, g);
    }

    protected void scale(@NotNull CrabRenderState renderState, class_4587 poseStack) {
        super.method_4042((class_10042)renderState, poseStack);
        poseStack.method_22905(renderState.field_53454, renderState.field_53454, renderState.field_53454);
    }

    public void submit(@NotNull CrabRenderState renderState, @NotNull class_4587 poseStack, @NotNull class_11659 submitNodeCollector, @NotNull class_12075 cameraRenderState) {
        this.field_4737 = !WWConstants.MOJANG_CRABS || renderState.isDitto ? this.normalModel : this.mojangModel;
        super.method_4054((class_10042)renderState, poseStack, submitNodeCollector, cameraRenderState);
    }

    protected float method_3919() {
        return 180.0f;
    }

    @NotNull
    public class_2960 getTextureLocation(@NotNull CrabRenderState renderState) {
        if (renderState.isDitto) {
            return CRAB_DITTO_LOCATION;
        }
        return WWConstants.MOJANG_CRABS ? renderState.mojangTexture : renderState.texture;
    }

    @NotNull
    public CrabRenderState createRenderState() {
        return new CrabRenderState();
    }

    public void extractRenderState(@NotNull Crab entity, @NotNull CrabRenderState renderState, float partialTick) {
        super.method_62355((class_1309)entity, (class_10042)renderState, partialTick);
        renderState.climbXRot = class_3532.method_16439((float)partialTick, (float)entity.prevClimbAnimX, (float)entity.climbAnimX) * 85.0f;
        renderState.attackTime = entity.method_6055(partialTick);
        renderState.isDitto = entity.isDitto();
        renderState.hidingAnimationState.method_61401(entity.hidingAnimationState);
        renderState.diggingAnimationState.method_61401(entity.diggingAnimationState);
        renderState.emergingAnimationState.method_61401(entity.emergingAnimationState);
        renderState.texture = entity.getVariantForRendering().resourceTexture().comp_3627();
        renderState.mojangTexture = entity.getVariantForRendering().mojangResourceTexture().comp_3627();
    }
}

