/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.wind;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.frozenblock.lib.wind.api.WindManagerExtension;
import net.frozenblock.lib.wind.impl.networking.WindSyncPacket;
import net.frozenblock.wilderwild.WWConstants;
import net.frozenblock.wilderwild.networking.packet.WWWindPacket;
import net.minecraft.class_10741;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_4284;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public final class WWWindManager
extends WindManagerExtension {
    private static final String WW_WIND_MANAGER_EXTENSION_FILE_ID = WWWindManager.createSaveId((class_2960)WWConstants.id("clouds"));
    public static final Codec<WWWindManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.DOUBLE.fieldOf("cloudX").forGetter(windManager -> windManager.cloudX), (App)Codec.DOUBLE.fieldOf("cloudZ").forGetter(windManager -> windManager.cloudZ)).apply((Applicative)instance, WWWindManager::createFromCodec));
    public static final class_10741<WWWindManager> TYPE = new class_10741(WW_WIND_MANAGER_EXTENSION_FILE_ID, WWWindManager::new, CODEC, class_4284.field_45082);
    public double cloudX;
    public double cloudZ;

    @NotNull
    public static WWWindManager createFromCodec(double cloudX, double cloudZ) {
        WWWindManager manager = new WWWindManager();
        manager.cloudX = cloudX;
        manager.cloudZ = cloudZ;
        return manager;
    }

    public void tick(class_3218 level) {
        this.cloudX += this.getWindManager().laggedWindX * 0.007;
        this.cloudZ += this.getWindManager().laggedWindZ * 0.007;
    }

    public void baseTick(class_3218 level) {
    }

    public boolean runResetsIfNeeded() {
        boolean needsReset = false;
        if (this.cloudX == Double.MAX_VALUE || this.cloudX == Double.MIN_VALUE) {
            needsReset = true;
            this.cloudX = 0.0;
        }
        if (this.cloudZ == Double.MAX_VALUE || this.cloudZ == Double.MIN_VALUE) {
            needsReset = true;
            this.cloudZ = 0.0;
        }
        return needsReset;
    }

    @Contract(value="_ -> new")
    @NotNull
    public class_8710 syncPacket(WindSyncPacket packet) {
        return new WWWindPacket(this.cloudX, this.cloudZ);
    }
}

