/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.worldgen.biome;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.function.Consumer;
import net.frozenblock.lib.worldgen.biome.api.FrozenBiome;
import net.frozenblock.lib.worldgen.biome.api.parameters.FrozenBiomeParameters;
import net.frozenblock.lib.worldgen.biome.api.parameters.Humidity;
import net.frozenblock.lib.worldgen.biome.api.parameters.OverworldBiomeBuilderParameters;
import net.frozenblock.lib.worldgen.biome.api.parameters.Weirdness;
import net.frozenblock.wilderwild.config.WWWorldgenConfig;
import net.frozenblock.wilderwild.mod_compat.WWModIntegrations;
import net.frozenblock.wilderwild.worldgen.WWSharedWorldgen;
import net.frozenblock.wilderwild.worldgen.features.placed.WWMiscPlaced;
import net.frozenblock.wilderwild.worldgen.features.placed.WWPlacedFeatures;
import net.minecraft.class_12194;
import net.minecraft.class_12199;
import net.minecraft.class_12206;
import net.minecraft.class_12212;
import net.minecraft.class_12218;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_1972;
import net.minecraft.class_2893;
import net.minecraft.class_3417;
import net.minecraft.class_3864;
import net.minecraft.class_5321;
import net.minecraft.class_5478;
import net.minecraft.class_5483;
import net.minecraft.class_5485;
import net.minecraft.class_6544;
import net.minecraft.class_6811;
import net.minecraft.class_6819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CypressWetlands
extends FrozenBiome {
    public static final class_6544.class_6546 TEMPERATURE = class_6544.class_6546.method_38121((float)-0.09f, (float)0.5f);
    public static final class_6544.class_6546 HUMIDITY = class_6544.class_6546.method_38123((class_6544.class_6546)Humidity.NEUTRAL, (class_6544.class_6546)Humidity.HUMID);
    public static final class_6544.class_6546 CONTINENTALNESS = class_6544.class_6546.method_38121((float)-0.2f, (float)0.5f);
    public static final class_6544.class_6546 EROSION = class_6544.class_6546.method_38121((float)0.5f, (float)1.0f);
    public static final class_6544.class_6546 WEIRDNESS_A = Weirdness.LOW_SLICE_NORMAL_DESCENDING;
    public static final class_6544.class_6546 WEIRDNESS_B = Weirdness.LOW_SLICE_VARIANT_ASCENDING;
    public static final class_6544.class_6546 WEIRDNESS_C = Weirdness.VALLEY;
    public static final class_6544.class_6546 WEIRDNESS_D = Weirdness.MID_SLICE_NORMAL_ASCENDING;
    public static final class_6544.class_6546 WEIRDNESS_E = Weirdness.MID_SLICE_NORMAL_DESCENDING;
    public static final class_6544.class_6546 WEIRDNESS_F = Weirdness.MID_SLICE_VARIANT_ASCENDING;
    public static final class_6544.class_6546 WEIRDNESS_G = Weirdness.MID_SLICE_VARIANT_DESCENDING;
    public static final float OFFSET = 0.0f;
    public static final float TEMP = 0.6f;
    public static final float DOWNFALL = 0.7f;
    public static final int WATER_COLOR = 4552818;
    public static final int WATER_FOG_COLOR = 4552818;
    public static final int SKY_COLOR = class_5478.method_30932((float)0.8f);
    public static final int FOLIAGE_COLOR = 5877296;
    public static final int GRASS_COLOR = 7979098;
    public static final CypressWetlands INSTANCE = new CypressWetlands();

    public String modID() {
        return "wilderwild";
    }

    public String biomeID() {
        return "cypress_wetlands";
    }

    public float temperature() {
        return 0.6f;
    }

    public float downfall() {
        return 0.7f;
    }

    public boolean hasPrecipitation() {
        return true;
    }

    public int waterColor() {
        return 4552818;
    }

    @NotNull
    public Integer foliageColorOverride() {
        return 5877296;
    }

    @Nullable
    public Integer dryFoliageColorOverride() {
        return null;
    }

    @NotNull
    public Integer grassColorOverride() {
        return 7979098;
    }

    public void fillEnvironmentAttributes(class_12199.class_12200 builder) {
        builder.method_75674(class_12206.field_63746, (Object)SKY_COLOR);
        builder.method_75674(class_12206.field_63744, (Object)4552818);
        builder.method_75673(class_12206.field_64125, (class_12212)class_12218.field_63802, (Object)Float.valueOf(0.85f));
        builder.method_75674(class_12206.field_63751, (Object)new class_12194((class_6880)class_3417.field_44693));
        builder.method_75674(class_12206.field_63760, (Object)true);
    }

    public void addFeatures(@NotNull class_5485.class_5495 features) {
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.SEAGRASS_CYPRESS.getKey());
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.CYPRESS_WETLANDS_FLOWERS_SPARSE.getKey());
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.DENSE_FLOWER_PLACED.getKey());
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.CYPRESS_WETLANDS_TREES.getKey());
        features.method_30992(class_2893.class_2895.field_13178, WWPlacedFeatures.CYPRESS_WETLANDS_TREES_WATER.getKey());
        this.addCypressPaths(features);
        WWSharedWorldgen.addBasicFeatures(features, true);
        class_3864.method_16971((class_5485.class_5495)features);
        class_3864.method_38568((class_5485.class_5495)features);
        this.addCypressVegetation(features);
    }

    public void addCypressPaths(@NotNull class_5485.class_5495 builder) {
        builder.method_30992(class_2893.class_2895.field_13176, WWMiscPlaced.UNDER_WATER_SAND_PATH.getKey());
        builder.method_30992(class_2893.class_2895.field_13176, WWMiscPlaced.UNDER_WATER_GRAVEL_PATH.getKey());
        builder.method_30992(class_2893.class_2895.field_13176, WWMiscPlaced.UNDER_WATER_CLAY_PATH.getKey());
    }

    public void addCypressVegetation(@NotNull class_5485.class_5495 builder) {
        builder.method_30992(class_2893.class_2895.field_13178, class_6819.field_36180);
        builder.method_30992(class_2893.class_2895.field_13178, class_6819.field_36114);
        builder.method_30992(class_2893.class_2895.field_13178, class_6819.field_36164);
        builder.method_30992(class_2893.class_2895.field_13178, class_6819.field_56517);
        builder.method_30992(class_2893.class_2895.field_13178, class_6819.field_56519);
        builder.method_30992(class_2893.class_2895.field_13178, class_6811.field_35971);
    }

    public void addSpawns(class_5483.class_5496 spawns) {
        class_3864.method_30581((class_5483.class_5496)spawns);
        spawns.method_31011(class_1311.field_24460, 5, new class_5483.class_1964(class_1299.field_6070, 2, 6)).method_31011(class_1311.field_6294, 14, new class_5483.class_1964(class_1299.field_37419, 4, 5)).method_31011(class_1311.field_6294, 3, new class_5483.class_1964(class_1299.field_6093, 2, 4)).method_31011(class_1311.field_6294, 4, new class_5483.class_1964(class_1299.field_6132, 2, 4)).method_31011(class_1311.field_6294, 6, new class_5483.class_1964(class_1299.field_6085, 4, 4)).method_31011(class_1311.field_6294, 10, new class_5483.class_1964(class_1299.field_6140, 4, 4));
    }

    public void injectToOverworld(Consumer<Pair<class_6544.class_4762, class_5321<class_1959>>> parameters) {
        if (WWModIntegrations.BIOLITH_INTEGRATION.modLoaded()) {
            return;
        }
        if (!WWWorldgenConfig.get().biomeGeneration.generateCypressWetlands) {
            return;
        }
        this.addSurfaceBiome(parameters, TEMPERATURE, HUMIDITY, CONTINENTALNESS, EROSION, WEIRDNESS_A, 0.0f);
        this.addSurfaceBiome(parameters, TEMPERATURE, HUMIDITY, CONTINENTALNESS, EROSION, WEIRDNESS_B, 0.0f);
        this.addSurfaceBiome(parameters, TEMPERATURE, HUMIDITY, CONTINENTALNESS, EROSION, WEIRDNESS_C, 0.0f);
        List swampJungleBorders = FrozenBiomeParameters.findBorderParameters((List)OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9471), (List)OverworldBiomeBuilderParameters.points((class_5321)class_1972.field_9417), (float)0.35f);
        swampJungleBorders.forEach(parameterPoint -> {
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_A, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_B, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_C, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_D, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_E, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_F, parameterPoint.comp_111());
            this.addSurfaceBiome(parameters, parameterPoint.comp_105(), parameterPoint.comp_106(), parameterPoint.comp_107(), parameterPoint.comp_108(), WEIRDNESS_G, parameterPoint.comp_111());
        });
    }
}

