/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.lib.wind.api.BlowingHelper;
import net.frozenblock.wilderwild.block.entity.GeyserBlockEntity;
import net.frozenblock.wilderwild.block.impl.GeyserParticleHandler;
import net.frozenblock.wilderwild.block.state.properties.GeyserStage;
import net.frozenblock.wilderwild.block.state.properties.GeyserType;
import net.frozenblock.wilderwild.registry.WWBlockEntityTypes;
import net.frozenblock.wilderwild.registry.WWBlockStateProperties;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.minecraft.class_10225;
import net.minecraft.class_1750;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_5819;
import net.minecraft.class_9904;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GeyserBlock
extends class_2237 {
    public static final float BOIL_SOUND_CHANCE_NATURAL = 0.0085f;
    public static final float BOIL_SOUND_CHANCE = 0.002f;
    public static final class_2754<GeyserType> GEYSER_TYPE = WWBlockStateProperties.GEYSER_TYPE;
    public static final class_2754<GeyserStage> GEYSER_STAGE = WWBlockStateProperties.GEYSER_STAGE;
    public static final class_2754<class_2350> FACING = class_2741.field_12525;
    public static final class_2746 NATURAL = WWBlockStateProperties.NATURAL;
    public static final class_2746 POWERED = class_2741.field_12484;
    public static final MapCodec<GeyserBlock> CODEC = GeyserBlock.method_54094(GeyserBlock::new);

    public GeyserBlock(@NotNull class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(GEYSER_TYPE, (Comparable)((Object)GeyserType.NONE))).method_11657(GEYSER_STAGE, (Comparable)((Object)GeyserStage.DORMANT))).method_11657(FACING, (Comparable)class_2350.field_11036)).method_11657((class_2769)NATURAL, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    @NotNull
    protected MapCodec<? extends GeyserBlock> method_53969() {
        return CODEC;
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new GeyserBlockEntity(pos, state);
    }

    protected void method_9515(@NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{GEYSER_TYPE, GEYSER_STAGE, FACING, NATURAL, POWERED});
    }

    protected boolean method_9498(class_2680 state) {
        return true;
    }

    protected int method_9572(@NotNull class_2680 state, class_1937 world, class_2338 pos) {
        GeyserStage stage = (GeyserStage)((Object)state.method_11654(GEYSER_STAGE));
        if (stage == GeyserStage.DORMANT) {
            return 0;
        }
        if (stage == GeyserStage.ACTIVE) {
            return 5;
        }
        if (stage == GeyserStage.ERUPTING) {
            return 15;
        }
        return super.method_9572(state, world, pos);
    }

    public class_2680 method_9605(@NotNull class_1750 context) {
        class_1937 level = context.method_8045();
        class_2338 pos = context.method_8037();
        class_2350 direction = context.method_7715().method_10153();
        GeyserType geyserType = GeyserBlock.getGeyserTypeForPos((class_4538)level, direction, pos);
        boolean canErupt = context.method_8045().method_49803(pos) && GeyserBlock.isActive(geyserType);
        return (class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657(GEYSER_STAGE, (Comparable)((Object)(canErupt ? GeyserStage.ERUPTING : GeyserStage.DORMANT)))).method_11657(GEYSER_TYPE, (Comparable)((Object)geyserType))).method_11657(FACING, (Comparable)direction)).method_11657((class_2769)NATURAL, (Comparable)Boolean.valueOf(false));
    }

    protected void method_9612(class_2680 blockState, class_1937 level, class_2338 blockPos, class_2248 block, @Nullable class_9904 orientation, boolean movedByPiston) {
        boolean hasNeighborSignal;
        if (!level.field_9236 && (hasNeighborSignal = level.method_49803(blockPos)) != (Boolean)blockState.method_11654((class_2769)POWERED)) {
            class_2680 newState = (class_2680)blockState.method_11657((class_2769)POWERED, (Comparable)Boolean.valueOf(hasNeighborSignal));
            if (hasNeighborSignal) {
                boolean erupting;
                boolean bl = erupting = blockState.method_11654(GEYSER_STAGE) == GeyserStage.ERUPTING;
                if (!erupting && GeyserBlock.isActive((GeyserType)((Object)blockState.method_11654(GEYSER_TYPE)))) {
                    newState = (class_2680)newState.method_11657(GEYSER_STAGE, (Comparable)((Object)GeyserStage.ERUPTING));
                }
            }
            level.method_8501(blockPos, newState);
        }
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, @NotNull class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        GeyserType geyserType;
        if (direction.method_10166() == ((class_2350)blockState.method_11654(FACING)).method_10166() && (geyserType = GeyserBlock.getGeyserTypeForPos(levelReader, blockState, blockPos)) != blockState.method_11654(GEYSER_TYPE)) {
            blockState = (class_2680)blockState.method_11657(GEYSER_TYPE, (Comparable)((Object)geyserType));
        }
        return blockState;
    }

    public static GeyserType getGeyserTypeForPos(@NotNull class_4538 level, @NotNull class_2680 state, @NotNull class_2338 pos) {
        return GeyserBlock.getGeyserTypeForPos(level, (class_2350)state.method_11654(FACING), pos);
    }

    public static GeyserType getGeyserTypeForPos(@NotNull class_4538 level, @NotNull class_2350 direction, @NotNull class_2338 pos) {
        class_2680 checkState;
        class_2338 checkPos = pos.method_10093(direction);
        if (BlowingHelper.canBlowingPassThrough((class_4538)level, (class_2338)checkPos, (class_2680)(checkState = level.method_8320(checkPos)), (class_2350)direction)) {
            class_3610 fluidState = checkState.method_26227();
            if (fluidState.method_15767(class_3486.field_15517)) {
                if (level.method_8320(pos.method_10093(direction.method_10153())).method_27852(class_2246.field_10092)) {
                    return GeyserType.HYDROTHERMAL_VENT;
                }
                return GeyserType.WATER;
            }
            if (fluidState.method_15767(class_3486.field_15518)) {
                return GeyserType.LAVA;
            }
            return GeyserType.AIR;
        }
        return GeyserType.NONE;
    }

    public void method_9588(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        GeyserType geyserType = GeyserBlock.getGeyserTypeForPos((class_4538)level, state, pos);
        if (geyserType != state.method_11654(GEYSER_TYPE)) {
            level.method_8501(pos, (class_2680)state.method_11657(GEYSER_TYPE, (Comparable)((Object)geyserType)));
        }
    }

    public void method_9496(@NotNull class_2680 blockState, @NotNull class_1937 level, @NotNull class_2338 blockPos, @NotNull class_5819 random) {
        GeyserType geyserType = (GeyserType)((Object)blockState.method_11654(GEYSER_TYPE));
        if (!GeyserBlock.isActive(geyserType)) {
            return;
        }
        class_2350 direction = (class_2350)blockState.method_11654(FACING);
        boolean natural = (Boolean)blockState.method_11654((class_2769)NATURAL);
        GeyserStage stage = (GeyserStage)((Object)blockState.method_11654(GEYSER_STAGE));
        GeyserParticleHandler.spawnBaseGeyserParticles(level, blockPos, direction, random, geyserType == GeyserType.HYDROTHERMAL_VENT);
        if (geyserType == GeyserType.HYDROTHERMAL_VENT && random.method_43048(27) == 0) {
            level.method_8486((double)blockPos.method_10263() + 0.5, (double)blockPos.method_10264() + 0.5, (double)blockPos.method_10260() + 0.5, WWSounds.BLOCK_GEYSER_VENT_AMBIENT, class_3419.field_15245, 0.325f, 0.85f + random.method_43057() * 0.3f, false);
        }
        if (stage == GeyserStage.DORMANT) {
            GeyserParticleHandler.spawnDormantParticles(level, blockPos, geyserType, direction, random);
        } else if (stage == GeyserStage.ACTIVE) {
            GeyserParticleHandler.spawnActiveParticles(level, blockPos, geyserType, direction, random);
        }
        if (natural ? random.method_43057() <= 0.0085f : random.method_43057() <= 0.002f) {
            level.method_45446(blockPos, WWSounds.BLOCK_GEYSER_BOIL, class_3419.field_15245, 0.15f, 0.9f + random.method_43057() * 0.2f, false);
        }
    }

    @NotNull
    public class_2464 method_9604(@NotNull class_2680 blockState) {
        return class_2464.field_11458;
    }

    @Nullable
    public <T extends class_2586> class_5558<T> method_31645(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2591<T> type) {
        return !level.field_9236 ? GeyserBlock.method_31618(type, WWBlockEntityTypes.GEYSER, (worldx, pos, statex, blockEntity) -> blockEntity.tickServer(worldx, pos, statex, worldx.field_9229)) : GeyserBlock.method_31618(type, WWBlockEntityTypes.GEYSER, (worldx, pos, statex, blockEntity) -> blockEntity.tickClient(worldx, pos, statex, worldx.field_9229));
    }

    public static boolean isActive(GeyserType geyserType) {
        return geyserType != GeyserType.NONE;
    }

    @NotNull
    public static class_243 getParticleVelocity(@NotNull class_2350 direction, @NotNull class_5819 random, double min, double max) {
        double difference = max - min;
        double velocity = min + random.method_43058() * difference;
        double x = (double)direction.method_10148() * velocity;
        double y = (double)direction.method_10164() * velocity;
        double z = (double)direction.method_10165() * velocity;
        return new class_243(x, y, z);
    }

    @NotNull
    public static class_243 getVelocityFromDistance(class_2338 pos, class_2350 direction, @NotNull class_243 vec3, @NotNull class_5819 random, double max) {
        return vec3.method_1020(GeyserBlock.getParticlePosWithoutRandom(pos, direction, random)).method_1021(random.method_43058() * max);
    }

    @NotNull
    public static class_243 getParticlePosWithoutRandom(class_2338 pos, class_2350 direction, class_5819 random) {
        return class_243.method_24954((class_2382)pos).method_1031(GeyserBlock.getParticleOffsetX(direction, random, false), GeyserBlock.getParticleOffsetY(direction, random, false), GeyserBlock.getParticleOffsetZ(direction, random, false));
    }

    @NotNull
    public static class_243 getParticlePos(class_2338 pos, class_2350 direction, class_5819 random) {
        return class_243.method_24954((class_2382)pos).method_1031(GeyserBlock.getParticleOffsetX(direction, random, true), GeyserBlock.getParticleOffsetY(direction, random, true), GeyserBlock.getParticleOffsetZ(direction, random, true));
    }

    private static double getRandomParticleOffset(@NotNull class_5819 random) {
        return random.method_43058() / 3.0 * (random.method_43056() ? 1.0 : -1.0);
    }

    private static double getParticleOffsetX(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11035, class_2350.field_11043 -> 0.5 + (useRandom ? GeyserBlock.getRandomParticleOffset(random) : 0.0);
            case class_2350.field_11034 -> 1.05;
            case class_2350.field_11039 -> -0.05;
        };
    }

    private static double getParticleOffsetY(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11033 -> -0.05;
            case class_2350.field_11036 -> 1.05;
            case class_2350.field_11035, class_2350.field_11043, class_2350.field_11034, class_2350.field_11039 -> 0.5 + (useRandom ? GeyserBlock.getRandomParticleOffset(random) : 0.0);
        };
    }

    private static double getParticleOffsetZ(@NotNull class_2350 direction, class_5819 random, boolean useRandom) {
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11036, class_2350.field_11033, class_2350.field_11034, class_2350.field_11039 -> 0.5 + (useRandom ? GeyserBlock.getRandomParticleOffset(random) : 0.0);
            case class_2350.field_11043 -> -0.05;
            case class_2350.field_11035 -> 1.05;
        };
    }
}

