/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.block;

import com.mojang.serialization.MapCodec;
import net.frozenblock.wilderwild.block.impl.SnowloggingUtils;
import net.frozenblock.wilderwild.registry.WWBlocks;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.minecraft.class_10225;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2256;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2756;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShrubBlock
extends class_2261
implements class_2256 {
    public static final int GROWTH_CHANCE = 7;
    public static final float ALMOST_FULLY_GROWN_GROWTH_CHANCE = 0.75f;
    public static final float BONEMEAL_SUCCESS_CHANCE = 0.65f;
    public static final float ALMOST_FULLY_GROWN_BONEMEAL_SUCCESS_CHANCE = 0.45f;
    public static final int MAX_AGE = 2;
    public static final int ALMOST_MAX_AGE = 1;
    public static final int MIN_AGE = 0;
    public static final class_2758 AGE = class_2741.field_12556;
    private static final class_2754<class_2756> HALF = class_2741.field_12533;
    public static final MapCodec<ShrubBlock> CODEC = ShrubBlock.method_54094(ShrubBlock::new);

    public ShrubBlock(@NotNull class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)((class_2680)this.field_10647.method_11664()).method_11657((class_2769)AGE, (Comparable)Integer.valueOf(0))).method_11657(HALF, (Comparable)class_2756.field_12607));
    }

    public static boolean isFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 2;
    }

    public static boolean isAlmostFullyGrown(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 1;
    }

    public static boolean isMinimumAge(@NotNull class_2680 state) {
        return (Integer)state.method_11654((class_2769)AGE) == 0;
    }

    public static boolean isLower(@NotNull class_2680 state) {
        return state.method_11654(HALF) == class_2756.field_12607;
    }

    private static void preventDropFromBottomPart(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_1657 player) {
        class_2338 blockPos;
        class_2680 blockState;
        class_2756 doubleBlockHalf = (class_2756)state.method_11654(HALF);
        if (doubleBlockHalf == class_2756.field_12609 && (blockState = level.method_8320(blockPos = pos.method_10074())).method_27852(state.method_26204()) && blockState.method_11654(HALF) == class_2756.field_12607) {
            class_2680 setState;
            class_2680 class_26802 = setState = blockState.method_28498((class_2769)class_2741.field_12508) && (Boolean)blockState.method_11654((class_2769)class_2741.field_12508) != false ? class_2246.field_10382.method_9564() : class_2246.field_10124.method_9564();
            if (setState.method_26215() && setState.method_26227().method_15769() && SnowloggingUtils.isSnowlogged(state)) {
                setState = SnowloggingUtils.getSnowEquivalent(state);
            }
            level.method_8652(blockPos, setState, 35);
            level.method_8444((class_1297)player, 2001, blockPos, class_2248.method_9507((class_2680)blockState));
        }
    }

    @NotNull
    protected MapCodec<? extends ShrubBlock> method_53969() {
        return CODEC;
    }

    protected void method_9515(// Could not load outer class - annotation placement on inner may be incorrect
     @NotNull class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(new class_2769[]{AGE, HALF});
    }

    @NotNull
    protected class_2680 method_9559(@NotNull class_2680 blockState, class_4538 levelReader, class_10225 scheduledTickAccess, class_2338 blockPos, class_2350 direction, class_2338 neighborPos, class_2680 neighborState, class_5819 randomSource) {
        if (ShrubBlock.isFullyGrown(blockState)) {
            class_2756 doubleBlockHalf = (class_2756)blockState.method_11654(HALF);
            if (!(direction.method_10166() != class_2350.class_2351.field_11052 || doubleBlockHalf == class_2756.field_12607 != (direction == class_2350.field_11036) || neighborState.method_27852((class_2248)this) && neighborState.method_11654(HALF) != doubleBlockHalf)) {
                return class_2246.field_10124.method_9564();
            }
            if (doubleBlockHalf == class_2756.field_12607 && direction == class_2350.field_11033 && !blockState.method_26184(levelReader, blockPos)) {
                return class_2246.field_10124.method_9564();
            }
        }
        return super.method_9559(blockState, levelReader, scheduledTickAccess, blockPos, direction, neighborPos, neighborState, randomSource);
    }

    public void method_9514(@NotNull class_2680 state, @NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_5819 random) {
        super.method_9514(state, level, pos, random);
        if (!ShrubBlock.isFullyGrown(state) && random.method_43048(7) == 0 && level.method_22335(pos, 0) >= 9) {
            if (ShrubBlock.isAlmostFullyGrown(state) && random.method_43057() < 0.75f) {
                return;
            }
            this.grow((class_1937)level, state, pos);
        }
    }

    public void grow(@NotNull class_1937 level, @NotNull class_2680 state, @NotNull class_2338 pos) {
        class_2680 setState = (class_2680)state.method_28493((class_2769)AGE);
        if (ShrubBlock.isAlmostFullyGrown(state)) {
            class_2338 above = pos.method_10084();
            if (level.method_8320(above).method_26215()) {
                level.method_8652(pos, setState, 2);
                level.method_8652(above, (class_2680)((class_2680)this.method_9564().method_11657((class_2769)AGE, (Comparable)((Integer)setState.method_11654((class_2769)AGE)))).method_11657(HALF, (Comparable)class_2756.field_12609), 2);
            }
        } else {
            level.method_8652(pos, setState, 2);
        }
    }

    @NotNull
    public class_1269 method_55765(@NotNull class_1799 stack, @NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 hit) {
        if (stack.method_31574(class_1802.field_8868) && this.onShear(level, pos, state, (class_1297)player)) {
            stack.method_7970(1, (class_1309)player, class_1309.method_56079((class_1268)hand));
            return class_1269.field_5812;
        }
        return super.method_55765(stack, state, level, pos, player, hand, hit);
    }

    public boolean onShear(class_1937 level, class_2338 pos, @NotNull class_2680 state, @Nullable class_1297 entity) {
        if (!ShrubBlock.isMinimumAge(state)) {
            if (!level.field_9236) {
                level.method_8396(null, pos, class_3417.field_34896, class_3419.field_15245, 1.0f, 1.0f);
                if (ShrubBlock.isFullyGrown(state)) {
                    class_1542 itemEntity = new class_1542(level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.75, (double)pos.method_10260() + 0.5, new class_1799((class_1935)WWBlocks.SHRUB));
                    level.method_8649((class_1297)itemEntity);
                }
                state = this.setAgeOnBothHalves(state, level, pos, (Integer)state.method_11654((class_2769)AGE) - 1, true);
                level.method_33596(entity, (class_6880)class_5712.field_28730, pos);
                this.removeTopHalfIfYoung(state, level, pos);
            }
            return true;
        }
        return false;
    }

    protected boolean method_9695(@NotNull class_2680 state, @NotNull class_1922 level, @NotNull class_2338 pos) {
        return state.method_26164(WWBlockTags.SHRUB_MAY_PLACE_ON) || super.method_9695(state, level, pos);
    }

    public boolean method_9558(@NotNull class_2680 state, @NotNull class_4538 level, @NotNull class_2338 pos) {
        class_2338 blockPos = pos.method_10074();
        if (state.method_27852((class_2248)this) && !ShrubBlock.isLower(state)) {
            class_2680 otherState = level.method_8320(blockPos);
            return otherState.method_27852((class_2248)this) && ShrubBlock.isLower(otherState) && ShrubBlock.isFullyGrown(otherState) && ShrubBlock.isFullyGrown(state);
        }
        return this.method_9695(level.method_8320(blockPos), (class_1922)level, blockPos);
    }

    public boolean method_9651(@NotNull class_4538 level, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return ShrubBlock.isMinimumAge(state) || ShrubBlock.isAlmostFullyGrown(state) && ShrubBlock.isLower(state) && level.method_8320(pos.method_10084()).method_26215() || ShrubBlock.isFullyGrown(state);
    }

    public boolean method_9650(@NotNull class_1937 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        return !ShrubBlock.isAlmostFullyGrown(state) ? level.method_8409().method_43057() < 0.65f : level.method_8409().method_43057() < 0.45f;
    }

    public void method_9652(@NotNull class_3218 level, @NotNull class_5819 random, @NotNull class_2338 pos, @NotNull class_2680 state) {
        if (ShrubBlock.isFullyGrown(state)) {
            class_2248.method_9577((class_1937)level, (class_2338)pos, (class_1799)new class_1799((class_1935)this));
        } else {
            this.grow((class_1937)level, state, pos);
        }
    }

    public long method_9535(@NotNull class_2680 state, @NotNull class_2338 pos) {
        try {
            return ShrubBlock.isFullyGrown(state) ? class_3532.method_15371((int)pos.method_10263(), (int)pos.method_10087(state.method_11654(HALF) == class_2756.field_12607 ? 0 : 1).method_10264(), (int)pos.method_10260()) : super.method_9535(state, pos);
        }
        catch (IllegalArgumentException e) {
            return super.method_9535(state, pos);
        }
    }

    @NotNull
    public class_2680 method_9576(@NotNull class_1937 level, @NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_1657 player) {
        if (!level.field_9236 && !SnowloggingUtils.isSnowlogged(state)) {
            class_2338 belowPos;
            class_2680 belowState;
            boolean creative = player.method_68878();
            boolean canContinue = true;
            if (!creative && state.method_11654((class_2769)class_2320.field_10929) == class_2756.field_12609 && SnowloggingUtils.isSnowlogged(belowState = level.method_8320(belowPos = pos.method_10074()))) {
                class_2248.method_9511((class_2680)((class_2680)state.method_11657((class_2769)class_2320.field_10929, (Comparable)class_2756.field_12607)), (class_1937)level, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
                canContinue = false;
            }
            if (canContinue && ShrubBlock.isFullyGrown(state)) {
                if (creative) {
                    try {
                        ShrubBlock.preventDropFromBottomPart(level, pos, state, player);
                    }
                    catch (IllegalArgumentException e) {
                        class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
                    }
                } else {
                    class_2248.method_9511((class_2680)state, (class_1937)level, (class_2338)pos, null, (class_1297)player, (class_1799)player.method_6047());
                }
            }
        }
        return super.method_9576(level, pos, state, player);
    }

    public void method_9556(@NotNull class_1937 level, @NotNull class_1657 player, @NotNull class_2338 pos, @NotNull class_2680 state, @Nullable class_2586 blockEntity, @NotNull class_1799 stack) {
        if (SnowloggingUtils.isSnowlogged(state)) {
            class_2680 snowEquivalent = SnowloggingUtils.getSnowEquivalent(state);
            if (player.method_7305(snowEquivalent)) {
                super.method_9556(level, player, pos, snowEquivalent, blockEntity, stack);
            }
        } else {
            super.method_9556(level, player, pos, ShrubBlock.isFullyGrown(state) ? class_2246.field_10124.method_9564() : state, blockEntity, stack);
        }
    }

    @NotNull
    public class_2680 setAgeOnBothHalves(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos, int age, boolean particles) {
        class_2680 setState = (class_2680)state.method_11657((class_2769)class_2741.field_12556, (Comparable)Integer.valueOf(age));
        level.method_8501(pos, setState);
        class_2338 movedPos = state.method_11654(HALF) == class_2756.field_12609 ? pos.method_10074() : pos.method_10084();
        class_2680 secondState = level.method_8320(movedPos);
        if (secondState.method_27852((class_2248)this)) {
            level.method_8501(movedPos, (class_2680)secondState.method_11657((class_2769)class_2741.field_12556, (Comparable)Integer.valueOf(age)));
            if (particles) {
                level.method_20290(2001, movedPos, class_2248.method_9507((class_2680)secondState));
            }
        }
        if (particles) {
            level.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
        }
        return setState;
    }

    public void removeTopHalfIfYoung(@NotNull class_2680 state, @NotNull class_1937 level, @NotNull class_2338 pos) {
        if (state.method_27852((class_2248)this) && !ShrubBlock.isLower(state) && !ShrubBlock.isFullyGrown(state)) {
            level.method_8501(pos, level.method_8316(pos).method_15759());
            return;
        }
        class_2338 movedPos = pos.method_10084();
        class_2680 secondState = level.method_8320(movedPos);
        if (secondState.method_27852((class_2248)this) && !ShrubBlock.isLower(secondState) && !ShrubBlock.isFullyGrown(secondState)) {
            level.method_8501(movedPos, level.method_8316(movedPos).method_15759());
        }
    }
}

