/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.entity;

import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.frozenblock.lib.block.api.shape.FrozenShapes;
import net.frozenblock.wilderwild.config.WWEntityConfig;
import net.frozenblock.wilderwild.entity.ai.crab.CrabAi;
import net.frozenblock.wilderwild.entity.ai.crab.CrabJumpControl;
import net.frozenblock.wilderwild.entity.ai.crab.CrabMoveControl;
import net.frozenblock.wilderwild.entity.ai.crab.CrabNavigation;
import net.frozenblock.wilderwild.entity.variant.crab.CrabVariant;
import net.frozenblock.wilderwild.entity.variant.crab.CrabVariants;
import net.frozenblock.wilderwild.registry.WWDataComponents;
import net.frozenblock.wilderwild.registry.WWEntityTypes;
import net.frozenblock.wilderwild.registry.WWItems;
import net.frozenblock.wilderwild.registry.WWMemoryModuleTypes;
import net.frozenblock.wilderwild.registry.WWSounds;
import net.frozenblock.wilderwild.registry.WilderWildRegistries;
import net.frozenblock.wilderwild.tag.WWBlockTags;
import net.frozenblock.wilderwild.tag.WWGameEventTags;
import net.frozenblock.wilderwild.tag.WWItemTags;
import net.minecraft.class_10209;
import net.minecraft.class_10701;
import net.minecraft.class_10704;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1324;
import net.minecraft.class_1408;
import net.minecraft.class_1410;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1927;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_3726;
import net.minecraft.class_3730;
import net.minecraft.class_3902;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4209;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5709;
import net.minecraft.class_5712;
import net.minecraft.class_5714;
import net.minecraft.class_5715;
import net.minecraft.class_5716;
import net.minecraft.class_5761;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.class_8103;
import net.minecraft.class_8514;
import net.minecraft.class_9279;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Crab
extends class_1429
implements class_8514,
class_5761 {
    public static final float MAX_TARGET_DISTANCE = 16.0f;
    public static final double MOVEMENT_SPEED = 0.16;
    public static final float STEP_HEIGHT = 0.2f;
    public static final double WATER_MOVEMENT_SPEED = 0.576;
    public static final int DIG_LENGTH_IN_TICKS = 95;
    public static final int EMERGE_LENGTH_IN_TICKS = 29;
    public static final double UNDERGROUND_PLAYER_RANGE = 4.0;
    private static final int DIG_TICKS_UNTIL_PARTICLES = 17;
    private static final int DIG_TICKS_UNTIL_STOP_PARTICLES = 82;
    private static final int EMERGE_TICKS_UNTIL_PARTICLES = 1;
    private static final int EMERGE_TICKS_UNTIL_STOP_PARTICLES = 16;
    public static final float DIGGING_PARTICLE_OFFSET = 0.25f;
    public static final float IDLE_SOUND_VOLUME_PERCENTAGE = 0.2f;
    private static final double LATCH_TO_WALL_FORCE = 0.0195;
    private static final class_2940<String> MOVE_STATE = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Float> TARGET_CLIMBING_ANIM_X = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> TARGET_CLIMBING_ANIM_Y = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13320);
    private static final class_2940<String> CLIMBING_FACE = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Float> TARGET_CLIMBING_ANIM_AMOUNT = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Integer> DIGGING_TICKS = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> FROM_BUCKET = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> VARIANT = class_2945.method_12791(Crab.class, (class_2941)class_2943.field_13326);
    public final class_7094 diggingAnimationState = new class_7094();
    public final class_7094 emergingAnimationState = new class_7094();
    public final class_7094 hidingAnimationState = new class_7094();
    private final class_5715<class_8514.class_8516> dynamicGameEventListener;
    private final class_8514.class_5719 vibrationUser;
    private class_8514.class_8515 vibrationData;
    public class_243 prevMovement;
    public boolean cancelMovementToDescend;
    public float climbAnimX;
    public float prevClimbAnimX;
    private Optional<CrabVariant> crabVariant = Optional.empty();

    public Crab(class_1299<? extends Crab> entityType, class_1937 level) {
        super(entityType, level);
        this.vibrationUser = new VibrationUser();
        this.vibrationData = new class_8514.class_8515();
        this.dynamicGameEventListener = new class_5715((class_5714)new class_8514.class_8516((class_8514)this));
        this.field_6204 = new CrabJumpControl((class_1308)this);
        this.prevMovement = class_243.field_1353;
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_4, 0.0f);
        if (WWEntityConfig.get().unpassableRail) {
            this.method_5941(class_7.field_25418, 0.0f);
        }
        this.field_6207 = new CrabMoveControl(this);
    }

    @NotNull
    public static class_5132.class_5133 createAttributes() {
        return class_1429.method_61457().method_26868(class_5134.field_23716, 8.0).method_26868(class_5134.field_23719, 0.16).method_26868(class_5134.field_47761, (double)0.2f).method_26868(class_5134.field_23728, 0.0).method_26868(class_5134.field_23721, 2.0).method_26868(class_5134.field_23717, 16.0);
    }

    public static boolean checkCrabSpawnRules(@NotNull class_1299<Crab> type, @NotNull class_5425 level, @NotNull class_3730 spawnType, @NotNull class_2338 pos, @NotNull class_5819 random) {
        if (class_3730.method_54986((class_3730)spawnType)) {
            return true;
        }
        if (!WWEntityConfig.get().crab.spawnCrabs) {
            return false;
        }
        int seaLevel = level.method_8615();
        return pos.method_10264() >= seaLevel - 33 && level.method_8320(pos.method_10074()).method_26164(WWBlockTags.CRAB_HIDEABLE);
    }

    private static float getAngleFromVec3(@NotNull class_243 vec3) {
        float angle = (float)org.joml.Math.atan2((double)vec3.method_10215(), (double)vec3.method_10216());
        angle = (float)((double)(180.0f * angle) / Math.PI);
        angle = (360.0f + angle) % 360.0f;
        return angle;
    }

    @NotNull
    protected class_1408 method_5965(@NotNull class_1937 level) {
        return new CrabNavigation(this, level);
    }

    @NotNull
    protected class_4095.class_5303<Crab> method_28306() {
        return class_4095.method_28311(CrabAi.MEMORY_MODULES, CrabAi.SENSORS);
    }

    @NotNull
    protected class_4095<?> method_18867(@NotNull Dynamic<?> dynamic) {
        return CrabAi.makeBrain(this, (class_4095<Crab>)this.method_28306().method_28335(dynamic));
    }

    @NotNull
    public class_4095<Crab> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    public class_1315 method_5943(@NotNull class_5425 level, @NotNull class_1266 difficulty, @NotNull class_3730 reason, @Nullable class_1315 spawnData) {
        this.method_18868().method_24525(class_4140.field_38103, (Object)class_3902.field_17274, (long)CrabAi.getRandomDigCooldown((class_1309)this));
        switch (reason) {
            case field_16473: {
                return spawnData;
            }
            case field_16459: 
            case field_16461: 
            case field_16463: {
                this.method_18868().method_24525(class_4140.field_38112, (Object)class_3902.field_17274, 29L);
                break;
            }
        }
        if (spawnData instanceof CrabSpawnGroupData) {
            CrabSpawnGroupData crabGroupData = (CrabSpawnGroupData)((Object)spawnData);
            if (crabGroupData.method_22432() >= 2) {
                this.method_5614(-24000);
            }
            this.setVariant((CrabVariant)crabGroupData.type.comp_349());
        } else {
            Optional optionalCrabVariant = class_10704.method_71969((class_10701)class_10701.method_67169((class_5425)level, (class_2338)this.method_24515()), WilderWildRegistries.CRAB_VARIANT);
            if (optionalCrabVariant.isPresent()) {
                spawnData = new CrabSpawnGroupData((class_6880<CrabVariant>)((class_6880)optionalCrabVariant.get()));
                this.setVariant((CrabVariant)((class_6880.class_6883)optionalCrabVariant.get()).comp_349());
            }
        }
        return super.method_5943(level, difficulty, reason, spawnData);
    }

    public float method_6144(@NotNull class_2338 pos, @NotNull class_4538 level) {
        return 0.0f;
    }

    @Nullable
    public class_1309 method_5968() {
        return this.method_59664();
    }

    public boolean method_5767() {
        return super.method_5767() || this.isHidingUnderground();
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(MOVE_STATE, (Object)MoveState.WALKING.name());
        builder.method_56912(TARGET_CLIMBING_ANIM_X, (Object)Float.valueOf(0.0f));
        builder.method_56912(TARGET_CLIMBING_ANIM_Y, (Object)Float.valueOf(0.0f));
        builder.method_56912(TARGET_CLIMBING_ANIM_AMOUNT, (Object)Float.valueOf(0.0f));
        builder.method_56912(DIGGING_TICKS, (Object)0);
        builder.method_56912(FROM_BUCKET, (Object)false);
        builder.method_56912(CLIMBING_FACE, (Object)ClimbingFace.NORTH.name());
        builder.method_56912(VARIANT, (Object)CrabVariants.DEFAULT.method_29177().toString());
    }

    public boolean method_5957(@NotNull class_4538 level) {
        return level.method_8606((class_1297)this);
    }

    public void method_6007() {
        this.method_6119();
        class_1324 movementSpeed = this.method_5996(class_5134.field_23719);
        if (movementSpeed != null) {
            movementSpeed.method_6192(this.method_5799() ? 0.576 : 0.16);
        }
        super.method_6007();
    }

    public void method_5773() {
        boolean isClient = this.method_37908().field_9236;
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_8514.class_8517.method_51406((class_1937)serverLevel, (class_8514.class_8515)this.vibrationData, (class_8514.class_5719)this.vibrationUser);
        }
        super.method_5773();
        if (!isClient) {
            boolean isMovingUp;
            this.cancelMovementToDescend = false;
            boolean inWater = this.method_5799();
            boolean bl = isMovingUp = this.getDeltaPos().method_10214() >= 0.0;
            if (this.field_5976 && (!inWater || isMovingUp)) {
                Optional<class_243> potentialNearestWallDifference;
                this.setMoveState(isMovingUp ? MoveState.CLIMBING : MoveState.DESCENDING);
                if (this.isCrabDescending() && this.method_37908().method_52569((class_1297)this, this.method_33332().method_1012(0.0, -this.getEmptyAreaSearchDistance(), 0.0))) {
                    this.cancelMovementToDescend = this.latchOntoWall(0.0195, false);
                }
                class_243 usedMovement = this.method_18798();
                class_2350 climbedDirection = class_2350.method_10142((double)usedMovement.method_10216(), (double)0.0, (double)usedMovement.method_10215());
                this.setClimbingFace(climbedDirection);
                if (usedMovement.field_1352 == 0.0 && usedMovement.field_1350 == 0.0) {
                    usedMovement = this.prevMovement;
                }
                this.setTargetClimbAnimX(org.joml.Math.abs((float)(Crab.getAngleFromVec3(usedMovement) - Crab.getAngleFromVec3(this.method_5828(1.0f)))) / 180.0f);
                this.setTargetClimbAnimAmount(1.0f);
                this.prevMovement = usedMovement;
                if (this.method_6101() && (potentialNearestWallDifference = this.differenceToWallPos()).isPresent()) {
                    class_243 nearestWallDifference = potentialNearestWallDifference.get();
                    class_2350 wallDirection = class_2350.method_10142((double)nearestWallDifference.method_10216(), (double)0.0, (double)nearestWallDifference.method_10215());
                    class_243 climbOffset = new class_243((double)wallDirection.method_10148(), 0.0, (double)wallDirection.method_10165());
                    this.field_6206.method_19615(this.method_33571().method_1019(climbOffset));
                    this.method_36456(wallDirection.method_10144());
                    this.method_5847(wallDirection.method_10144());
                    this.method_5636(wallDirection.method_10144());
                }
            } else {
                this.setMoveState(MoveState.WALKING);
                this.setTargetClimbAnimX(0.0f);
                if (!this.method_24828() && !inWater && this.method_37908().method_52569((class_1297)this, this.method_33332().method_1012(0.0, -this.getEmptyAreaSearchDistance(), 0.0))) {
                    this.cancelMovementToDescend = this.latchOntoWall(0.0195, false);
                }
            }
            if (this.isDiggingOrEmerging()) {
                this.setDiggingTicks(this.getDiggingTicks() + 1);
            }
        } else {
            switch (this.method_18376()) {
                case field_38100: {
                    if (this.getDiggingTicks() <= 17 || this.getDiggingTicks() >= 82) break;
                    this.clientDiggingParticles();
                    break;
                }
                case field_38099: {
                    if (this.getDiggingTicks() < 1 || this.getDiggingTicks() > 16) break;
                    this.clientDiggingParticles();
                    break;
                }
            }
            boolean onClimbable = !this.isCrabWalking();
            this.prevClimbAnimX = this.climbAnimX;
            Supplier<Float> climbingVal = () -> Float.valueOf(org.joml.Math.cos((float)(this.targetClimbAnimX() * (float)Math.PI)) >= -0.275f ? -1.0f : 1.0f);
            this.climbAnimX += ((onClimbable ? climbingVal.get().floatValue() : 0.0f) - this.climbAnimX) * 0.2f;
        }
    }

    public boolean method_64397(class_3218 level, @NotNull class_1282 source, float amount) {
        boolean actuallyHurt = super.method_64397(level, source, amount);
        if (actuallyHurt) {
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1309) {
                class_1309 livingEntity = (class_1309)class_12972;
                CrabAi.wasHurtBy(level, this, livingEntity);
            }
            if (!this.isDiggingOrEmerging()) {
                CrabAi.setDigCooldown(this);
            }
        }
        return actuallyHurt;
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = class_10209.method_64146();
        profiler.method_15396("crabBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("crabActivityUpdate");
        CrabAi.updateActivity(this);
        profiler.method_15407();
        super.method_5958(level);
        this.method_18868().method_18878(WWMemoryModuleTypes.FIRST_BRAIN_TICK, (Object)class_3902.field_17274);
    }

    public double getEmptyAreaSearchDistance() {
        return this.method_6109() ? 0.8 : 2.0;
    }

    @Nullable
    public class_243 findNearestWall() {
        class_2338 crabPos = this.method_24515();
        if (this.field_44784.isPresent() && this.method_23312().equals((Object)crabPos)) {
            crabPos = crabPos.method_10084();
        }
        boolean inWater = this.method_5799();
        ArrayList<class_243> vecs = new ArrayList<class_243>();
        for (class_2338 pos : class_2338.method_10097((class_2338)crabPos.method_10069(-1, 0, -1), (class_2338)crabPos.method_10069(1, 0, 1))) {
            class_265 collisionShape;
            class_2680 state;
            if (!this.isWallPosSlowable(pos, state = this.method_37908().method_8320(pos), collisionShape = state.method_26194((class_1922)this.method_37908(), pos, class_3726.method_16195((class_1297)this)))) continue;
            Optional optionalVec3 = FrozenShapes.closestPointTo((class_2338)pos, (class_265)collisionShape, (class_243)this.method_19538());
            if (optionalVec3.isPresent()) {
                vecs.add((class_243)optionalVec3.get());
                continue;
            }
            if (inWater || !state.method_26227().method_15767(class_3486.field_15517)) continue;
            vecs.add(pos.method_46558());
        }
        return this.getClosestPos(vecs);
    }

    @Nullable
    public class_243 getClosestPos(@NotNull List<class_243> vec3s) {
        double lowestDistance = Double.MAX_VALUE;
        class_243 selectedVec3 = null;
        class_243 thisPos = this.method_33571();
        for (class_243 vec3 : vec3s) {
            double distance = vec3.method_1022(thisPos);
            if (!(distance < lowestDistance)) continue;
            lowestDistance = distance;
            selectedVec3 = vec3;
        }
        return selectedVec3;
    }

    public boolean isWallPosSlowable(@NotNull class_2338 pos, @NotNull class_2680 state, @NotNull class_265 collisionShape) {
        if (state.method_26215() || state.method_26227().method_15767(class_3486.field_15518)) {
            return false;
        }
        return !collisionShape.method_1110() && (double)pos.method_10264() + collisionShape.method_1091(class_2350.class_2351.field_11052) <= this.method_23320() || state.method_26227().method_15767(class_3486.field_15517);
    }

    @NotNull
    private Optional<class_243> differenceToWallPos() {
        class_243 wallPos = this.findNearestWall();
        if (wallPos != null) {
            return Optional.of(wallPos.method_1020(this.method_19538()));
        }
        return Optional.empty();
    }

    public boolean latchOntoWall(double latchForce, boolean stopDownwardsMovement) {
        boolean canLatch = false;
        class_243 wallPos = this.findNearestWall();
        if (wallPos != null) {
            canLatch = true;
            class_243 differenceBetween = wallPos.method_1020(this.method_19538());
            class_243 deltaMovement = this.method_18798();
            this.method_18800(deltaMovement.method_10216() + (differenceBetween.method_10216() < 0.0 ? -latchForce : (differenceBetween.method_10216() > 0.0 ? latchForce : 0.0)), stopDownwardsMovement ? org.joml.Math.max((double)0.0, (double)deltaMovement.method_10214()) : deltaMovement.method_10214(), deltaMovement.method_10215() + (differenceBetween.method_10215() < 0.0 ? -latchForce : (differenceBetween.method_10215() > 0.0 ? latchForce : 0.0)));
        }
        return canLatch;
    }

    @Nullable
    protected class_3414 method_6011(@NotNull class_1282 damageSource) {
        return WWSounds.ENTITY_CRAB_HURT;
    }

    @Nullable
    protected class_3414 method_6002() {
        return WWSounds.ENTITY_CRAB_DEATH;
    }

    protected void method_5712(class_2338 blockPos, class_2680 blockState) {
        this.method_5783(WWSounds.ENTITY_CRAB_STEP, 0.3f, this.method_6017());
    }

    @Nullable
    protected class_3414 method_5994() {
        return this.isHidingUnderground() ? null : WWSounds.ENTITY_CRAB_IDLE;
    }

    public int method_5970() {
        return 400;
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        if (soundEvent != null) {
            this.method_5783(soundEvent, this.method_6107() * 0.2f, this.method_6017());
        }
    }

    protected float method_5867() {
        return this.field_5994 + 0.55f;
    }

    public boolean method_6121(class_3218 serverLevel, class_1297 entity) {
        this.method_37908().method_8421((class_1297)this, (byte)4);
        this.method_5783(WWSounds.ENTITY_CRAB_ATTACK, this.method_6107(), this.method_6017());
        return super.method_6121(serverLevel, entity);
    }

    public boolean method_5679(class_3218 level, @NotNull class_1282 source) {
        if (this.isDiggingOrEmerging() && !source.method_48789(class_8103.field_42242)) {
            return true;
        }
        return super.method_5679(level, source);
    }

    public boolean method_5810() {
        return !this.isDiggingOrEmerging() && super.method_5810();
    }

    protected void method_6087(@NotNull class_1297 entity) {
        if (this.isHidingUnderground()) {
            return;
        }
        super.method_6087(entity);
    }

    public boolean method_5675() {
        return false;
    }

    public boolean method_5659(class_1927 explosion) {
        return this.isDiggingOrEmerging();
    }

    public boolean isDiggingOrEmerging() {
        return this.method_41328(class_4050.field_38100) || this.method_41328(class_4050.field_38099);
    }

    public boolean isHidingUnderground() {
        return this.method_41328(class_4050.field_38100) && this.getDiggingTicks() > 95;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Contract(value="null->false")
    public boolean canTargetEntity(@Nullable class_1297 entity) {
        if (!(entity instanceof class_1309)) return false;
        class_1309 livingEntity = (class_1309)entity;
        if (this.method_37908() != livingEntity.method_37908()) return false;
        if (this.method_37908().method_8407().equals((Object)class_1267.field_5801)) return false;
        if (!class_1301.field_6156.test(livingEntity)) return false;
        if (this.method_5722((class_1297)livingEntity)) return false;
        if (livingEntity.method_5864() == class_1299.field_6131) return false;
        if (livingEntity.method_5864() == WWEntityTypes.CRAB) return false;
        if (livingEntity.method_5655()) return false;
        if (livingEntity.method_29504()) return false;
        if (livingEntity.method_31481()) return false;
        if (!this.method_37908().method_8621().method_11966(livingEntity.method_5829())) return false;
        return true;
    }

    public boolean canHideOnGround() {
        class_2338 topPos;
        class_2338 onPos = this.method_23312();
        if (onPos.equals((Object)(topPos = this.method_24515()))) {
            topPos = topPos.method_10084();
        }
        return this.method_24828() && !this.method_30632(topPos, this.method_37908().method_8320(topPos)) && this.method_37908().method_8320(onPos).method_26164(WWBlockTags.CRAB_HIDEABLE);
    }

    public boolean canEmerge() {
        class_2680 state;
        class_2338 blockPos = this.method_24515();
        if (blockPos.equals((Object)this.method_23312())) {
            blockPos = blockPos.method_10084();
        }
        return !(state = this.method_37908().method_8320(blockPos)).method_26164(class_3481.field_21952) && !state.method_26227().method_15767(class_3486.field_15518);
    }

    public void endNavigation() {
        this.method_5942().method_6340();
        class_1408 class_14082 = this.method_5942();
        if (class_14082 instanceof class_1410) {
            class_1410 wallClimberNavigation = (class_1410)class_14082;
            wallClimberNavigation.field_6687 = null;
        }
    }

    @NotNull
    public class_243 getDeltaPos() {
        return this.method_30950(1.0f).method_1020(this.method_30950(0.0f));
    }

    public void method_5674(@NotNull class_2940<?> key) {
        if (field_18064.equals(key)) {
            switch (this.method_18376()) {
                case field_38100: {
                    this.diggingAnimationState.method_41322(this.field_6012);
                    this.emergingAnimationState.method_41325();
                    this.hidingAnimationState.method_41325();
                    break;
                }
                case field_38099: {
                    this.diggingAnimationState.method_41325();
                    this.emergingAnimationState.method_41322(this.field_6012);
                    this.hidingAnimationState.method_41325();
                    break;
                }
                default: {
                    this.diggingAnimationState.method_41325();
                    this.emergingAnimationState.method_41325();
                    this.hidingAnimationState.method_41325();
                    break;
                }
            }
        } else if (DIGGING_TICKS.equals(key) && this.getDiggingTicks() > 95 && this.method_18376() == class_4050.field_38100) {
            this.diggingAnimationState.method_41325();
            this.emergingAnimationState.method_41325();
            this.hidingAnimationState.method_41322(this.field_6012);
        } else if (VARIANT.equals(key)) {
            this.crabVariant = Optional.of(this.getVariant());
        }
        super.method_5674(key);
    }

    public boolean method_6101() {
        return !this.isCrabWalking();
    }

    public boolean method_21752() {
        return this.isCrabDescending();
    }

    public MoveState moveState() {
        return MoveState.valueOf((String)this.field_6011.method_12789(MOVE_STATE));
    }

    public boolean isCrabClimbing() {
        return this.moveState() == MoveState.CLIMBING;
    }

    public boolean isCrabDescending() {
        return this.moveState() == MoveState.DESCENDING;
    }

    public boolean isCrabWalking() {
        return this.moveState() == MoveState.WALKING;
    }

    public void setMoveState(@NotNull MoveState state) {
        this.field_6011.method_12778(MOVE_STATE, (Object)state.name());
    }

    public ClimbingFace getClimbingFace() {
        return ClimbingFace.valueOf((String)this.field_6011.method_12789(CLIMBING_FACE));
    }

    public void setClimbingFace(@NotNull class_2350 direction) {
        this.field_6011.method_12778(CLIMBING_FACE, (Object)(switch (direction) {
            case class_2350.field_11034 -> ClimbingFace.EAST.name();
            case class_2350.field_11039 -> ClimbingFace.WEST.name();
            case class_2350.field_11035 -> ClimbingFace.SOUTH.name();
            default -> ClimbingFace.NORTH.name();
        }));
    }

    public float targetClimbAnimX() {
        return ((Float)this.field_6011.method_12789(TARGET_CLIMBING_ANIM_X)).floatValue();
    }

    public void setTargetClimbAnimX(float f) {
        this.field_6011.method_12778(TARGET_CLIMBING_ANIM_X, (Object)Float.valueOf(f));
    }

    public float targetClimbAnimAmount() {
        return ((Float)this.field_6011.method_12789(TARGET_CLIMBING_ANIM_AMOUNT)).floatValue();
    }

    public void setTargetClimbAnimAmount(float f) {
        this.field_6011.method_12778(TARGET_CLIMBING_ANIM_AMOUNT, (Object)Float.valueOf(f));
    }

    public int getDiggingTicks() {
        return (Integer)this.field_6011.method_12789(DIGGING_TICKS);
    }

    public void setDiggingTicks(int i) {
        this.field_6011.method_12778(DIGGING_TICKS, (Object)i);
    }

    public void resetDiggingTicks() {
        this.setDiggingTicks(0);
    }

    public boolean method_6481(@NotNull class_1799 stack) {
        return stack.method_31573(WWItemTags.CRAB_FOOD);
    }

    public boolean method_6453() {
        return (Boolean)this.field_6011.method_12789(FROM_BUCKET);
    }

    public void method_6454(boolean fromBucket) {
        this.field_6011.method_12778(FROM_BUCKET, (Object)fromBucket);
    }

    public void method_29242(boolean includeHeight) {
        super.method_29242(this.method_6101() || includeHeight);
    }

    @Nullable
    public class_1296 method_5613(@NotNull class_3218 level, @NotNull class_1296 otherParent) {
        Crab crab = (Crab)WWEntityTypes.CRAB.method_5883((class_1937)level, class_3730.field_16466);
        if (crab != null) {
            crab.method_5971();
            crab.method_18868().method_24525(class_4140.field_38103, (Object)class_3902.field_17274, (long)CrabAi.getRandomDigCooldown((class_1309)crab));
            if (otherParent instanceof Crab) {
                Crab otherCrab = (Crab)otherParent;
                crab.setVariant(level.field_9229.method_43056() ? this.getVariant() : otherCrab.getVariant());
            }
        }
        return crab;
    }

    @NotNull
    public class_1269 method_5992(@NotNull class_1657 player, @NotNull class_1268 hand) {
        return class_5761.method_35169((class_1657)player, (class_1268)hand, (class_1309)this).orElse(super.method_5992(player, hand));
    }

    @Nullable
    public <T> T method_58694(class_9331<? extends T> dataComponentType) {
        if (dataComponentType == WWDataComponents.CRAB_VARIANT) {
            return (T)Crab.method_66651(dataComponentType, this.getVariantAsHolder());
        }
        return (T)super.method_58694(dataComponentType);
    }

    protected void method_66649(class_9473 dataComponentGetter) {
        this.method_66650(dataComponentGetter, WWDataComponents.CRAB_VARIANT);
        super.method_66649(dataComponentGetter);
    }

    protected <T> boolean method_66654(class_9331<T> dataComponentType, T object) {
        if (dataComponentType == WWDataComponents.CRAB_VARIANT) {
            this.setVariant((CrabVariant)((class_6880)Crab.method_66651(WWDataComponents.CRAB_VARIANT, object)).comp_349());
            return true;
        }
        return super.method_66654(dataComponentType, object);
    }

    public void method_6455(@NotNull class_1799 stack) {
        class_5761.method_35167((class_1308)this, (class_1799)stack);
        stack.method_66697(WWDataComponents.CRAB_VARIANT, (class_9473)this);
        class_9279.method_57452((class_9331)class_9334.field_49610, (class_1799)stack, compoundTag -> {
            compoundTag.method_10569("Age", this.method_5618());
            class_4095<Crab> brain = this.method_18868();
            if (brain.method_18896(class_4140.field_30246)) {
                compoundTag.method_10544("HuntingCooldown", brain.method_36978(class_4140.field_30246));
            }
        });
        stack.method_66697(WWDataComponents.CRAB_VARIANT, (class_9473)this);
    }

    public void method_35170(@NotNull class_2487 compoundTag) {
        class_5761.method_35168((class_1308)this, (class_2487)compoundTag);
        compoundTag.method_10550("Age").ifPresent(arg_0 -> ((Crab)this).method_5614(arg_0));
        compoundTag.method_10537("HuntingCooldown").ifPresent(huntingCooldown -> this.method_18868().method_24525(class_4140.field_30246, (Object)true, huntingCooldown.longValue()));
    }

    @NotNull
    public class_1799 method_6452() {
        return new class_1799((class_1935)WWItems.CRAB_BUCKET);
    }

    @NotNull
    public class_3414 method_35171() {
        return WWSounds.ITEM_BUCKET_FILL_CRAB;
    }

    public boolean method_17326() {
        return super.method_17326() || this.method_6453();
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return !this.method_6453() && !this.method_16914();
    }

    private void clientDiggingParticles() {
        class_5819 randomSource = this.method_59922();
        class_2680 blockState = this.method_25936();
        if (blockState.method_26217() != class_2464.field_11455) {
            double y = this.method_23318();
            double x = this.method_23317();
            double z = this.method_23321();
            class_2388 particleOptions = new class_2388(class_2398.field_11217, blockState);
            for (int i = 0; i < 8; ++i) {
                double particleX = x + (double)class_3532.method_32750((class_5819)randomSource, (float)-0.25f, (float)0.25f);
                double particleZ = z + (double)class_3532.method_32750((class_5819)randomSource, (float)-0.25f, (float)0.25f);
                this.method_37908().method_8406((class_2394)particleOptions, particleX, y, particleZ, 0.0, 0.0, 0.0);
            }
        }
    }

    public boolean isDitto() {
        return this.method_16914() && this.method_5797().getString().equalsIgnoreCase("ditto");
    }

    public class_2960 getVariantLocation() {
        return class_2960.method_60654((String)((String)this.field_6011.method_12789(VARIANT)));
    }

    public CrabVariant getVariantByLocation() {
        return (CrabVariant)this.method_56673().method_30530(WilderWildRegistries.CRAB_VARIANT).method_63535(this.getVariantLocation());
    }

    public class_6880<CrabVariant> getVariantAsHolder() {
        return (class_6880)this.method_56673().method_30530(WilderWildRegistries.CRAB_VARIANT).method_10223(this.getVariantLocation()).orElseThrow();
    }

    public CrabVariant getVariantForRendering() {
        return this.crabVariant.orElse((CrabVariant)this.method_56673().method_30530(WilderWildRegistries.CRAB_VARIANT).method_29107(CrabVariants.DEFAULT));
    }

    public void setVariant(@NotNull CrabVariant variant) {
        this.field_6011.method_12778(VARIANT, (Object)Objects.requireNonNull(this.method_56673().method_30530(WilderWildRegistries.CRAB_VARIANT).method_10221((Object)variant)).toString());
    }

    public void setVariant(@NotNull class_2960 variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant.toString());
    }

    public CrabVariant getVariant() {
        return this.getVariantByLocation();
    }

    public void method_5652(@NotNull class_11372 valueOutput) {
        super.method_5652(valueOutput);
        valueOutput.method_71469("variant", this.getVariantLocation().toString());
        valueOutput.method_71472("FromBucket", this.method_6453());
        valueOutput.method_71465("DigTicks", this.getDiggingTicks());
        valueOutput.method_71469("EntityPose", this.method_18376().name());
        valueOutput.method_71468("PrevMovement", class_243.field_38277, (Object)this.prevMovement);
        valueOutput.method_71463("PrevX", this.prevMovement.field_1352);
        valueOutput.method_71463("PrevY", this.prevMovement.field_1351);
        valueOutput.method_71463("PrevZ", this.prevMovement.field_1350);
        valueOutput.method_71472("CancelMovementToDescend", this.cancelMovementToDescend);
        valueOutput.method_71469("ClimbingFace", this.getClimbingFace().name());
        valueOutput.method_71464("TargetClimbAnimX", this.targetClimbAnimX());
        valueOutput.method_71464("TargetClimbAnimAmount", this.targetClimbAnimAmount());
        valueOutput.method_71468("listener", class_8514.class_8515.field_44640, (Object)this.vibrationData);
    }

    public void method_5749(@NotNull class_11368 valueInput) {
        super.method_5749(valueInput);
        class_10704.method_67178((class_11368)valueInput, WilderWildRegistries.CRAB_VARIANT).ifPresent(variant -> this.setVariant((CrabVariant)variant.comp_349()));
        this.method_6454(valueInput.method_71433("FromBucket", false));
        this.setDiggingTicks(valueInput.method_71424("DigTicks", 0));
        valueInput.method_71441("EntityPose").ifPresent(entityPose -> {
            if (Arrays.stream(class_4050.values()).anyMatch(pose -> pose.name().equals(entityPose))) {
                this.method_18380(class_4050.valueOf((String)entityPose));
            }
        });
        this.prevMovement = valueInput.method_71426("PrevMovement", class_243.field_38277).orElse(class_243.field_1353);
        this.cancelMovementToDescend = valueInput.method_71433("CancelMovementToDescend", false);
        valueInput.method_71441("ClimbingFace").ifPresent(climingFace -> {
            if (Arrays.stream(ClimbingFace.values()).anyMatch(climbingFace -> climbingFace.name().equals(climingFace))) {
                this.setClimbingFace(ClimbingFace.valueOf((String)climingFace).direction);
            }
        });
        this.setTargetClimbAnimX(valueInput.method_71423("TargetClimbAnimX", 0.0f));
        this.setTargetClimbAnimAmount(valueInput.method_71423("TargetClimbAnimAmount", 0.0f));
        this.vibrationData = valueInput.method_71426("listener", class_8514.class_8515.field_44640).orElseGet(class_8514.class_8515::new);
    }

    @NotNull
    public class_8514.class_8515 method_51298() {
        return this.vibrationData;
    }

    @NotNull
    public class_8514.class_5719 method_51299() {
        return this.vibrationUser;
    }

    public void method_42147(@NotNull BiConsumer<class_5715<?>, class_3218> listenerConsumer) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            listenerConsumer.accept(this.dynamicGameEventListener, serverLevel);
        }
    }

    public class VibrationUser
    implements class_8514.class_5719 {
        private static final int GAME_EVENT_LISTENER_RANGE = 8;
        private final class_5716 positionSource;

        private VibrationUser() {
            this.positionSource = new class_5709((class_1297)Crab.this, Crab.this.method_5751());
        }

        public int method_49797() {
            return 8;
        }

        @NotNull
        public class_5716 method_51300() {
            return this.positionSource;
        }

        @NotNull
        public class_6862<class_5712> method_42210() {
            return WWGameEventTags.CRAB_CAN_DETECT;
        }

        public boolean method_32970(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull class_5712.class_7397 context) {
            return Crab.this.method_5805() && Crab.this.isHidingUnderground() && (context.comp_713() instanceof class_1657 || gameEvent.method_40220(WWGameEventTags.CRAB_CAN_ALWAYS_DETECT));
        }

        public void method_32969(@NotNull class_3218 level, @NotNull class_2338 pos, @NotNull class_6880<class_5712> gameEvent, @Nullable class_1297 entity, @Nullable class_1297 playerEntity, float distance) {
            if (Crab.this.method_5805() && Crab.this.isHidingUnderground()) {
                CrabAi.clearDigCooldown(Crab.this);
            }
        }
    }

    public static class CrabSpawnGroupData
    extends class_1296.class_4697 {
        public final class_6880<CrabVariant> type;

        public CrabSpawnGroupData(class_6880<CrabVariant> holder) {
            super(false);
            this.type = holder;
        }
    }

    public static enum MoveState {
        WALKING("walking"),
        CLIMBING("climbing"),
        DESCENDING("descending");

        public final String name;

        private MoveState(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum ClimbingFace {
        NORTH("north", class_2350.field_11043, -90.0f),
        EAST("east", class_2350.field_11034, 90.0f),
        SOUTH("south", class_2350.field_11035, 0.0f),
        WEST("west", class_2350.field_11039, 180.0f);

        public final class_2350 direction;
        public final String name;
        public final float rotation;

        private ClimbingFace(String name, class_2350 direction, float rotation) {
            this.name = name;
            this.direction = direction;
            this.rotation = rotation;
        }

        public String toString() {
            return this.name;
        }
    }
}

