/*
 * Decompiled with CFR 0.152.
 */
package net.frozenblock.wilderwild.wind;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.frozenblock.lib.particle.client.options.WindParticleOptions;
import net.frozenblock.lib.wind.client.api.ClientWindManagerExtension;
import net.frozenblock.lib.wind.client.impl.ClientWindManager;
import net.frozenblock.wilderwild.config.WWAmbienceAndMiscConfig;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;

@Environment(value=EnvType.CLIENT)
public final class WWClientWindManager
implements ClientWindManagerExtension {
    public static double prevCloudX;
    public static double prevCloudZ;
    public static double cloudX;
    public static double cloudZ;

    public static double getCloudX(float partialTick) {
        return class_3532.method_16436((double)partialTick, (double)prevCloudX, (double)cloudX);
    }

    public static double getCloudZ(float partialTick) {
        return class_3532.method_16436((double)partialTick, (double)prevCloudZ, (double)cloudZ);
    }

    public void clientTick() {
        prevCloudX = cloudX;
        prevCloudZ = cloudZ;
        cloudX += ClientWindManager.laggedWindX * 0.007;
        cloudZ += ClientWindManager.laggedWindZ * 0.007;
        class_310 minecraft = class_310.method_1551();
        class_638 level = minecraft.field_1687;
        if (level != null) {
            class_2338 pos = minecraft.field_1773.method_19418().method_19328();
            this.animateTick(level, pos.method_10263(), pos.method_10264(), pos.method_10260());
        }
    }

    public void animateTick(@NotNull class_638 level, int posX, int posY, int posZ) {
        int i;
        class_5819 randomSource = level.field_9229;
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        if (WWAmbienceAndMiscConfig.WIND_PARTICLES) {
            for (i = 0; i < WWAmbienceAndMiscConfig.WIND_PARTICLE_SPAWN_ATTEMPTS; ++i) {
                this.spawnAmbientWindParticles(level, posX, posY, posZ, 48, randomSource, mutableBlockPos);
            }
        }
        if (WWAmbienceAndMiscConfig.WIND_DISTURBANCE_PARTICLES) {
            for (i = 0; i < WWAmbienceAndMiscConfig.WIND_DISTURBANCE_PARTICLE_SPAWN_ATTEMPTS; ++i) {
                this.spawnDisturbanceWindParticles(level, posX, posY, posZ, 48, randomSource, mutableBlockPos);
            }
        }
    }

    public void spawnAmbientWindParticles(@NotNull class_638 level, int posX, int posY, int posZ, int range, @NotNull class_5819 random, @NotNull class_2338.class_2339 blockPos) {
        int highestPossibleY = posY + range;
        int x = posX + random.method_39332(-range, range);
        int y = posY;
        int z = posZ + random.method_39332(-range, range);
        blockPos.method_10103(x, y, z);
        blockPos.method_10101((class_2382)level.method_8598(class_2902.class_2903.field_13203, (class_2338)blockPos));
        int heightmapY = blockPos.method_10264();
        if (heightmapY > highestPossibleY) {
            return;
        }
        if (heightmapY < posY - range) {
            y += random.method_43048(range) - random.method_43048(range);
        } else {
            double differenceInPoses = highestPossibleY - heightmapY;
            if (random.method_43058() >= differenceInPoses / ((double)range * 2.0)) {
                return;
            }
            y = random.method_39332(heightmapY, highestPossibleY);
        }
        blockPos.method_10103(x, y, z);
        class_243 wind = ClientWindManager.getWindMovement((class_1937)level, (class_243)class_243.method_24953((class_2382)blockPos), (double)1.0, (double)2.0, (double)2.0);
        double horizontalWind = wind.method_37267();
        if (random.method_43058() >= horizontalWind * WWAmbienceAndMiscConfig.getWindParticleFrequency()) {
            return;
        }
        level.method_8406((class_2394)new WindParticleOptions((int)(10.0 + horizontalWind * 30.0), wind.field_1352 * 0.01, wind.field_1351 * 0.0015, wind.field_1350 * 0.01), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    public void spawnDisturbanceWindParticles(@NotNull class_638 level, int posX, int posY, int posZ, int range, @NotNull class_5819 random, @NotNull class_2338.class_2339 blockPos) {
        int x = posX + random.method_39332(-range, range);
        int y = posY + random.method_39332(-range, range);
        int z = posZ + random.method_39332(-range, range);
        blockPos.method_10103(x, y, z);
        if (ClientWindManager.getWindDisturbances().stream().noneMatch(windDisturbance -> windDisturbance.affectedArea.method_1008((double)x, (double)y, (double)z))) {
            return;
        }
        class_2680 blockState = level.method_8320((class_2338)blockPos);
        if (blockState.method_26234((class_1922)level, (class_2338)blockPos)) {
            return;
        }
        class_243 wind = ClientWindManager.getWindMovement((class_1937)level, (class_243)class_243.method_24953((class_2382)blockPos), (double)1.0, (double)1000.0, (double)1000.0).method_1021(0.001);
        double windLength = wind.method_1033();
        if (random.method_43058() >= (wind.method_1033() - 0.001) * WWAmbienceAndMiscConfig.getWindDisturbanceParticleFrequency()) {
            return;
        }
        level.method_8406((class_2394)new WindParticleOptions((int)(10.0 + windLength * 30.0), wind.field_1352 * 0.01, wind.field_1351 * 0.003, wind.field_1350 * 0.01), (double)x, (double)y, (double)z, 0.0, 0.0, 0.0);
    }

    public static boolean shouldUseWind() {
        return WWAmbienceAndMiscConfig.CLOUD_MOVEMENT && ClientWindManager.shouldUseWind();
    }

    public void baseTick() {
    }

    public void receiveSyncPacket(@NotNull class_2540 byteBuf, @NotNull class_310 minecraft) {
        double cloudX = byteBuf.readDouble();
        double cloudZ = byteBuf.readDouble();
        minecraft.execute(() -> {
            if (minecraft.field_1687 != null) {
                WWClientWindManager.cloudX = cloudX;
                WWClientWindManager.cloudZ = cloudZ;
            }
        });
    }
}

