/*
 * Decompiled with CFR 0.152.
 */
package top.syshub.k_Explosion;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Hanging;
import org.bukkit.entity.Item;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.ExplosionPrimeEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public final class K_Explosion
extends JavaPlugin
implements Listener {
    private final Map<UUID, List<UUID>> affectedBlocklikeEntities = new HashMap<UUID, List<UUID>>();

    public void onEnable() {
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
    }

    private boolean isBlocklike(Entity e) {
        return e instanceof Item || e instanceof ArmorStand || e instanceof Hanging;
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onExplosionPrime(ExplosionPrimeEvent event) {
        Entity source = event.getEntity();
        float radius = 2.0f * event.getRadius();
        if (source.isInWater()) {
            List<UUID> entities = source.getNearbyEntities((double)radius, (double)radius, (double)radius).stream().filter(this::isBlocklike).map(Entity::getUniqueId).toList();
            this.affectedBlocklikeEntities.put(source.getUniqueId(), entities);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.HIGHEST)
    public void onEntityDamage(EntityDamageEvent e) {
        EntityDamageEvent.DamageCause c = e.getCause();
        UUID uuid = Objects.requireNonNull(e.getDamageSource().getDirectEntity()).getUniqueId();
        if ((c == EntityDamageEvent.DamageCause.ENTITY_EXPLOSION || c == EntityDamageEvent.DamageCause.BLOCK_EXPLOSION) && this.affectedBlocklikeEntities.containsKey(uuid) && this.affectedBlocklikeEntities.get(uuid).contains(e.getEntity().getUniqueId())) {
            e.setCancelled(true);
            ArrayList entities = new ArrayList(this.affectedBlocklikeEntities.get(uuid).stream().toList());
            entities.remove(e.getEntity().getUniqueId());
            if (entities.isEmpty()) {
                this.affectedBlocklikeEntities.remove(uuid);
            } else {
                this.affectedBlocklikeEntities.put(uuid, entities);
            }
        }
    }
}

