package ru.berdinskiybear.armorhud.config;

import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_1306;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig.Anchor;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig.OffhandSlotBehavior;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig.Style;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig.WidgetShown;

import static net.minecraft.class_2561.method_43469;

public interface ArmorHudClothConfig {
    static class_437 createScreen(class_437 parent) {
        ArmorHudConfig config = ArmorHudConfig.CONFIG;
        ConfigBuilder builder = ConfigBuilder.create()
                                             .setTitle(method_43471("armorhud.config"))
                                             .setParentScreen(parent)
                                             .setSavingRunnable(config::save);
        ConfigEntryBuilder entries = builder.entryBuilder();
        builder.getOrCreateCategory(method_43471("armorhud.name"))
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.enabled"), config.enabled)
                          .setSaveConsumer(config::setEnabled).build())
               .addEntry(
                   entries.startEnumSelector(method_43471("armorhud.option.anchor"), Anchor.class,
                                             config.anchor)
                          .setEnumNameProvider(e -> class_2561.method_43471(((Anchor)e).translationKey))
                          .setSaveConsumer(config::setAnchor).build())
               .addEntry(
                   entries.startEnumSelector(method_43471("armorhud.option.side"), class_1306.class, config.side)
                          .setEnumNameProvider(e -> class_2561.method_43471(((class_1306)e).method_7359()))
                          .setSaveConsumer(config::setSide).build())
               .addEntry(
                   entries.startIntField(method_43471("armorhud.option.offsetX"), config.offsetX)
                          .setSaveConsumer(config::setOffsetX).build())
               .addEntry(
                   entries.startIntField(method_43471("armorhud.option.offsetY"), config.offsetY)
                          .setSaveConsumer(config::setOffsetY).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.vertical"), config.vertical)
                          .setSaveConsumer(config::setVertical).build())
               .addEntry(
                   entries.startEnumSelector(method_43471("armorhud.option.style"), Style.class,
                                             config.style)
                          .setEnumNameProvider(e -> class_2561.method_43471(((Style)e).translationKey))
                          .setSaveConsumer(config::setStyle).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.durabilityNumbers"),
                                              config.durabilityNumbers)
                          .setSaveConsumer(config::setDurabilityNumbers).build())
               .addEntry(
                   entries.startEnumSelector(method_43471("armorhud.option.widgetShown"),
                                             WidgetShown.class,
                                             config.widgetShown)
                          .setEnumNameProvider(e -> class_2561.method_43471(((WidgetShown)e).translationKey))
                          .setSaveConsumer(config::setWidgetShown).build())
               .addEntry(
                   entries.startEnumSelector(method_43471("armorhud.option.offhandSlotBehavior"),
                                             OffhandSlotBehavior.class, config.offhandSlotBehavior)
                          .setEnumNameProvider(
                              e -> class_2561.method_43471(((OffhandSlotBehavior)e).translationKey))
                          .setSaveConsumer(config::setOffhandSlotBehavior).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.pushBossbars"), config.pushBossbars)
                          .setSaveConsumer(config::setPushBossbars).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.pushIcons"), config.pushStatusEffectIcons)
                          .setSaveConsumer(config::setPushStatusEffectIcons).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.pushSubtitles"), config.pushSubtitles)
                          .setSaveConsumer(config::setPushSubtitles).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.reversed"), config.reversed)
                          .setSaveConsumer(config::setReversed).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.showIcons"), config.iconsShown)
                          .setSaveConsumer(config::setIconsShown).build())
               .addEntry(
                   entries.startBooleanToggle(method_43471("armorhud.option.showWarning"), config.warningShown)
                          .setSaveConsumer(config::setWarningShown).build())
               .addEntry(
                   entries.startIntField(method_43471("armorhud.option.minDuraValue"), config.minDurabilityValue)
                          .setSaveConsumer(config::setMinDurabilityValue).build())
               .addEntry(
                   entries.startIntSlider(method_43471("armorhud.option.minDuraPercent"),
                                          (int)(config.minDurabilityPercentage * 100.0), 0, 100)
                          .setSaveConsumer(config::setMinDurabilityPercentage).build())
               .addEntry(
                   entries.startIntField(method_43471("armorhud.option.iconBobIntensity"), config.warningBobIntensity)
                          .setSaveConsumer(config::setWarningBobIntensity).build());
        return builder.build();
    }
}
