package ru.berdinskiybear.armorhud.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.berdinskiybear.armorhud.ArmorHudMod;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;

import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_9779;

@Mixin(class_329.class)
public abstract class InGameHudMixin {
    @Shadow
    @Final
    private class_310 client;
    @Shadow
    private int ticks;

    @Shadow
    protected abstract class_1657 getCameraPlayer();

    @Inject(method = "renderHotbarVanilla", at = @At("TAIL"))
    public void renderArmorHud(class_332 context, class_9779 tickCounter, CallbackInfo ci) {
        ArmorHudConfig config = ArmorHudConfig.CONFIG;
        if (config.isDisabled()) return;

        class_1657 player = getCameraPlayer();
        if (player == null) return;

        ArmorHudMod.render((InGameHudAccessor)this, context, tickCounter, player, client, ticks);
    }

    @Inject(method = "renderStatusEffectOverlay", at = @At(value = "INVOKE", target = "Ljava/util/List;iterator()Ljava/util/Iterator;"))
    public void calculateStatusEffectIconsOffset(class_332 context, class_9779 tickCounter, CallbackInfo ci, @Share("shift") LocalIntRef shiftRef) {
        ArmorHudConfig config = ArmorHudConfig.CONFIG;
        if (config.isDisabled() || !config.isPushStatusEffectIcons() || config.getAnchor() != ArmorHudConfig.Anchor.TOP
            || config.getSide() != class_1306.field_6183) return;

        class_1657 player = this.getCameraPlayer();
        if (player == null) return;

        List<class_1799> armor = ArmorHudMod.nonEmptyArmor(player);
        if (armor.isEmpty() || config.getWidgetShown() != ArmorHudConfig.WidgetShown.ALWAYS) return;

        int newShift = ArmorHudMod.SIZE + config.getOffsetY();
        if (config.isWarningShown() && armor.stream().anyMatch(ArmorHudMod::shouldShowWarning)) {
            newShift += 10;
            if (config.getWarningBobIntensity() != 0)
                newShift += ArmorHudMod.WARNING_OFFSET;
        }

        shiftRef.set(Math.max(newShift, 0));
    }

    @ModifyExpressionValue(method = "renderStatusEffectOverlay", at = @At(value = "CONSTANT", args = "intValue=1"))
    public int statusEffectIconsOffset(int y, @Share("shift") LocalIntRef shiftRef) {
        return y + shiftRef.get();
    }
}