package ru.berdinskiybear.armorhud.mixin;

import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalIntRef;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.berdinskiybear.armorhud.ArmorHudMod;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;

import java.util.List;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_332;
import net.minecraft.class_359;

@Mixin(class_359.class)
public class SubtitlesHudMixin {
    // doing the calculation here allows to calculate only once, since there is one translate call for each subtitle (i take it back i understand this now)
    @Inject(method = "render", at = @At(value = "INVOKE_ASSIGN", target = "Lnet/minecraft/client/font/TextRenderer;getWidth(Ljava/lang/String;)I", ordinal = 3))
    public void calculateOffset(class_332 context, CallbackInfo ci, @Share("offset") LocalIntRef offsetRef) {
        ArmorHudConfig config = ArmorHudConfig.CONFIG;
        if (config.isDisabled() || !config.isPushSubtitles() || config.getAnchor() != ArmorHudConfig.Anchor.BOTTOM ||
            config.getSide() != class_1306.field_6183) return;

        class_1657 player = ArmorHudMod.getCameraPlayer();
        if (player == null) return;

        List<class_1799> armorItems = ArmorHudMod.nonEmptyArmor(player);
        int offset = 0;

        if (!armorItems.isEmpty() || config.getWidgetShown() == ArmorHudConfig.WidgetShown.ALWAYS) {
            offset = config.getOffsetY();
            if (config.isWarningShown() && armorItems.stream().anyMatch(ArmorHudMod::shouldShowWarning))
                offset += config.getWarningBobIntensity() != 0 ? 10 + ArmorHudMod.WARNING_OFFSET : 10;
        }

        offsetRef.set(Math.max(offset, 0));
    }

    @ModifyArg(method = "render", at = @At(value = "INVOKE", target = "Lnet/minecraft/client/util/math/MatrixStack;translate(FFF)V"), index = 1)
    public float offset(float y, @Share("offset") LocalIntRef offsetRef) {
        return y - offsetRef.get();
    }
}
