/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud;

import dev.architectury.injectables.annotations.ExpectPlatform;
import java.nio.file.Path;
import java.util.List;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_1723;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4061;
import net.minecraft.class_4587;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.berdinskiybear.armorhud.config.ArmorHudConfig;
import ru.berdinskiybear.armorhud.fabric.ArmorHudModImpl;
import ru.berdinskiybear.armorhud.mixin.InGameHudAccessor;
import ru.berdinskiybear.armorhud.mixin.PlayerScreenHandlerAccessor;

public final class ArmorHudMod {
    public static final String MOD_ID = "armor_hud";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"armor_hud");
    public static final class_304 TOGGLE_HUD = new class_304("armorhud.keybind.toggle", -1, "armorhud.name");
    public static final class_2960 WARNING_TEXTURE = class_2960.method_60655((String)"armor_hud", (String)"warn.png");
    public static final int STEP = 20;
    public static final int SIZE = 22;
    public static final int EDGE_SIZE = 3;
    public static final int HOTBAR_OFFSET = 98;
    public static final int OFFHAND_OFFSET = 29;
    public static final int ATTACK_INDICATOR_OFFSET = 23;
    public static final int WARNING_OFFSET = 4;

    @Nullable
    public static class_1657 getCameraPlayer() {
        class_1657 player;
        class_1297 class_12972 = class_310.method_1551().method_1560();
        return class_12972 instanceof class_1657 ? (player = (class_1657)class_12972) : null;
    }

    public static List<class_1799> nonEmptyArmor(class_1657 player) {
        return player.method_31548().field_7548.stream().filter(s -> !s.method_7960()).toList();
    }

    public static boolean shouldShowWarning(class_1799 stack) {
        if (stack.method_7960() || !stack.method_7963()) {
            return false;
        }
        int damage = stack.method_7919();
        int maxDamage = stack.method_7936();
        return maxDamage - damage <= ArmorHudConfig.CONFIG.getMinDurabilityValue() || 1.0 - (double)damage / (double)maxDamage <= ArmorHudConfig.CONFIG.getMinDurabilityPercentage();
    }

    public static void render(InGameHudAccessor hud, class_332 context, class_9779 tickCounter, class_1657 player, class_310 client, int ticks) {
        int rotatedY;
        int rotatedX;
        int widgetY;
        int sideOffsetMultiplier;
        int sideMultiplier;
        ArmorHudConfig config = ArmorHudConfig.CONFIG;
        class_2371 armor = player.method_31548().field_7548;
        int armorSize = armor.size();
        int nonEmptyCount = (int)armor.stream().filter(s -> !s.method_7960()).count();
        if (nonEmptyCount == 0 && config.getWidgetShown() != ArmorHudConfig.WidgetShown.ALWAYS) {
            return;
        }
        class_4587 matrices = context.method_51448();
        ArmorHudConfig.Anchor anchor = config.getAnchor();
        boolean anchorTop = anchor.isTop();
        boolean right = config.getSide() == class_1306.field_6183;
        boolean vertical = config.isVertical();
        boolean showEmpty = config.getWidgetShown() != ArmorHudConfig.WidgetShown.NOT_EMPTY;
        int slots = showEmpty ? armorSize : nonEmptyCount;
        int widgetSize = 22 + (slots - 1) * 20;
        if (anchor == ArmorHudConfig.Anchor.HOTBAR != right) {
            sideMultiplier = -1;
            sideOffsetMultiplier = -1;
        } else {
            sideMultiplier = 1;
            sideOffsetMultiplier = 0;
        }
        int widgetX = config.getOffsetX() * sideMultiplier;
        if (anchor == ArmorHudConfig.Anchor.TOP_CENTER) {
            widgetX += (context.method_51421() - widgetSize) / 2;
            if (vertical) {
                vertical = false;
                config.setVertical(false);
                LOGGER.warn("Disabling vertical mode because the top center anchor is incompatible!");
            }
        } else if (anchor == ArmorHudConfig.Anchor.HOTBAR) {
            int addedHotbarOffset = switch (config.getOffhandSlotBehavior()) {
                default -> throw new MatchException(null, null);
                case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_IGNORE -> 0;
                case ArmorHudConfig.OffhandSlotBehavior.ALWAYS_LEAVE_SPACE -> 29;
                case ArmorHudConfig.OffhandSlotBehavior.ADHERE -> {
                    if (player.method_6068().method_5928() == config.getSide()) {
                        if (!player.method_6079().method_7960()) {
                            yield 29;
                        }
                        if (client.field_1690.method_42565().method_41753() == class_4061.field_18153) {
                            yield 23;
                        }
                    }
                    yield 0;
                }
            };
            widgetX += context.method_51421() / 2 + (98 + addedHotbarOffset) * sideMultiplier + widgetSize * sideOffsetMultiplier;
            if (vertical) {
                vertical = false;
                config.setVertical(false);
                LOGGER.warn("Disabling vertical mode because the hotbar anchor is incompatible!");
            }
        } else if (vertical) {
            widgetX += (22 - context.method_51421()) * sideOffsetMultiplier;
        } else if (anchor == ArmorHudConfig.Anchor.TOP || anchor == ArmorHudConfig.Anchor.BOTTOM) {
            widgetX += (widgetSize - context.method_51421()) * sideOffsetMultiplier;
        }
        int n = anchorTop ? config.getOffsetY() : (widgetY = context.method_51443() - config.getOffsetY() - (vertical ? widgetSize : 22));
        if (vertical) {
            matrices.method_22903();
            matrices.method_22907(new Quaternionf(0.0f, 0.0f, 0.70710677f, 0.70710677f));
            rotatedX = widgetY;
            rotatedY = -widgetX - 22;
        } else {
            rotatedX = widgetX;
            rotatedY = widgetY;
        }
        switch (config.getStyle()) {
            case HOTBAR: {
                context.method_52708(InGameHudAccessor.getHOTBAR_TEXTURE(), 182, 22, 0, 0, rotatedX, rotatedY, widgetSize - 3, 22);
                context.method_52708(InGameHudAccessor.getHOTBAR_TEXTURE(), 182, 22, 179, 0, rotatedX + widgetSize - 3, rotatedY, 3, 22);
                break;
            }
            case ROUNDED_CORNERS: {
                if (slots > 1) {
                    context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 0, 1, rotatedX, rotatedY, 3, 22);
                    context.method_52708(InGameHudAccessor.getHOTBAR_TEXTURE(), 182, 22, 3, 0, rotatedX + 3, rotatedY, widgetSize - 6, 22);
                    context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 19, 1, rotatedX + widgetSize - 3, rotatedY, 3, 22);
                    break;
                }
                context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 0, 1, rotatedX, rotatedY, 22, 22);
                break;
            }
            case ROUNDED: {
                if (slots > 1) {
                    context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 0, 1, rotatedX, rotatedY, 21, 22);
                    for (int i = slots - 2; i >= 1; --i) {
                        context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 1, 1, rotatedX + 1 + i * 20, rotatedY, 20, 22);
                    }
                    context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 1, 1, rotatedX + widgetSize - 20 - 1, rotatedY, 21, 22);
                    break;
                }
                context.method_52708(InGameHudAccessor.getHOTBAR_OFFHAND_LEFT_TEXTURE(), 29, 24, 0, 1, rotatedX, rotatedY, 22, 22);
            }
        }
        if (vertical) {
            matrices.method_22909();
        }
        int warningOffset = 0;
        if (config.isWarningShown()) {
            int intensity = config.getWarningBobIntensity();
            int n2 = vertical ? (right ? -12 : 20) : (warningOffset = anchorTop ? 20 : -12);
            if (intensity != 0) {
                int bob = Math.round(class_3532.method_15374((float)((float)ticks / 2.0f)) / 2.0f * (float)intensity);
                warningOffset += vertical ? bob * sideMultiplier : (anchorTop ? -bob : bob);
            }
        }
        class_1059 atlas = showEmpty && config.isIconsShown() ? client.method_1554().method_24153(class_1723.field_21668) : null;
        boolean reversed = config.isReversed();
        boolean showNumbers = config.isDurabilityNumbers();
        int x = widgetX + 3;
        int y = widgetY + 3;
        for (int i = 0; i < armorSize; ++i) {
            int index = reversed ? i : armorSize - i - 1;
            class_1799 stack = (class_1799)armor.get(index);
            if (!stack.method_7960()) {
                hud.callRenderHotbarItem(context, x, y, tickCounter, player, stack, nonEmptyCount);
                if (showNumbers) {
                    int textY;
                    int textX;
                    class_327 textRenderer = client.field_1772;
                    int durability = stack.method_7936() - stack.method_7919();
                    String s2 = String.valueOf(durability);
                    int width = textRenderer.method_1727(s2);
                    float factor = 16.0f / (float)width;
                    if (vertical) {
                        textX = widgetX + (right ? -width - 2 : 24);
                        textY = y + 4;
                    } else {
                        if (factor > 1.0f) {
                            factor = 1.0f;
                            textX = x + (16 - width) / 2;
                        } else {
                            textX = (int)((float)x / factor) + 1;
                        }
                        textY = (int)(anchorTop ? (float)(widgetY + 22 + 2) / factor : (float)(widgetY - 2) / factor - 7.0f);
                        matrices.method_22903();
                        matrices.method_22905(factor, factor, 0.0f);
                    }
                    context.method_51433(textRenderer, s2, textX, textY, stack.method_31580(), true);
                    if (!vertical) {
                        matrices.method_22909();
                    }
                }
                if (config.isWarningShown() && ArmorHudMod.shouldShowWarning(stack)) {
                    context.method_25291(WARNING_TEXTURE, x + (vertical ? warningOffset : 4), y + (vertical ? 4 : warningOffset), -1, 0.0f, 0.0f, 8, 8, 8, 8);
                }
            } else if (atlas != null) {
                class_2960 spriteId = PlayerScreenHandlerAccessor.getEMPTY_ARMOR_SLOT_TEXTURES().get(PlayerScreenHandlerAccessor.getEQUIPMENT_SLOT_ORDER()[index]);
                class_1058 sprite = atlas.method_4608(spriteId);
                context.method_25298(x, y, 0, 16, 16, sprite);
            }
            if (stack.method_7960() && !showEmpty) continue;
            if (vertical) {
                y += 20;
                continue;
            }
            x += 20;
        }
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Path configDir() {
        return ArmorHudModImpl.configDir();
    }
}

