/*
 * Decompiled with CFR 0.152.
 */
package ru.berdinskiybear.armorhud.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import net.minecraft.class_1306;
import ru.berdinskiybear.armorhud.ArmorHudMod;

public class ArmorHudConfig
implements Serializable {
    public static final ArmorHudConfig CONFIG = new ArmorHudConfig();
    public static final Path FILE = ArmorHudMod.configDir().resolve("armor_hud.json");
    public static final Gson GSON = new GsonBuilder().setLenient().setPrettyPrinting().registerTypeAdapter(ArmorHudConfig.class, type -> CONFIG).create();
    public boolean enabled = true;
    public Anchor anchor = Anchor.HOTBAR;
    public class_1306 side = class_1306.field_6182;
    public int offsetX = 0;
    public int offsetY = 0;
    public boolean vertical = false;
    public Style style = Style.HOTBAR;
    public boolean durabilityNumbers = false;
    public WidgetShown widgetShown = WidgetShown.NOT_EMPTY;
    public OffhandSlotBehavior offhandSlotBehavior = OffhandSlotBehavior.ADHERE;
    public boolean pushBossbars = true;
    public boolean pushStatusEffectIcons = true;
    public boolean pushSubtitles = true;
    public boolean reversed = false;
    public boolean iconsShown = true;
    public boolean warningShown = true;
    public int minDurabilityValue = 5;
    public double minDurabilityPercentage = 0.05;
    public int warningBobIntensity = 3;

    private ArmorHudConfig() {
    }

    public boolean isDisabled() {
        return !this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public class_1306 getSide() {
        return this.side;
    }

    public void setSide(class_1306 side) {
        this.side = side;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public boolean isVertical() {
        return this.vertical;
    }

    public void setVertical(boolean vertical) {
        this.vertical = vertical;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public boolean isDurabilityNumbers() {
        return this.durabilityNumbers;
    }

    public void setDurabilityNumbers(boolean durabilityNumbers) {
        this.durabilityNumbers = durabilityNumbers;
    }

    public WidgetShown getWidgetShown() {
        return this.widgetShown;
    }

    public void setWidgetShown(WidgetShown widgetShown) {
        this.widgetShown = widgetShown;
    }

    public OffhandSlotBehavior getOffhandSlotBehavior() {
        return this.offhandSlotBehavior;
    }

    public void setOffhandSlotBehavior(OffhandSlotBehavior offhandSlotBehavior) {
        this.offhandSlotBehavior = offhandSlotBehavior;
    }

    public boolean isPushBossbars() {
        return this.pushBossbars;
    }

    public void setPushBossbars(boolean pushBossbars) {
        this.pushBossbars = pushBossbars;
    }

    public boolean isPushStatusEffectIcons() {
        return this.pushStatusEffectIcons;
    }

    public void setPushStatusEffectIcons(boolean pushStatusEffectIcons) {
        this.pushStatusEffectIcons = pushStatusEffectIcons;
    }

    public boolean isPushSubtitles() {
        return this.pushSubtitles;
    }

    public void setPushSubtitles(boolean pushSubtitles) {
        this.pushSubtitles = pushSubtitles;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public void setReversed(boolean reversed) {
        this.reversed = reversed;
    }

    public boolean isIconsShown() {
        return this.iconsShown;
    }

    public void setIconsShown(boolean iconsShown) {
        this.iconsShown = iconsShown;
    }

    public boolean isWarningShown() {
        return this.warningShown;
    }

    public void setWarningShown(boolean warningShown) {
        this.warningShown = warningShown;
    }

    public int getMinDurabilityValue() {
        return this.minDurabilityValue;
    }

    public void setMinDurabilityValue(int minDurabilityValue) {
        this.minDurabilityValue = minDurabilityValue;
    }

    public double getMinDurabilityPercentage() {
        return this.minDurabilityPercentage;
    }

    public void setMinDurabilityPercentage(double minDurabilityPercentage) {
        this.minDurabilityPercentage = minDurabilityPercentage;
    }

    public void setMinDurabilityPercentage(int minDurabilityPercentage) {
        this.minDurabilityPercentage = (double)minDurabilityPercentage / 100.0;
    }

    public int getWarningBobIntensity() {
        return this.warningBobIntensity;
    }

    public void setWarningBobIntensity(int warningBobIntensity) {
        this.warningBobIntensity = warningBobIntensity;
    }

    public void toggleEnabled() {
        this.setEnabled(this.isDisabled());
    }

    public void load() {
        if (!Files.exists(FILE, new LinkOption[0])) {
            this.save();
        } else {
            try (BufferedReader reader = Files.newBufferedReader(FILE);){
                GSON.fromJson((Reader)reader, ArmorHudConfig.class);
            }
            catch (JsonSyntaxException | IOException e) {
                ArmorHudMod.LOGGER.error("Error reading config! Reloading from defaults!", e);
                this.save();
            }
        }
    }

    public void save() {
        try (BufferedWriter writer = Files.newBufferedWriter(FILE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)CONFIG, (Appendable)writer);
        }
        catch (IOException e) {
            ArmorHudMod.LOGGER.error("Unable to write config to file!", (Throwable)e);
        }
    }

    static {
        CONFIG.load();
    }

    public static enum Anchor {
        TOP_CENTER("armorhud.option.topCenter"),
        TOP("armorhud.option.top"),
        BOTTOM("armorhud.option.bottom"),
        HOTBAR("armorhud.option.hotbar");

        public final String translationKey;

        private Anchor(String translationKey) {
            this.translationKey = translationKey;
        }

        public boolean isTop() {
            return this == TOP || this == TOP_CENTER;
        }
    }

    public static enum Style {
        HOTBAR("armorhud.option.hotbar"),
        ROUNDED_CORNERS("armorhud.option.roundedCorners"),
        ROUNDED("armorhud.option.rounded"),
        NONE("armorhud.option.none");

        public final String translationKey;

        private Style(String translationKey) {
            this.translationKey = translationKey;
        }
    }

    public static enum WidgetShown {
        ALWAYS("armorhud.option.always"),
        IF_ANY_PRESENT("armorhud.option.ifAnyPresent"),
        NOT_EMPTY("armorhud.option.notEmpty");

        public final String translationKey;

        private WidgetShown(String translationKey) {
            this.translationKey = translationKey;
        }
    }

    public static enum OffhandSlotBehavior {
        ALWAYS_IGNORE("armorhud.option.alwaysIgnore"),
        ADHERE("armorhud.option.adhere"),
        ALWAYS_LEAVE_SPACE("armorhud.option.alwaysLeaveSpace");

        public final String translationKey;

        private OffhandSlotBehavior(String translationKey) {
            this.translationKey = translationKey;
        }
    }
}

