/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.event;

import com.mojang.brigadier.ParseResults;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import org.apache.commons.lang3.time.DurationFormatUtils;
import readyplayerfun.ReadyPlayerFun;
import readyplayerfun.config.ConfigHandler;
import readyplayerfun.util.WorldState;

public class ServerEventHander {
    private static final Map<Long, WorldState> WORLD_STATE_MAP = new HashMap<Long, WorldState>();

    public static void serverStopping(MinecraftServer server) {
    }

    public static void onPlayerJoin(ServerPlayer sp) {
        PlayerList playerList = Objects.requireNonNull(sp.level().getServer()).getPlayerList();
        ServerLevel level = sp.level().getServer().overworld();
        WorldState worldState = ServerEventHander.getWorldState(level);
        if (playerList.getPlayerCount() >= 1 && worldState.isPaused()) {
            long duration = System.currentTimeMillis() - worldState.getStartPauseTime();
            String durationString = DurationFormatUtils.formatDuration((long)duration, (String)"H:mm:ss", (boolean)true);
            if (duration == 0L) {
                return;
            }
            if (ConfigHandler.Common.enableWelcomeMessage()) {
                String msg = String.format(ConfigHandler.Common.welcomeMessage(), durationString);
                MutableComponent message = Component.translatable((String)msg);
                sp.displayClientMessage((Component)message, true);
            }
            ServerEventHander.unpauseServer(String.format("onPlayerLogin, %s", durationString), level);
        }
    }

    public static void onPlayerLogout(ServerPlayer sp) {
    }

    public static void levelPostTick(ServerLevel level) {
    }

    public static void levelLoad(ServerLevel level) {
    }

    public static WorldState getWorldState(ServerLevel level) {
        return WORLD_STATE_MAP.computeIfAbsent(level.getSeed(), k -> new WorldState());
    }

    public static void pauseServer(String ctx, ServerLevel level) {
        WorldState worldState = ServerEventHander.getWorldState(level);
        worldState.setStartPauseTime(System.currentTimeMillis());
        worldState.setGameTime(level.getGameTime());
        worldState.setDayTime(level.getDayTime());
        ReadyPlayerFun.LOGGER.info(String.format("%s rule set, pausing server at %d, %d", ctx, worldState.getGameTime(), worldState.getDayTime()));
        worldState.setPaused(true);
    }

    private static void unpauseServer(String ctx, ServerLevel level) {
        WorldState worldState = ServerEventHander.getWorldState(level);
        ReadyPlayerFun.LOGGER.info(String.format("Unpausing server: %s at %d, %d", ctx, level.getGameTime(), level.getDayTime()));
        worldState.setPaused(false);
    }

    private static void cyclePause(ServerLevel level) {
    }

    public static void onCommand(ParseResults<CommandSourceStack> results) {
    }
}

