/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.config;

import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Common COMMON;

    public static void init() {
    }

    static {
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue enableWelcomeMessage;
        private final WhiteNoiseConfigSpec.IntValue pauseWhileEmptySeconds;

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("Server");
            this.enableWelcomeMessage = builder.comment("Show status message on first player login after server unpaused.").define("enableWelcomeMessage", true);
            this.pauseWhileEmptySeconds = builder.comment("Number of seconds before server pauses. Backport of pause-when-empty-seconds from 1.21.2+").defineInRange("pauseWhileEmptySeconds", 60, 1, 360);
            builder.pop();
        }

        public static boolean enableWelcomeMessage() {
            return (Boolean)ConfigHandler.COMMON.enableWelcomeMessage.get();
        }

        public static int pauseWhileEmptySeconds() {
            return (Integer)ConfigHandler.COMMON.pauseWhileEmptySeconds.get();
        }
    }
}

