/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.mixin;

import java.util.function.BooleanSupplier;
import net.minecraft.Util;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.profiling.ProfilerFiller;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import readyplayerfun.config.ConfigHandler;
import readyplayerfun.event.ServerEventHander;
import readyplayerfun.mixin.MinecraftServerAccessor;
import readyplayerfun.util.WorldState;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private static Logger LOGGER;
    private int emptyTicks;

    @Inject(method={"tickServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpf$onTickServer(BooleanSupplier pHasTimeLeft, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (!server.isDedicatedServer()) {
            return;
        }
        WorldState worldState = this.readyplayerfun$getWorldState(server);
        ProfilerFiller profilerFiller = server.getProfiler();
        if (worldState.isPaused() && worldState.isNeedsSave()) {
            profilerFiller.push("saveOnPause");
            LOGGER.info("Server empty for {} seconds, pausing", (Object)ConfigHandler.Common.pauseWhileEmptySeconds());
            server.saveEverything(false, false, false);
            worldState.setNeedsSave(false);
            profilerFiller.pop();
        }
        if (worldState.isPaused()) {
            long curNanos = Util.getNanos();
            profilerFiller.push("connection");
            server.getConnection().tick();
            profilerFiller.popPush("server gui");
            ((DedicatedServer)server).handleConsoleInputs();
            if (curNanos - ((MinecraftServerAccessor)server).getLastServerStatus() >= 5000000000L) {
                ((MinecraftServerAccessor)server).setLastServerStatus(curNanos);
                ((MinecraftServerAccessor)server).setStatus(((MinecraftServerAccessor)server).invokeBuildServerStatus());
            }
            ci.cancel();
        }
    }

    @Unique
    private WorldState readyplayerfun$getWorldState(MinecraftServer server) {
        ServerLevel level = server.overworld();
        int playerCount = server.getPlayerCount();
        WorldState worldState = ServerEventHander.getWorldState(level);
        int j = ConfigHandler.Common.pauseWhileEmptySeconds() * 20;
        if (!worldState.isLoaded()) {
            return worldState;
        }
        this.emptyTicks = playerCount == 0 && !server.tickRateManager().isSprinting() ? ++this.emptyTicks : 0;
        if (this.emptyTicks >= j && !worldState.isPaused()) {
            ServerEventHander.pauseServer("tickServer", level);
            worldState = ServerEventHander.getWorldState(level);
        }
        return worldState;
    }
}

