/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.config;

import java.util.function.Predicate;
import org.apache.commons.lang3.tuple.Pair;
import technology.roughness.whitenoise.config.WhiteNoiseConfigSpec;

public class ConfigHandler {
    public static final WhiteNoiseConfigSpec COMMON_SPEC;
    private static final Common COMMON;

    public static void init() {
    }

    static {
        Pair specPairCommon = new WhiteNoiseConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (WhiteNoiseConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
    }

    public static class Common {
        private final WhiteNoiseConfigSpec.BooleanValue enableWelcomeMessage;
        private final WhiteNoiseConfigSpec.ConfigValue<String> welcomeMessage;
        private final WhiteNoiseConfigSpec.IntValue pauseWhileEmptySeconds;
        private static final Predicate<Object> messageValidator = s -> s instanceof String && ((String)s).matches(".*%s.*");

        public Common(WhiteNoiseConfigSpec.Builder builder) {
            builder.push("Server");
            this.enableWelcomeMessage = builder.comment("Show status message on first player login after server unpaused.").define("enableWelcomeMessage", true);
            this.welcomeMessage = builder.comment("Welcome message users see when joining. '%' is variable for the time elapsed.").define("welcomeMessage", (Object)"Welcome back! Server resumed after %s.", messageValidator);
            this.pauseWhileEmptySeconds = builder.comment("Number of seconds before server pauses. Will automatically set pause-when-empty-seconds.").defineInRange("pauseWhileEmptySeconds", 60, 1, 360);
            builder.pop();
        }

        public static boolean enableWelcomeMessage() {
            return (Boolean)ConfigHandler.COMMON.enableWelcomeMessage.get();
        }

        public static String welcomeMessage() {
            return (String)ConfigHandler.COMMON.welcomeMessage.get();
        }

        public static int pauseWhileEmptySeconds() {
            return (Integer)ConfigHandler.COMMON.pauseWhileEmptySeconds.get();
        }
    }
}

