/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.event;

import com.mojang.brigadier.ParseResults;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.time.DurationFormatUtils;
import readyplayerfun.ReadyPlayerFun;
import readyplayerfun.config.ConfigHandler;
import readyplayerfun.util.WorldState;

public class ServerEventHander {
    private static final Map<Long, WorldState> WORLD_STATE_MAP = new HashMap<Long, WorldState>();

    public static void serverStopping(MinecraftServer server) {
    }

    public static void onPlayerJoin(class_3222 sp) {
        class_3324 playerList = Objects.requireNonNull(sp.method_5682()).method_3760();
        class_3218 level = sp.method_5682().method_30002();
        WorldState worldState = ServerEventHander.getWorldState(level);
        if (playerList.method_14574() >= 1 && worldState.isPaused()) {
            long duration = System.currentTimeMillis() - worldState.getStartPauseTime();
            String durationString = DurationFormatUtils.formatDuration((long)duration, (String)"H:mm:ss", (boolean)true);
            if (ConfigHandler.Common.enableWelcomeMessage()) {
                String msg = String.format("Welcome back! Server resumed after %s.", durationString);
                class_5250 message = class_2561.method_43471((String)msg);
                sp.method_7353((class_2561)message, true);
            }
            ServerEventHander.unpauseServer(String.format("onPlayerLogin, %s", durationString), level);
        }
    }

    public static void onPlayerLogout(class_3222 sp) {
    }

    public static void levelPostTick(class_3218 level) {
        WorldState worldState;
        long now = System.currentTimeMillis();
        if (now - (worldState = ServerEventHander.getWorldState(level)).getCheckTime() > 1000L) {
            class_3324 playerList = level.method_8503().method_3760();
            worldState.setCheckTime(now);
            if (worldState.isPaused() && playerList.method_14574() >= 1) {
                ServerEventHander.unpauseServer("onWorldTick", level);
            }
        }
    }

    public static void levelLoad(class_3218 level) {
        WorldState worldState = ServerEventHander.getWorldState(level);
        worldState.setLoaded(true);
    }

    public static WorldState getWorldState(class_3218 level) {
        return WORLD_STATE_MAP.computeIfAbsent(level.method_8412(), k -> new WorldState());
    }

    public static void pauseServer(String ctx, class_3218 level) {
        WorldState worldState = ServerEventHander.getWorldState(level);
        worldState.setStartPauseTime(System.currentTimeMillis());
        worldState.setGameTime(level.method_8510());
        worldState.setDayTime(level.method_8532());
        ReadyPlayerFun.LOGGER.info(String.format("Pausing server %s at %d, %d", ctx, worldState.getGameTime(), worldState.getDayTime()));
        worldState.setPaused(true);
    }

    private static void unpauseServer(String ctx, class_3218 level) {
        WorldState worldState = ServerEventHander.getWorldState(level);
        ReadyPlayerFun.LOGGER.info(String.format("Unpausing server: %s at %d, %d", ctx, worldState.getGameTime(), worldState.getDayTime()));
        worldState.setPaused(false);
        worldState.setNeedsSave(true);
    }

    public static void onCommand(ParseResults<class_2168> results) {
    }
}

