/*
 * Decompiled with CFR 0.152.
 */
package readyplayerfun.mixin;

import java.util.function.BooleanSupplier;
import net.minecraft.class_156;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3695;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import readyplayerfun.config.ConfigHandler;
import readyplayerfun.event.ServerEventHander;
import readyplayerfun.mixin.MinecraftServerAccessor;
import readyplayerfun.util.WorldState;

@Mixin(value={MinecraftServer.class})
public abstract class MinecraftServerMixin {
    @Shadow
    @Final
    private static Logger field_4546;
    private int emptyTicks;

    @Inject(method={"tickServer"}, at={@At(value="HEAD")}, cancellable=true)
    private void rpf$onTickServer(BooleanSupplier pHasTimeLeft, CallbackInfo ci) {
        MinecraftServer server = (MinecraftServer)this;
        if (!server.method_3816()) {
            return;
        }
        WorldState worldState = this.readyplayerfun$getWorldState(server);
        class_3695 profilerFiller = server.method_16044();
        if (worldState.isPaused() && worldState.isNeedsSave()) {
            profilerFiller.method_15396("saveOnPause");
            field_4546.info("Server empty for {} seconds, pausing", (Object)ConfigHandler.Common.pauseWhileEmptySeconds());
            server.method_39218(false, false, false);
            worldState.setNeedsSave(false);
            profilerFiller.method_15407();
        }
        if (worldState.isPaused()) {
            long curNanos = class_156.method_648();
            profilerFiller.method_15396("connection");
            server.method_3787().method_14357();
            profilerFiller.method_15405("server gui");
            ((class_3176)server).method_13941();
            if (curNanos - ((MinecraftServerAccessor)server).getLastServerStatus() >= 5000000000L) {
                ((MinecraftServerAccessor)server).setLastServerStatus(curNanos);
                ((MinecraftServerAccessor)server).setStatus(((MinecraftServerAccessor)server).invokeBuildServerStatus());
            }
            ci.cancel();
        }
    }

    @Unique
    private WorldState readyplayerfun$getWorldState(MinecraftServer server) {
        class_3218 level = server.method_30002();
        int playerCount = server.method_3788();
        WorldState worldState = ServerEventHander.getWorldState(level);
        int j = ConfigHandler.Common.pauseWhileEmptySeconds() * 20;
        if (!worldState.isLoaded()) {
            return worldState;
        }
        this.emptyTicks = playerCount == 0 && !server.method_54833().method_54670() ? ++this.emptyTicks : 0;
        if (this.emptyTicks >= j && !worldState.isPaused()) {
            ServerEventHander.pauseServer("tickServer", level);
            worldState = ServerEventHander.getWorldState(level);
        }
        return worldState;
    }
}

