/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record GhastPredicate(Optional<Boolean> charging) implements EntitySubPredicate
{
    public static final MapCodec<GhastPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("charging").forGetter(GhastPredicate::charging)).apply((Applicative)instance, GhastPredicate::new));

    public MapCodec<GhastPredicate> codec() {
        return (MapCodec)ModRegistry.GHAST_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Ghast)) {
            return false;
        }
        Ghast ghast = (Ghast)entity;
        return !this.charging.isPresent() || ghast.isCharging() == this.charging.get().booleanValue();
    }

    public static GhastPredicate isCharging(boolean charging) {
        return new GhastPredicate(Optional.of(charging));
    }
}

