/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.client.renderer.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.client.model.PiglinHeadModel;
import net.minecraft.client.model.SkullModel;
import net.minecraft.client.model.SkullModelBase;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.ClientAsset;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.WallSkullBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class MobHeadBlockRenderer
implements BlockEntityRenderer<MobHeadBlockEntity> {
    private static final List<Model> DEFAULT_MODELS = List.of(new Model((ModelAndTexture<ModelType>)new ModelAndTexture((Object)ModelType.DEFAULT, new ClientAsset(DefaultPlayerSkin.getDefaultTexture(), DefaultPlayerSkin.getDefaultTexture())), Optional.empty(), Optional.empty()));
    private static final Shape DEFAULT_SHAPE = new Shape(8.0, 8.0, 8.0);
    private static final Map<ModelType, Function<ModelPart, SkullModelBase>> SKULL_MODELS = Collections.unmodifiableMap((Map)Util.make(new IdentityHashMap(), map -> map.put(ModelType.PIGLIN, PiglinHeadModel::new)));
    private static final Map<ModelType, BiFunction<ResourceLocation, Float, RenderType>> RENDER_TYPES = Collections.unmodifiableMap((Map)Util.make(new IdentityHashMap(), map -> {
        MobHeadBlockRenderer.putRenderType(ModelType.ALLAY, RenderType::entityTranslucent, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BAT, RenderType::entityCutout, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BREEZE, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.BREEZE_EYES, RenderType::eyes, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.CREAKING, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.CREAKING_EYES, RenderType::eyes, map::put);
        map.put(ModelType.CREEPER_CHARGE, (resourceLocation, tickCount) -> RenderType.energySwirl((ResourceLocation)resourceLocation, (float)(tickCount.floatValue() * 0.01f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
        MobHeadBlockRenderer.putRenderType(ModelType.ENDERMAN, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.ENDERMAN_EYES, RenderType::eyes, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.HORSE, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.HORSE_MARKINGS, RenderType::entityTranslucent, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.PHANTOM, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.PHANTOM_EYES, RenderType::eyes, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SLIME_GEL, RenderType::entityTranslucent, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SPIDER, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.SPIDER_EYES, RenderType::eyes, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.TROPICAL_FISH_LARGE, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.TROPICAL_FISH_SMALL, RenderType::entityCutoutNoCull, map::put);
        MobHeadBlockRenderer.putRenderType(ModelType.VEX, RenderType::entityTranslucent, map::put);
        map.put(ModelType.WITHER_SHIELD, (resourceLocation, tickCount) -> RenderType.energySwirl((ResourceLocation)resourceLocation, (float)(Mth.cos((float)(tickCount.floatValue() * 0.02f)) * 3.0f % 1.0f), (float)(tickCount.floatValue() * 0.01f % 1.0f)));
    }));
    private final Function<ModelType, SkullModelBase> skullModelGetter;

    public MobHeadBlockRenderer(BlockEntityRendererProvider.Context context) {
        this.skullModelGetter = MobHeadBlockRenderer.createSkullModels(context.getModelSet());
    }

    private static void putRenderType(ModelType modelType, Function<ResourceLocation, RenderType> renderTypeGetter, BiConsumer<ModelType, BiFunction<ResourceLocation, Float, RenderType>> consumer) {
        consumer.accept(modelType, (resourceLocation, tickCount) -> (RenderType)renderTypeGetter.apply((ResourceLocation)resourceLocation));
    }

    public static Function<ModelType, SkullModelBase> createSkullModels(EntityModelSet entityModelSet) {
        return Util.memoize(modelType -> {
            Function<ModelPart, SkullModelBase> skullModelGetter = SKULL_MODELS.getOrDefault(modelType, SkullModel::new);
            ModelLayerLocation modelLayerLocation = MobHeadBlockRenderer.createModelLayer(modelType);
            ModelPart modelPart = entityModelSet.bakeLayer(modelLayerLocation);
            return skullModelGetter.apply(modelPart);
        });
    }

    public static ModelLayerLocation createModelLayer(ModelType modelType) {
        return new ModelLayerLocation(modelType.model(), modelType.layer());
    }

    public void render(MobHeadBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay, Vec3 cameraPos) {
        float animation = blockEntity.getAnimation(partialTick);
        BlockState blockState = blockEntity.getBlockState();
        boolean isWallSkullBlock = blockState.getBlock() instanceof WallSkullBlock;
        Direction direction = isWallSkullBlock ? (Direction)blockState.getValue((Property)WallSkullBlock.FACING) : null;
        int rotationSegment = isWallSkullBlock ? RotationSegment.convertToSegment((Direction)direction.getOpposite()) : (Integer)blockState.getValue((Property)SkullBlock.ROTATION);
        float rotationSegmentDegrees = RotationSegment.convertToDegrees((int)rotationSegment);
        MobHeadBlockRenderer.renderSkull(direction, rotationSegmentDegrees, animation, poseStack, bufferSource, packedLight, this.skullModelGetter, blockEntity.getHeadType(), false, (float)blockEntity.tickCount + partialTick);
    }

    public static void renderSkull(@Nullable Direction direction, float rotationSegmentDegrees, float animation, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, Function<ModelType, SkullModelBase> skullModelGetter, @Nullable Holder<HeadType> headType, boolean guiOffset, float tickCount) {
        Shape shape = MobHeadBlockRenderer.getShape(headType);
        for (Model model : MobHeadBlockRenderer.getModels(headType)) {
            SkullModelBase skullModelBase = skullModelGetter.apply((ModelType)model.model().model());
            RenderType renderType = MobHeadBlockRenderer.getRenderType(model.model(), tickCount);
            MobHeadBlockRenderer.renderSkull(shape, guiOffset, direction, rotationSegmentDegrees, animation, poseStack, bufferSource, model.blockLight().map(blockLight -> LightTexture.pack((int)blockLight, (int)LightTexture.sky((int)packedLight))).orElse(packedLight), skullModelBase, renderType, model.color().map(color -> color.getColor(tickCount)).orElse(-1));
        }
    }

    private static void renderSkull(Shape shape, boolean guiOffset, @Nullable Direction direction, float yRot, float mouthAnimation, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, SkullModelBase model, RenderType renderType, int color) {
        poseStack.pushPose();
        double offsetY = (16.0 - shape.sizeY()) / 2.0;
        if (direction != null) {
            double offsetX = 8.0 - (double)direction.getStepX() * (16.0 - shape.sizeX(direction)) / 2.0;
            double offsetZ = 8.0 - (double)direction.getStepZ() * (16.0 - shape.sizeZ(direction)) / 2.0;
            poseStack.translate(offsetX / 16.0, offsetY / 16.0, offsetZ / 16.0);
        } else {
            poseStack.translate(0.5f, guiOffset ? ((float)offsetY - 3.3333333f) / 16.0f : 0.0f, 0.5f);
        }
        poseStack.scale((float)(-shape.scale()), (float)(-shape.scale()), (float)shape.scale());
        VertexConsumer vertexConsumer = bufferSource.getBuffer(renderType);
        model.setupAnim(mouthAnimation, yRot, 0.0f);
        model.renderToBuffer(poseStack, vertexConsumer, packedLight, OverlayTexture.NO_OVERLAY, color);
        poseStack.popPose();
    }

    private static List<Model> getModels(Holder<HeadType> headType) {
        return headType != null ? ((HeadType)headType.value()).models() : DEFAULT_MODELS;
    }

    private static Shape getShape(Holder<HeadType> headType) {
        return headType != null ? ((HeadType)headType.value()).shape() : DEFAULT_SHAPE;
    }

    private static RenderType getRenderType(ModelAndTexture<ModelType> modelAndTexture, float tickCount) {
        BiFunction<ResourceLocation, Float, RenderType> renderTypeGetter = RENDER_TYPES.getOrDefault(modelAndTexture.model(), (resourceLocation, tickCountX) -> RenderType.entityCutoutNoCullZOffset((ResourceLocation)resourceLocation));
        return renderTypeGetter.apply(modelAndTexture.asset().texturePath(), Float.valueOf(tickCount));
    }
}

