/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init;

import com.google.common.collect.ImmutableSet;
import com.mojang.serialization.MapCodec;
import fuzs.alltheheads.AllTheHeads;
import fuzs.alltheheads.advancements.critereon.BeePredicate;
import fuzs.alltheheads.advancements.critereon.CreeperPredicate;
import fuzs.alltheheads.advancements.critereon.GhastPredicate;
import fuzs.alltheheads.advancements.critereon.HorsePredicate;
import fuzs.alltheheads.advancements.critereon.PandaPredicate;
import fuzs.alltheheads.advancements.critereon.StriderPredicate;
import fuzs.alltheheads.advancements.critereon.TropicalFishPredicate;
import fuzs.alltheheads.advancements.critereon.VexPredicate;
import fuzs.alltheheads.advancements.critereon.VillagerDataPredicate;
import fuzs.alltheheads.advancements.critereon.WolfPredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.init.ModLootTables;
import fuzs.alltheheads.init.headtype.MonsterHeadType;
import fuzs.alltheheads.init.headtype.VillagerHeadType;
import fuzs.alltheheads.world.item.MobHeadItem;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.level.block.MobHeadBlock;
import fuzs.alltheheads.world.level.block.MobHeadSkullBlock;
import fuzs.alltheheads.world.level.block.entity.MobHeadBlockEntity;
import fuzs.puzzleslib.api.init.v3.registry.ContentRegistrationHelper;
import fuzs.puzzleslib.api.init.v3.registry.RegistryManager;
import fuzs.puzzleslib.api.init.v3.tags.TagFactory;
import fuzs.puzzleslib.api.util.v1.CommonHelper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SkullBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.waypoints.Waypoint;

public class ModRegistry {
    public static final ResourceKey<Registry<HeadType>> HEAD_REGISTRY_KEY = ResourceKey.createRegistryKey((ResourceLocation)AllTheHeads.id("head"));
    public static final RegistrySetBuilder REGISTRY_SET_BUILDER = new RegistrySetBuilder().add(HEAD_REGISTRY_KEY, HeadTypes::bootstrap);
    public static final SkullBlock.Type MOB_SKULL_BLOCK_TYPE = ContentRegistrationHelper.registerSkullBlockType((ResourceLocation)AllTheHeads.id("mob"));
    static final RegistryManager REGISTRIES = RegistryManager.from((String)"alltheheads");
    public static final Holder.Reference<DataComponentType<Holder<HeadType>>> HEAD_TYPE_DATA_COMPONENT_TYPE = REGISTRIES.registerDataComponentType("head_type", builder -> builder.persistent(HeadType.CODEC).networkSynchronized(HeadType.STREAM_CODEC).cacheEncoding());
    public static final Holder.Reference<Block> MOB_HEAD_BLOCK = REGISTRIES.registerBlock("mob_head", MobHeadBlock::new, () -> BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.CUSTOM_HEAD).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Holder.Reference<Block> MOB_WALL_HEAD_BLOCK = REGISTRIES.registerBlock("mob_wall_head", MobHeadSkullBlock::new, () -> Blocks.wallVariant((Block)((Block)MOB_HEAD_BLOCK.value()), (boolean)true).strength(1.0f).pushReaction(PushReaction.DESTROY));
    public static final Holder.Reference<Item> MOB_HEAD_ITEM = REGISTRIES.registerBlockItem(MOB_HEAD_BLOCK, (block, properties) -> new MobHeadItem((Block)block, (Block)MOB_WALL_HEAD_BLOCK.value(), (Item.Properties)properties), () -> Waypoint.addHideAttribute((Item.Properties)new Item.Properties()).rarity(Rarity.UNCOMMON).equippableUnswappable(EquipmentSlot.HEAD));
    public static final Holder.Reference<BlockEntityType<MobHeadBlockEntity>> MOB_HEAD_BLOCK_ENTITY_TYPE = REGISTRIES.registerBlockEntityType("head", MobHeadBlockEntity::new, () -> ImmutableSet.of((Object)((Block)MOB_HEAD_BLOCK.value()), (Object)((Block)MOB_WALL_HEAD_BLOCK.value())));
    public static final Holder.Reference<MapCodec<VillagerDataPredicate>> VILLAGER_DATA_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "villager_data", () -> VillagerDataPredicate.CODEC);
    public static final Holder.Reference<MapCodec<VexPredicate>> VEX_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "vex", () -> VexPredicate.CODEC);
    public static final Holder.Reference<MapCodec<WolfPredicate>> WOLF_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "wolf", () -> WolfPredicate.CODEC);
    public static final Holder.Reference<MapCodec<BeePredicate>> BEE_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "bee", () -> BeePredicate.CODEC);
    public static final Holder.Reference<MapCodec<HorsePredicate>> HORSE_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "horse", () -> HorsePredicate.CODEC);
    public static final Holder.Reference<MapCodec<GhastPredicate>> GHAST_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "ghast", () -> GhastPredicate.CODEC);
    public static final Holder.Reference<MapCodec<CreeperPredicate>> CREEPER_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "creeper", () -> CreeperPredicate.CODEC);
    public static final Holder.Reference<MapCodec<PandaPredicate>> PANDA_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "panda", () -> PandaPredicate.CODEC);
    public static final Holder.Reference<MapCodec<StriderPredicate>> STRIDER_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "strider", () -> StriderPredicate.CODEC);
    public static final Holder.Reference<MapCodec<TropicalFishPredicate>> TROPICAL_FISH_ENTITY_SUB_PREDICATE_TYPE = REGISTRIES.register(Registries.ENTITY_SUB_PREDICATE_TYPE, "tropical_fish", () -> TropicalFishPredicate.CODEC);
    public static final Holder.Reference<CreativeModeTab> CREATIVE_MODE_TAB = REGISTRIES.registerCreativeModeTab("main", () -> ModRegistry.createDisplayItemStack(MonsterHeadType.BLAZE), (itemDisplayParameters, output) -> {
        output.accept((ItemLike)Items.SKELETON_SKULL);
        output.accept((ItemLike)Items.WITHER_SKELETON_SKULL);
        output.accept((ItemLike)Items.PLAYER_HEAD);
        output.accept((ItemLike)Items.ZOMBIE_HEAD);
        output.accept((ItemLike)Items.CREEPER_HEAD);
        output.accept((ItemLike)Items.PIGLIN_HEAD);
        output.accept((ItemLike)Items.DRAGON_HEAD);
        itemDisplayParameters.holders().lookupOrThrow(HEAD_REGISTRY_KEY).listElements().filter(holder -> !holder.is(VILLAGER_LIKE_HEAD_TYPE_TAG)).map(MobHeadItem::createHead).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0));
    }, true);
    public static final Holder.Reference<CreativeModeTab> VILLAGER_CREATIVE_MODE_TAB = REGISTRIES.registerCreativeModeTab("villager", () -> ModRegistry.createDisplayItemStack(VillagerHeadType.PLAINS_LIBRARIAN_VILLAGER), (itemDisplayParameters, output) -> itemDisplayParameters.holders().lookupOrThrow(HEAD_REGISTRY_KEY).listElements().filter(holder -> holder.is(VILLAGER_LIKE_HEAD_TYPE_TAG)).map(MobHeadItem::createHead).forEach(arg_0 -> ((CreativeModeTab.Output)output).accept(arg_0)), true);
    static final TagFactory TAGS = TagFactory.make((String)"alltheheads");
    public static final TagKey<HeadType> VILLAGER_LIKE_HEAD_TYPE_TAG = TAGS.registerTagKey(HEAD_REGISTRY_KEY, "villager_like");

    public static void bootstrap() {
        ModLootTables.bootstrap();
    }

    private static ItemStack createDisplayItemStack(ResourceKey<HeadType> resourceKey) {
        RegistryAccess registries = CommonHelper.getRegistryAccess();
        if (registries != null) {
            return MobHeadItem.createHead((HolderLookup.Provider)registries, resourceKey);
        }
        return new ItemStack(MOB_HEAD_ITEM);
    }
}

