/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.frog.FrogVariant;
import net.minecraft.world.entity.animal.frog.FrogVariants;

public class FrogHeadType {
    public static final ResourceKey<HeadType> TEMPERATE_FROG = HeadTypes.register("frog/temperate");
    public static final ResourceKey<HeadType> WARM_FROG = HeadTypes.register("frog/warm");
    public static final ResourceKey<HeadType> COLD_FROG = HeadTypes.register("frog/cold");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        FrogHeadType.bootstrapFrog(context, (ResourceKey<FrogVariant>)FrogVariants.TEMPERATE, TEMPERATE_FROG, "entity/frog/temperate_frog");
        FrogHeadType.bootstrapFrog(context, (ResourceKey<FrogVariant>)FrogVariants.WARM, WARM_FROG, "entity/frog/warm_frog");
        FrogHeadType.bootstrapFrog(context, (ResourceKey<FrogVariant>)FrogVariants.COLD, COLD_FROG, "entity/frog/cold_frog");
    }

    private static void bootstrapFrog(BootstrapContext<HeadType> context, ResourceKey<FrogVariant> variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.FROG).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.FROG_VARIANT, (Object)context.lookup(Registries.FROG_VARIANT).getOrThrow(variant))).build())).shape(7.0, 5.0, 5.0).scale(1.1428571428571428).model(ModelType.FROG, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.FROG_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(TEMPERATE_FROG, "Temperate Frog Head");
        translationConsumer.accept(WARM_FROG, "Warm Frog Head");
        translationConsumer.accept(COLD_FROG, "Cold Frog Head");
    }
}

