/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.advancements.critereon.HorsePredicate;
import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.entity.animal.horse.Variant;

public class HorseHeadType {
    public static final ResourceKey<HeadType> SKELETON_HORSE = HeadTypes.register("skeleton_horse");
    public static final ResourceKey<HeadType> ZOMBIE_HORSE = HeadTypes.register("zombie_horse");
    public static final ResourceKey<HeadType> DONKEY = HeadTypes.register("donkey");
    public static final ResourceKey<HeadType> MULE = HeadTypes.register("mule");
    public static final ResourceKey<HeadType> WHITE_HORSE = HeadTypes.register("horse/white");
    public static final ResourceKey<HeadType> WHITE_WHITE_HORSE = HeadTypes.register("horse/white/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_WHITE_HORSE = HeadTypes.register("horse/white/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_WHITE_HORSE = HeadTypes.register("horse/white/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_WHITE_HORSE = HeadTypes.register("horse/white/black_dots");
    public static final ResourceKey<HeadType> CREAMY_HORSE = HeadTypes.register("horse/creamy");
    public static final ResourceKey<HeadType> WHITE_CREAMY_HORSE = HeadTypes.register("horse/creamy/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_CREAMY_HORSE = HeadTypes.register("horse/creamy/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_CREAMY_HORSE = HeadTypes.register("horse/creamy/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_CREAMY_HORSE = HeadTypes.register("horse/creamy/black_dots");
    public static final ResourceKey<HeadType> CHESTNUT_HORSE = HeadTypes.register("horse/chestnut");
    public static final ResourceKey<HeadType> WHITE_CHESTNUT_HORSE = HeadTypes.register("horse/chestnut/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_CHESTNUT_HORSE = HeadTypes.register("horse/chestnut/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_CHESTNUT_HORSE = HeadTypes.register("horse/chestnut/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_CHESTNUT_HORSE = HeadTypes.register("horse/chestnut/black_dots");
    public static final ResourceKey<HeadType> BROWN_HORSE = HeadTypes.register("horse/brown");
    public static final ResourceKey<HeadType> WHITE_BROWN_HORSE = HeadTypes.register("horse/brown/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_BROWN_HORSE = HeadTypes.register("horse/brown/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_BROWN_HORSE = HeadTypes.register("horse/brown/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_BROWN_HORSE = HeadTypes.register("horse/brown/black_dots");
    public static final ResourceKey<HeadType> BLACK_HORSE = HeadTypes.register("horse/black");
    public static final ResourceKey<HeadType> WHITE_BLACK_HORSE = HeadTypes.register("horse/black/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_BLACK_HORSE = HeadTypes.register("horse/black/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_BLACK_HORSE = HeadTypes.register("horse/black/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_BLACK_HORSE = HeadTypes.register("horse/black/black_dots");
    public static final ResourceKey<HeadType> GRAY_HORSE = HeadTypes.register("horse/gray");
    public static final ResourceKey<HeadType> WHITE_GRAY_HORSE = HeadTypes.register("horse/gray/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_GRAY_HORSE = HeadTypes.register("horse/gray/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_GRAY_HORSE = HeadTypes.register("horse/gray/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_GRAY_HORSE = HeadTypes.register("horse/gray/black_dots");
    public static final ResourceKey<HeadType> DARK_BROWN_HORSE = HeadTypes.register("horse/dark_brown");
    public static final ResourceKey<HeadType> WHITE_DARK_BROWN_HORSE = HeadTypes.register("horse/dark_brown/white");
    public static final ResourceKey<HeadType> WHITE_FIELD_DARK_BROWN_HORSE = HeadTypes.register("horse/dark_brown/white_field");
    public static final ResourceKey<HeadType> WHITE_DOTS_DARK_BROWN_HORSE = HeadTypes.register("horse/dark_brown/white_dots");
    public static final ResourceKey<HeadType> BLACK_DOTS_DARK_BROWN_HORSE = HeadTypes.register("horse/dark_brown/black_dots");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        HorseHeadType.bootstrapHorse(context, EntityType.SKELETON_HORSE, SKELETON_HORSE, "entity/horse/horse_skeleton", SoundEvents.SKELETON_HORSE_AMBIENT);
        HorseHeadType.bootstrapHorse(context, EntityType.ZOMBIE_HORSE, ZOMBIE_HORSE, "entity/horse/horse_zombie", SoundEvents.ZOMBIE_HORSE_AMBIENT);
        HorseHeadType.bootstrapHorse(context, EntityType.DONKEY, DONKEY, "entity/horse/donkey", SoundEvents.DONKEY_AMBIENT);
        HorseHeadType.bootstrapHorse(context, EntityType.MULE, MULE, "entity/horse/mule", SoundEvents.MULE_AMBIENT);
        HorseHeadType.bootstrapHorse(context, Variant.WHITE, WHITE_HORSE, "entity/horse/horse_white");
        HorseHeadType.bootstrapHorse(context, Variant.WHITE, Markings.WHITE, WHITE_WHITE_HORSE, "entity/horse/horse_white", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.WHITE, Markings.WHITE_FIELD, WHITE_FIELD_WHITE_HORSE, "entity/horse/horse_white", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.WHITE, Markings.WHITE_DOTS, WHITE_DOTS_WHITE_HORSE, "entity/horse/horse_white", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.WHITE, Markings.BLACK_DOTS, BLACK_DOTS_WHITE_HORSE, "entity/horse/horse_white", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.CREAMY, CREAMY_HORSE, "entity/horse/horse_creamy");
        HorseHeadType.bootstrapHorse(context, Variant.CREAMY, Markings.WHITE, WHITE_CREAMY_HORSE, "entity/horse/horse_creamy", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.CREAMY, Markings.WHITE_FIELD, WHITE_FIELD_CREAMY_HORSE, "entity/horse/horse_creamy", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.CREAMY, Markings.WHITE_DOTS, WHITE_DOTS_CREAMY_HORSE, "entity/horse/horse_creamy", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.CREAMY, Markings.BLACK_DOTS, BLACK_DOTS_CREAMY_HORSE, "entity/horse/horse_creamy", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.CHESTNUT, CHESTNUT_HORSE, "entity/horse/horse_chestnut");
        HorseHeadType.bootstrapHorse(context, Variant.CHESTNUT, Markings.WHITE, WHITE_CHESTNUT_HORSE, "entity/horse/horse_chestnut", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.CHESTNUT, Markings.WHITE_FIELD, WHITE_FIELD_CHESTNUT_HORSE, "entity/horse/horse_chestnut", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.CHESTNUT, Markings.WHITE_DOTS, WHITE_DOTS_CHESTNUT_HORSE, "entity/horse/horse_chestnut", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.CHESTNUT, Markings.BLACK_DOTS, BLACK_DOTS_CHESTNUT_HORSE, "entity/horse/horse_chestnut", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.BROWN, BROWN_HORSE, "entity/horse/horse_brown");
        HorseHeadType.bootstrapHorse(context, Variant.BROWN, Markings.WHITE, WHITE_BROWN_HORSE, "entity/horse/horse_brown", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.BROWN, Markings.WHITE_FIELD, WHITE_FIELD_BROWN_HORSE, "entity/horse/horse_brown", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.BROWN, Markings.WHITE_DOTS, WHITE_DOTS_BROWN_HORSE, "entity/horse/horse_brown", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.BROWN, Markings.BLACK_DOTS, BLACK_DOTS_BROWN_HORSE, "entity/horse/horse_brown", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.BLACK, BLACK_HORSE, "entity/horse/horse_black");
        HorseHeadType.bootstrapHorse(context, Variant.BLACK, Markings.WHITE, WHITE_BLACK_HORSE, "entity/horse/horse_black", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.BLACK, Markings.WHITE_FIELD, WHITE_FIELD_BLACK_HORSE, "entity/horse/horse_black", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.BLACK, Markings.WHITE_DOTS, WHITE_DOTS_BLACK_HORSE, "entity/horse/horse_black", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.BLACK, Markings.BLACK_DOTS, BLACK_DOTS_BLACK_HORSE, "entity/horse/horse_black", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.GRAY, GRAY_HORSE, "entity/horse/horse_gray");
        HorseHeadType.bootstrapHorse(context, Variant.GRAY, Markings.WHITE, WHITE_GRAY_HORSE, "entity/horse/horse_gray", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.GRAY, Markings.WHITE_FIELD, WHITE_FIELD_GRAY_HORSE, "entity/horse/horse_gray", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.GRAY, Markings.WHITE_DOTS, WHITE_DOTS_GRAY_HORSE, "entity/horse/horse_gray", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.GRAY, Markings.BLACK_DOTS, BLACK_DOTS_GRAY_HORSE, "entity/horse/horse_gray", "entity/horse/horse_markings_blackdots");
        HorseHeadType.bootstrapHorse(context, Variant.DARK_BROWN, DARK_BROWN_HORSE, "entity/horse/horse_darkbrown");
        HorseHeadType.bootstrapHorse(context, Variant.DARK_BROWN, Markings.WHITE, WHITE_DARK_BROWN_HORSE, "entity/horse/horse_darkbrown", "entity/horse/horse_markings_white");
        HorseHeadType.bootstrapHorse(context, Variant.DARK_BROWN, Markings.WHITE_FIELD, WHITE_FIELD_DARK_BROWN_HORSE, "entity/horse/horse_darkbrown", "entity/horse/horse_markings_whitefield");
        HorseHeadType.bootstrapHorse(context, Variant.DARK_BROWN, Markings.WHITE_DOTS, WHITE_DOTS_DARK_BROWN_HORSE, "entity/horse/horse_darkbrown", "entity/horse/horse_markings_whitedots");
        HorseHeadType.bootstrapHorse(context, Variant.DARK_BROWN, Markings.BLACK_DOTS, BLACK_DOTS_DARK_BROWN_HORSE, "entity/horse/horse_darkbrown", "entity/horse/horse_markings_blackdots");
    }

    private static void bootstrapHorse(BootstrapContext<HeadType> context, EntityType<?> entityType, ResourceKey<HeadType> resourceKey, String textureLocation, SoundEvent noteBlockSound) {
        HeadType.builder(entityType).shape(4.0, 16.0, 8.0).scale(0.75).model(ModelType.HORSE, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(noteBlockSound).build(context, resourceKey);
    }

    private static void bootstrapHorse(BootstrapContext<HeadType> context, Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.HORSE).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.HORSE_VARIANT, (Object)variant)).build()).subPredicate((EntitySubPredicate)HorsePredicate.forMarkings(Markings.NONE))).shape(4.0, 16.0, 8.0).scale(0.75).model(ModelType.HORSE, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.HORSE_AMBIENT).build(context, resourceKey);
    }

    private static void bootstrapHorse(BootstrapContext<HeadType> context, Variant variant, Markings markings, ResourceKey<HeadType> resourceKey, String textureLocation, String markingsLocation) {
        HeadType.builder(EntityType.HORSE).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.HORSE_VARIANT, (Object)variant)).build()).subPredicate((EntitySubPredicate)HorsePredicate.forMarkings(markings))).shape(4.0, 16.0, 8.0).scale(0.75).model(ModelType.HORSE, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).model(ModelType.HORSE_MARKINGS, ResourceLocationHelper.withDefaultNamespace((String)markingsLocation)).noteBlockSound(SoundEvents.HORSE_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(SKELETON_HORSE, "Skeleton Horse Head");
        translationConsumer.accept(ZOMBIE_HORSE, "Zombie Horse Head");
        translationConsumer.accept(DONKEY, "Donkey Head");
        translationConsumer.accept(MULE, "Mule Head");
        translationConsumer.accept(WHITE_HORSE, "White Horse Head");
        translationConsumer.accept(WHITE_WHITE_HORSE, "White Blaze White Horse Head");
        translationConsumer.accept(WHITE_FIELD_WHITE_HORSE, "White Field White Horse Head");
        translationConsumer.accept(WHITE_DOTS_WHITE_HORSE, "White Spots White Horse Head");
        translationConsumer.accept(BLACK_DOTS_WHITE_HORSE, "Black Dots White Horse Head");
        translationConsumer.accept(CREAMY_HORSE, "Creamy Horse Head");
        translationConsumer.accept(WHITE_CREAMY_HORSE, "White Blaze Creamy Horse Head");
        translationConsumer.accept(WHITE_FIELD_CREAMY_HORSE, "White Field Creamy Horse Head");
        translationConsumer.accept(WHITE_DOTS_CREAMY_HORSE, "White Spots Creamy Horse Head");
        translationConsumer.accept(BLACK_DOTS_CREAMY_HORSE, "Black Dots Creamy Horse Head");
        translationConsumer.accept(CHESTNUT_HORSE, "Chestnut Horse Head");
        translationConsumer.accept(WHITE_CHESTNUT_HORSE, "White Blaze Chestnut Horse Head");
        translationConsumer.accept(WHITE_FIELD_CHESTNUT_HORSE, "White Field Chestnut Horse Head");
        translationConsumer.accept(WHITE_DOTS_CHESTNUT_HORSE, "White Spots Chestnut Horse Head");
        translationConsumer.accept(BLACK_DOTS_CHESTNUT_HORSE, "Black Dots Chestnut Horse Head");
        translationConsumer.accept(BROWN_HORSE, "Brown Horse Head");
        translationConsumer.accept(WHITE_BROWN_HORSE, "White Blaze Brown Horse Head");
        translationConsumer.accept(WHITE_FIELD_BROWN_HORSE, "White Field Brown Horse Head");
        translationConsumer.accept(WHITE_DOTS_BROWN_HORSE, "White Spots Brown Horse Head");
        translationConsumer.accept(BLACK_DOTS_BROWN_HORSE, "Black Dots Brown Horse Head");
        translationConsumer.accept(BLACK_HORSE, "Black Horse Head");
        translationConsumer.accept(WHITE_BLACK_HORSE, "White Blaze Black Horse Head");
        translationConsumer.accept(WHITE_FIELD_BLACK_HORSE, "White Field Black Horse Head");
        translationConsumer.accept(WHITE_DOTS_BLACK_HORSE, "White Spots Black Horse Head");
        translationConsumer.accept(BLACK_DOTS_BLACK_HORSE, "Black Dots Black Horse Head");
        translationConsumer.accept(GRAY_HORSE, "Gray Horse Head");
        translationConsumer.accept(WHITE_GRAY_HORSE, "White Blaze Gray Horse Head");
        translationConsumer.accept(WHITE_FIELD_GRAY_HORSE, "White Field Gray Horse Head");
        translationConsumer.accept(WHITE_DOTS_GRAY_HORSE, "White Spots Gray Horse Head");
        translationConsumer.accept(BLACK_DOTS_GRAY_HORSE, "Black Dots Gray Horse Head");
        translationConsumer.accept(DARK_BROWN_HORSE, "Dark Brown Horse Head");
        translationConsumer.accept(WHITE_DARK_BROWN_HORSE, "White Blaze Dark Brown Horse Head");
        translationConsumer.accept(WHITE_FIELD_DARK_BROWN_HORSE, "White Field Dark Brown Horse Head");
        translationConsumer.accept(WHITE_DOTS_DARK_BROWN_HORSE, "White Spots Dark Brown Horse Head");
        translationConsumer.accept(BLACK_DOTS_DARK_BROWN_HORSE, "Black Dots Dark Brown Horse Head");
    }
}

