/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;

public class IllagerHeadType {
    public static final ResourceKey<HeadType> VINDICATOR = HeadTypes.register("vindicator");
    public static final ResourceKey<HeadType> EVOKER = HeadTypes.register("evoker");
    public static final ResourceKey<HeadType> PILLAGER = HeadTypes.register("pillager");
    public static final ResourceKey<HeadType> ILLUSIONER = HeadTypes.register("illusioner");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        IllagerHeadType.bootstrapIllager(context, EntityType.VINDICATOR, VINDICATOR, "entity/illager/vindicator", SoundEvents.VINDICATOR_AMBIENT);
        IllagerHeadType.bootstrapIllager(context, EntityType.EVOKER, EVOKER, "entity/illager/evoker", SoundEvents.EVOKER_AMBIENT);
        IllagerHeadType.bootstrapIllager(context, EntityType.PILLAGER, PILLAGER, "entity/illager/pillager", SoundEvents.PILLAGER_AMBIENT);
        IllagerHeadType.bootstrapIllager(context, EntityType.ILLUSIONER, ILLUSIONER, "entity/illager/illusioner", SoundEvents.ILLUSIONER_AMBIENT);
    }

    private static void bootstrapIllager(BootstrapContext<HeadType> context, EntityType<?> entityType, ResourceKey<HeadType> resourceKey, String textureLocation, SoundEvent noteBlockSound) {
        HeadType.builder(entityType).shape(8.0, 10.0, 8.0).scale(0.9375).model(ModelType.ILLAGER, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(noteBlockSound).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(VINDICATOR, "Vindicator Head");
        translationConsumer.accept(EVOKER, "Evoker Head");
        translationConsumer.accept(PILLAGER, "Pillager Head");
        translationConsumer.accept(ILLUSIONER, "Illusioner Head");
    }
}

