/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.handler;

import com.google.common.base.Suppliers;
import fuzs.alltheheads.data.tags.ModHeadTypeTagsProvider;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.alltheheads.world.item.MobHeadItem;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.puzzleslib.api.event.v1.core.EventResult;
import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.NestedLootTable;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;

public class HeadLootHandler {
    private static final Supplier<Map<ResourceLocation, TagKey<HeadType>>> HEAD_TAGS = Suppliers.memoize(() -> ModHeadTypeTagsProvider.getDefaultLootTables(BuiltInRegistries.ENTITY_TYPE.stream()).collect(Collectors.toMap(ResourceKey::location, ModHeadTypeTagsProvider::getHeadTypeTagKey)));

    public static EventResult onLivingDrops(LivingEntity livingEntity, DamageSource damageSource, Collection<ItemEntity> itemDrops, boolean recentlyHit) {
        Level level = livingEntity.level();
        if (level instanceof ServerLevel) {
            Creeper creeper;
            Entity entity;
            ServerLevel serverLevel = (ServerLevel)level;
            if (livingEntity.shouldDropLoot() && (entity = damageSource.getEntity()) instanceof Creeper && (creeper = (Creeper)entity).canDropMobsSkull()) {
                livingEntity.registryAccess().lookupOrThrow(ModRegistry.HEAD_REGISTRY_KEY).listElements().forEach(headType -> {
                    if (((HeadType)headType.value()).loot().chargedCreeperDrop() && ((HeadType)headType.value()).matches((Entity)livingEntity)) {
                        ItemStack itemStack = MobHeadItem.createHead((Holder<HeadType>)headType);
                        livingEntity.spawnAtLocation(serverLevel, itemStack);
                        creeper.increaseDroppedSkulls();
                    }
                });
            }
        }
        return EventResult.PASS;
    }

    public static void onLootTableLoad(ResourceLocation resourceLocation, LootTable.Builder lootTable, HolderLookup.Provider registries) {
        if (HEAD_TAGS.get().containsKey(resourceLocation)) {
            registries.lookupOrThrow(ModRegistry.HEAD_REGISTRY_KEY).get(HEAD_TAGS.get().get(resourceLocation)).ifPresent(holderSet -> holderSet.forEach(headType -> ((HeadType)headType.value()).loot().lootTable().ifPresent(resourceKey -> lootTable.withPool(LootPool.lootPool().add(NestedLootTable.lootTableReference((ResourceKey)resourceKey).when(LootItemEntityPropertyCondition.hasProperties((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate)((HeadType)headType.value()).entityPredicate())))))));
        }
    }
}

