/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Rabbit;

public class RabbitHeadType {
    public static final ResourceKey<HeadType> BROWN_RABBIT = HeadTypes.register("rabbit/brown");
    public static final ResourceKey<HeadType> WHITE_RABBIT = HeadTypes.register("rabbit/white");
    public static final ResourceKey<HeadType> BLACK_RABBIT = HeadTypes.register("rabbit/black");
    public static final ResourceKey<HeadType> WHITE_SPLOTCHED_RABBIT = HeadTypes.register("rabbit/white_splotched");
    public static final ResourceKey<HeadType> GOLD_RABBIT = HeadTypes.register("rabbit/gold");
    public static final ResourceKey<HeadType> SALT_RABBIT = HeadTypes.register("rabbit/salt");
    public static final ResourceKey<HeadType> EVIL_RABBIT = HeadTypes.register("rabbit/evil");
    public static final ResourceKey<HeadType> TOAST_RABBIT = HeadTypes.register("rabbit/toast");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.BROWN, BROWN_RABBIT, "entity/rabbit/brown");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.WHITE, WHITE_RABBIT, "entity/rabbit/white");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.BLACK, BLACK_RABBIT, "entity/rabbit/black");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.WHITE_SPLOTCHED, WHITE_SPLOTCHED_RABBIT, "entity/rabbit/white_splotched");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.GOLD, GOLD_RABBIT, "entity/rabbit/gold");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.SALT, SALT_RABBIT, "entity/rabbit/salt");
        RabbitHeadType.bootstrapRabbit(context, Rabbit.Variant.EVIL, EVIL_RABBIT, "entity/rabbit/caerbannog", SoundEvents.RABBIT_ATTACK);
        HeadType.builder(EntityType.RABBIT).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Toast"))).build())).shape(5.0, 4.0, 5.0).scale(1.2).model(ModelType.RABBIT, ResourceLocationHelper.withDefaultNamespace((String)"entity/rabbit/toast")).noteBlockSound(SoundEvents.RABBIT_AMBIENT).build(context, TOAST_RABBIT);
    }

    private static void bootstrapRabbit(BootstrapContext<HeadType> context, Rabbit.Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        RabbitHeadType.bootstrapRabbit(context, variant, resourceKey, textureLocation, SoundEvents.RABBIT_AMBIENT);
    }

    private static void bootstrapRabbit(BootstrapContext<HeadType> context, Rabbit.Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation, SoundEvent noteBlockSound) {
        HeadType.builder(EntityType.RABBIT).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.RABBIT_VARIANT, (Object)variant)).build())).shape(5.0, 4.0, 5.0).scale(1.2).model(ModelType.RABBIT, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(noteBlockSound).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(BLACK_RABBIT, "Black Rabbit Head");
        translationConsumer.accept(BROWN_RABBIT, "Brown Rabbit Head");
        translationConsumer.accept(EVIL_RABBIT, "Evil Rabbit Head");
        translationConsumer.accept(GOLD_RABBIT, "Gold Rabbit Head");
        translationConsumer.accept(SALT_RABBIT, "Salt Rabbit Head");
        translationConsumer.accept(TOAST_RABBIT, "Toast Rabbit Head");
        translationConsumer.accept(WHITE_RABBIT, "White Rabbit Head");
        translationConsumer.accept(WHITE_SPLOTCHED_RABBIT, "White Splotched Rabbit Head");
    }
}

