/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.google.common.collect.ImmutableList;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Loot;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.EntityTypePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.variant.ModelAndTexture;
import net.minecraft.world.level.storage.loot.LootTable;

public final class Builder {
    private final List<Consumer<EntityPredicate.Builder>> entityPredicate = new ArrayList<Consumer<EntityPredicate.Builder>>();
    private Shape shape = new Shape(8.0, 8.0, 8.0);
    private double scale = 1.0;
    private final List<Model> models = new ArrayList<Model>();
    private Optional<Holder<SoundEvent>> noteBlockSound = Optional.empty();
    private Optional<ResourceKey<LootTable>> lootTable = Optional.empty();
    private boolean chargedCreeperDrop = true;
    private boolean mobDisguise = true;
    private Optional<String> customName = Optional.empty();

    Builder(EntityType<?> entityType) {
        this.entityPredicate(builder -> builder.entityType(EntityTypePredicate.of((HolderGetter)BuiltInRegistries.ENTITY_TYPE, (EntityType)entityType)));
    }

    public Builder entityPredicate(Consumer<EntityPredicate.Builder> entityPredicate) {
        this.entityPredicate.add(entityPredicate);
        return this;
    }

    public Builder shape(double width, double height, double depth) {
        return this.shape(new Shape(width, height, depth));
    }

    public Builder shape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public Builder scale(double scale) {
        this.scale = scale;
        return this;
    }

    public Builder model(ModelType modelType, ResourceLocation assetId) {
        this.models.add(new Model(modelType, assetId));
        return this;
    }

    public Builder dyedModel(ModelType modelType, ResourceLocation assetId, Color color) {
        this.models.add(new Model((ModelAndTexture<ModelType>)new ModelAndTexture((Object)modelType, assetId), Optional.of(color), Optional.empty()));
        return this;
    }

    public Builder litModel(ModelType modelType, ResourceLocation assetId) {
        this.models.add(new Model((ModelAndTexture<ModelType>)new ModelAndTexture((Object)modelType, assetId), Optional.empty(), Optional.of(15)));
        return this;
    }

    public Builder noteBlockSound(SoundEvent noteBlockSound) {
        this.noteBlockSound = Optional.of(BuiltInRegistries.SOUND_EVENT.wrapAsHolder((Object)noteBlockSound));
        return this;
    }

    public Builder noteBlockSound(Holder<SoundEvent> noteBlockSound) {
        this.noteBlockSound = Optional.of(noteBlockSound);
        return this;
    }

    public Builder lootTable(ResourceKey<HeadType> resourceKey) {
        this.lootTable = Optional.of(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)resourceKey.location().withPrefix("entities/heads/")));
        return this;
    }

    public Builder chargedCreeperDrop(boolean chargedCreeperDrop) {
        this.chargedCreeperDrop = chargedCreeperDrop;
        return this;
    }

    public Builder mobDisguise(boolean mobDisguise) {
        this.mobDisguise = mobDisguise;
        return this;
    }

    public Builder customName(ResourceKey<HeadType> resourceKey) {
        this.customName = Optional.of(HeadType.customName(resourceKey).toLanguageKey());
        return this;
    }

    public void build(BootstrapContext<HeadType> context, ResourceKey<HeadType> resourceKey) {
        this.lootTable(resourceKey).customName(resourceKey);
        context.register(resourceKey, (Object)new HeadType(this.buildEntityPredicate(), this.shape.scale(this.scale), this.buildLoot(), this.customName, this.mobDisguise, this.noteBlockSound, (List<Model>)ImmutableList.copyOf(this.models)));
    }

    private EntityPredicate buildEntityPredicate() {
        EntityPredicate.Builder builder = EntityPredicate.Builder.entity();
        this.entityPredicate.forEach(builderConsumer -> builderConsumer.accept(builder));
        return builder.build();
    }

    private Loot buildLoot() {
        return new Loot(this.lootTable, this.chargedCreeperDrop);
    }
}

