/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.google.common.collect.Maps;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.AllTheHeads;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;

public interface Color {
    public static final ExtraCodecs.LateBoundIdMapper<ResourceLocation, MapCodec<? extends Color>> ID_MAPPER = (ExtraCodecs.LateBoundIdMapper)Util.make((Object)new ExtraCodecs.LateBoundIdMapper(), idMapper -> {
        idMapper.put((Object)AllTheHeads.id("constant"), Constant.CODEC);
        idMapper.put((Object)AllTheHeads.id("dye"), Dye.CODEC);
        idMapper.put((Object)AllTheHeads.id("sheep"), Sheep.CODEC);
        idMapper.put((Object)AllTheHeads.id("rainbow"), Rainbow.CODEC);
    });
    public static final Codec<Color> CODEC = ID_MAPPER.codec(ResourceLocation.CODEC).dispatch(Color::type, Function.identity());

    public MapCodec<? extends Color> type();

    public int getColor(float var1);

    public record Constant(int value) implements Color
    {
        public static final MapCodec<Constant> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)ExtraCodecs.RGB_COLOR_CODEC.fieldOf("value").forGetter(Constant::value)).apply((Applicative)instance, Constant::new));

        public Constant(int value) {
            this.value = ARGB.opaque((int)value);
        }

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return this.value;
        }
    }

    public record Dye(DyeColor dye) implements Color
    {
        public static final MapCodec<Dye> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("dye").forGetter(Dye::dye)).apply((Applicative)instance, Dye::new));

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return this.dye.getTextureDiffuseColor();
        }
    }

    public record Sheep(DyeColor dye) implements Color
    {
        public static final MapCodec<Sheep> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)DyeColor.CODEC.fieldOf("dye").forGetter(Sheep::dye)).apply((Applicative)instance, Sheep::new));
        static final Map<DyeColor, Integer> COLOR_BY_DYE = (Map)Arrays.stream(DyeColor.values()).collect(Maps.toImmutableEnumMap(Function.identity(), Sheep::getModifiedColor));

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return COLOR_BY_DYE.get(this.dye);
        }

        static int getModifiedColor(DyeColor color) {
            return Sheep.getModifiedColor(color, 0.75f);
        }

        static int getModifiedColor(DyeColor color, float brightness) {
            if (color == DyeColor.WHITE) {
                return -1644826;
            }
            int i = color.getTextureDiffuseColor();
            return ARGB.color((int)255, (int)Mth.floor((float)((float)ARGB.red((int)i) * brightness)), (int)Mth.floor((float)((float)ARGB.green((int)i) * brightness)), (int)Mth.floor((float)((float)ARGB.blue((int)i) * brightness)));
        }
    }

    public record Rainbow() implements Color
    {
        public static final MapCodec<Rainbow> CODEC = MapCodec.unit((Object)new Rainbow());
        private static final DyeColor[] COLORS = DyeColor.values();
        private static final int COLOR_DURATION = 25;

        @Override
        public MapCodec<? extends Color> type() {
            return CODEC;
        }

        @Override
        public int getColor(float tickCount) {
            return Rainbow.getLerpedColor(tickCount);
        }

        static int getLerpedColor(float time) {
            int i = Mth.floor((float)time);
            int j = i / 25;
            int k = COLORS.length;
            int l = j % k;
            int m = (j + 1) % k;
            float f = ((float)(i % 25) + Mth.frac((float)time)) / 25.0f;
            int n = Sheep.COLOR_BY_DYE.get(COLORS[l]);
            int o = Sheep.COLOR_BY_DYE.get(COLORS[m]);
            return ARGB.lerp((float)f, (int)n, (int)o);
        }
    }
}

