/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.world.item.component.headtype;

import com.google.common.collect.ImmutableList;
import fuzs.alltheheads.world.item.component.headtype.Color;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.Loot;
import fuzs.alltheheads.world.item.component.headtype.Model;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.alltheheads.world.item.component.headtype.Shape;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_10693;
import net.minecraft.class_1299;
import net.minecraft.class_2048;
import net.minecraft.class_2050;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7891;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class Builder {
    private final List<Consumer<class_2048.class_2049>> entityPredicate = new ArrayList<Consumer<class_2048.class_2049>>();
    private Shape shape = new Shape(8.0, 8.0, 8.0);
    private double scale = 1.0;
    private final List<Model> models = new ArrayList<Model>();
    private Optional<class_6880<class_3414>> noteBlockSound = Optional.empty();
    private Optional<class_5321<class_52>> lootTable = Optional.empty();
    private boolean chargedCreeperDrop = true;
    private boolean mobDisguise = true;
    private Optional<String> customName = Optional.empty();

    Builder(class_1299<?> entityType) {
        this.entityPredicate(builder -> builder.method_8917(class_2050.method_8929((class_7871)class_7923.field_41177, (class_1299)entityType)));
    }

    public Builder entityPredicate(Consumer<class_2048.class_2049> entityPredicate) {
        this.entityPredicate.add(entityPredicate);
        return this;
    }

    public Builder shape(double width, double height, double depth) {
        return this.shape(new Shape(width, height, depth));
    }

    public Builder shape(Shape shape) {
        this.shape = shape;
        return this;
    }

    public Builder scale(double scale) {
        this.scale = scale;
        return this;
    }

    public Builder model(ModelType modelType, class_2960 assetId) {
        this.models.add(new Model(modelType, assetId));
        return this;
    }

    public Builder dyedModel(ModelType modelType, class_2960 assetId, Color color) {
        this.models.add(new Model((class_10693<ModelType>)new class_10693((Object)modelType, assetId), Optional.of(color), Optional.empty()));
        return this;
    }

    public Builder litModel(ModelType modelType, class_2960 assetId) {
        this.models.add(new Model((class_10693<ModelType>)new class_10693((Object)modelType, assetId), Optional.empty(), Optional.of(15)));
        return this;
    }

    public Builder noteBlockSound(class_3414 noteBlockSound) {
        this.noteBlockSound = Optional.of(class_7923.field_41172.method_47983((Object)noteBlockSound));
        return this;
    }

    public Builder noteBlockSound(class_6880<class_3414> noteBlockSound) {
        this.noteBlockSound = Optional.of(noteBlockSound);
        return this;
    }

    public Builder lootTable(class_5321<HeadType> resourceKey) {
        this.lootTable = Optional.of(class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)resourceKey.method_29177().method_45138("entities/heads/")));
        return this;
    }

    public Builder chargedCreeperDrop(boolean chargedCreeperDrop) {
        this.chargedCreeperDrop = chargedCreeperDrop;
        return this;
    }

    public Builder mobDisguise(boolean mobDisguise) {
        this.mobDisguise = mobDisguise;
        return this;
    }

    public Builder customName(class_5321<HeadType> resourceKey) {
        this.customName = Optional.of(HeadType.customName(resourceKey).method_42094());
        return this;
    }

    public void build(class_7891<HeadType> context, class_5321<HeadType> resourceKey) {
        this.lootTable(resourceKey).customName(resourceKey);
        context.method_46838(resourceKey, (Object)new HeadType(this.buildEntityPredicate(), this.shape.scale(this.scale), this.buildLoot(), this.customName, this.mobDisguise, this.noteBlockSound, (List<Model>)ImmutableList.copyOf(this.models)));
    }

    private class_2048 buildEntityPredicate() {
        class_2048.class_2049 builder = class_2048.class_2049.method_8916();
        this.entityPredicate.forEach(builderConsumer -> builderConsumer.accept(builder));
        return builder.method_8920();
    }

    private Loot buildLoot() {
        return new Loot(this.lootTable, this.chargedCreeperDrop);
    }
}

