/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record CreeperPredicate(Optional<Boolean> powered) implements EntitySubPredicate
{
    public static final MapCodec<CreeperPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("powered").forGetter(CreeperPredicate::powered)).apply((Applicative)instance, CreeperPredicate::new));

    public MapCodec<CreeperPredicate> codec() {
        return (MapCodec)ModRegistry.CREEPER_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Creeper)) {
            return false;
        }
        Creeper creeper = (Creeper)entity;
        return !this.powered.isPresent() || creeper.isPowered() == this.powered.get().booleanValue();
    }

    public static CreeperPredicate isPowered(boolean powered) {
        return new CreeperPredicate(Optional.of(powered));
    }
}

