/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import fuzs.puzzleslib.api.util.v1.CodecExtras;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Markings;
import net.minecraft.world.phys.Vec3;

public record HorsePredicate(Optional<Markings> markings) implements EntitySubPredicate
{
    public static final MapCodec<HorsePredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)CodecExtras.fromEnum(Markings.class).optionalFieldOf("markings").forGetter(HorsePredicate::markings)).apply((Applicative)instance, HorsePredicate::new));

    public MapCodec<HorsePredicate> codec() {
        return (MapCodec)ModRegistry.HORSE_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, Vec3 position) {
        if (!(entity instanceof Horse)) {
            return false;
        }
        Horse horse = (Horse)entity;
        return !this.markings.isPresent() || horse.getMarkings() == this.markings.get();
    }

    public static HorsePredicate forMarkings(Markings markings) {
        return new HorsePredicate(Optional.of(markings));
    }
}

