/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record PandaPredicate(Optional<Panda.Gene> variant) implements EntitySubPredicate
{
    public static final MapCodec<PandaPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Panda.Gene.CODEC.optionalFieldOf("variant").forGetter(PandaPredicate::variant)).apply((Applicative)instance, PandaPredicate::new));

    public MapCodec<PandaPredicate> codec() {
        return (MapCodec)ModRegistry.PANDA_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Panda)) {
            return false;
        }
        Panda panda = (Panda)entity;
        return !this.variant.isPresent() || panda.getVariant() == this.variant.get();
    }

    public static PandaPredicate hasVariant(Panda.Gene variant) {
        return new PandaPredicate(Optional.of(variant));
    }
}

