/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record VexPredicate(Optional<Boolean> charging) implements EntitySubPredicate
{
    public static final MapCodec<VexPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("charging").forGetter(VexPredicate::charging)).apply((Applicative)instance, VexPredicate::new));

    public MapCodec<VexPredicate> codec() {
        return (MapCodec)ModRegistry.VEX_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Vex)) {
            return false;
        }
        Vex vex = (Vex)entity;
        return this.charging.isPresent() && vex.isCharging() == this.charging.get().booleanValue();
    }

    public static VexPredicate isCharging(boolean charging) {
        return new VexPredicate(Optional.of(charging));
    }
}

