/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import fuzs.alltheheads.init.ModRegistry;
import java.util.Optional;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public record WolfPredicate(Optional<Boolean> angry, Optional<Boolean> tame) implements EntitySubPredicate
{
    public static final MapCodec<WolfPredicate> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.BOOL.optionalFieldOf("angry").forGetter(WolfPredicate::angry), (App)Codec.BOOL.optionalFieldOf("tame").forGetter(WolfPredicate::tame)).apply((Applicative)instance, WolfPredicate::new));

    public MapCodec<WolfPredicate> codec() {
        return (MapCodec)ModRegistry.WOLF_ENTITY_SUB_PREDICATE_TYPE.value();
    }

    public boolean matches(Entity entity, ServerLevel level, @Nullable Vec3 position) {
        if (!(entity instanceof Wolf)) {
            return false;
        }
        Wolf wolf = (Wolf)entity;
        if (this.angry.isPresent() && wolf.isAngry() != this.angry.get().booleanValue()) {
            return false;
        }
        return !this.tame.isPresent() || wolf.isTame() == this.tame.get().booleanValue();
    }

    public static WolfPredicate isAngry() {
        return new WolfPredicate(Optional.of(true), Optional.empty());
    }

    public static WolfPredicate isTame() {
        return new WolfPredicate(Optional.empty(), Optional.of(true));
    }
}

