/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.advancements.critereon.DataComponentMatchers;
import net.minecraft.core.component.DataComponentExactPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.CowVariant;
import net.minecraft.world.entity.animal.CowVariants;
import net.minecraft.world.entity.animal.MushroomCow;

public class CowHeadType {
    public static final ResourceKey<HeadType> TEMPERATE_COW = HeadTypes.register("cow/temperate");
    public static final ResourceKey<HeadType> WARM_COW = HeadTypes.register("cow/warm");
    public static final ResourceKey<HeadType> COLD_COW = HeadTypes.register("cow/cold");
    public static final ResourceKey<HeadType> RED_MOOSHROOM = HeadTypes.register("mooshroom/red");
    public static final ResourceKey<HeadType> BROWN_MOOSHROOM = HeadTypes.register("mooshroom/brown");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        CowHeadType.bootstrapCow(context, (ResourceKey<CowVariant>)CowVariants.TEMPERATE, TEMPERATE_COW, ModelType.TEMPERATE_COW, "entity/cow/temperate_cow");
        CowHeadType.bootstrapCow(context, (ResourceKey<CowVariant>)CowVariants.WARM, WARM_COW, ModelType.WARM_COW, "entity/cow/warm_cow");
        CowHeadType.bootstrapCow(context, (ResourceKey<CowVariant>)CowVariants.COLD, COLD_COW, ModelType.COLD_COW, "entity/cow/cold_cow");
        CowHeadType.bootstrapMooshroom(context, MushroomCow.Variant.RED, RED_MOOSHROOM, "entity/cow/red_mooshroom");
        CowHeadType.bootstrapMooshroom(context, MushroomCow.Variant.BROWN, BROWN_MOOSHROOM, "entity/cow/brown_mooshroom");
    }

    private static void bootstrapCow(BootstrapContext<HeadType> context, ResourceKey<CowVariant> variant, ResourceKey<HeadType> resourceKey, ModelType modelType, String textureLocation) {
        HeadType.builder(EntityType.COW).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.COW_VARIANT, (Object)context.lookup(Registries.COW_VARIANT).getOrThrow(variant))).build())).shape(8.0, 8.0, 6.0).model(modelType, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.COW_AMBIENT).build(context, resourceKey);
    }

    private static void bootstrapMooshroom(BootstrapContext<HeadType> context, MushroomCow.Variant variant, ResourceKey<HeadType> resourceKey, String textureLocation) {
        HeadType.builder(EntityType.MOOSHROOM).entityPredicate(builder -> builder.components(DataComponentMatchers.Builder.components().exact(DataComponentExactPredicate.expect((DataComponentType)DataComponents.MOOSHROOM_VARIANT, (Object)variant)).build())).shape(8.0, 8.0, 6.0).model(ModelType.TEMPERATE_COW, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(SoundEvents.COW_AMBIENT).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(TEMPERATE_COW, "Temperate Cow Head");
        translationConsumer.accept(WARM_COW, "Warm Cow Head");
        translationConsumer.accept(COLD_COW, "Cold Cow Head");
        translationConsumer.accept(RED_MOOSHROOM, "Red Mooshroom Head");
        translationConsumer.accept(BROWN_MOOSHROOM, "Brown Mooshroom Head");
    }
}

