/*
 * Decompiled with CFR 0.152.
 */
package fuzs.alltheheads.init.headtype;

import fuzs.alltheheads.init.HeadTypes;
import fuzs.alltheheads.world.item.component.headtype.HeadType;
import fuzs.alltheheads.world.item.component.headtype.ModelType;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.util.function.BiConsumer;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;

public class GuardianHeadType {
    public static final ResourceKey<HeadType> GUARDIAN = HeadTypes.register("guardian");
    public static final ResourceKey<HeadType> ELDER_GUARDIAN = HeadTypes.register("elder_guardian");

    public static void bootstrap(BootstrapContext<HeadType> context) {
        GuardianHeadType.bootstrapGuardian(context, EntityType.GUARDIAN, GUARDIAN, "entity/guardian", SoundEvents.GUARDIAN_AMBIENT_LAND);
        GuardianHeadType.bootstrapGuardian(context, EntityType.ELDER_GUARDIAN, ELDER_GUARDIAN, "entity/guardian_elder", SoundEvents.ELDER_GUARDIAN_AMBIENT_LAND);
    }

    private static void bootstrapGuardian(BootstrapContext<HeadType> context, EntityType<?> entityType, ResourceKey<HeadType> resourceKey, String textureLocation, SoundEvent noteBlockSound) {
        HeadType.builder(entityType).shape(16.0, 16.0, 16.0).scale(0.5).model(ModelType.GUARDIAN, ResourceLocationHelper.withDefaultNamespace((String)textureLocation)).noteBlockSound(noteBlockSound).build(context, resourceKey);
    }

    public static void registerTranslations(BiConsumer<ResourceKey<HeadType>, String> translationConsumer) {
        translationConsumer.accept(GUARDIAN, "Guardian Head");
        translationConsumer.accept(ELDER_GUARDIAN, "Elder Guardian Head");
    }
}

